/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.payload.internal;

import io.github.springwolf.asyncapi.v3.model.components.ComponentSchema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadSchemaObject;
import io.github.springwolf.core.configuration.properties.SpringwolfConfigProperties;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PayloadService.class);
    private final ComponentsService componentsService;
    private final SpringwolfConfigProperties properties;
    private static final String PAYLOAD_NOT_USED_KEY = "PayloadNotUsed";
    public static final PayloadSchemaObject PAYLOAD_NOT_USED = new PayloadSchemaObject("PayloadNotUsed", "PayloadNotUsed", ComponentSchema.of((SchemaObject)SchemaObject.builder().type("object").title("PayloadNotUsed").description("No payload specified").properties(Map.of()).build()));

    public PayloadSchemaObject buildSchema(Type payloadType) {
        String contentType = this.properties.getDocket().getDefaultContentType();
        return this.buildSchema(contentType, payloadType);
    }

    public PayloadSchemaObject buildSchema(String contentType, Type payloadType) {
        String schemaName = this.componentsService.getSchemaName(payloadType);
        String simpleSchemaName = this.componentsService.getSimpleSchemaName(payloadType);
        ComponentSchema schema = this.componentsService.resolvePayloadSchema(payloadType, contentType);
        return new PayloadSchemaObject(schemaName, simpleSchemaName, schema);
    }

    public PayloadSchemaObject useUnusedPayload() {
        ComponentSchema schema = PAYLOAD_NOT_USED.schema();
        if (schema != null && schema.getSchema() != null) {
            this.componentsService.registerSchema(schema.getSchema());
        }
        return PAYLOAD_NOT_USED;
    }

    @Generated
    public PayloadService(ComponentsService componentsService, SpringwolfConfigProperties properties) {
        this.componentsService = componentsService;
        this.properties = properties;
    }
}

