/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.payload.internal;

import io.github.springwolf.core.configuration.properties.SpringwolfConfigProperties;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TypeExtractor.class);
    private final Map<String, Integer> extractableClassToArgumentIndex;

    public TypeExtractor(SpringwolfConfigProperties properties) {
        this.extractableClassToArgumentIndex = properties.getPayload() != null ? properties.getPayload().getExtractableClasses() : Map.of();
    }

    public Type extractActualType(Type parameterType) {
        try {
            return this.extractActualTypeUnsafe(parameterType);
        }
        catch (Exception ex) {
            log.debug("Unable to extract class for type {}", (Object)parameterType.getTypeName(), (Object)ex);
            return Void.class;
        }
    }

    private Type extractActualTypeUnsafe(Type parameterType) {
        ParameterizedType typeParameterized;
        String typeName;
        Type type = parameterType;
        while (type instanceof ParameterizedType && this.extractableClassToArgumentIndex.containsKey(typeName = (typeParameterized = (ParameterizedType)type).getRawType().getTypeName())) {
            Integer index = this.extractableClassToArgumentIndex.get(typeName);
            type = typeParameterized.getActualTypeArguments()[index];
            if (!(type instanceof WildcardType)) continue;
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            Type[] lowerBounds = ((WildcardType)type).getLowerBounds();
            if (upperBounds.length > 0 && upperBounds[0] != Object.class) {
                type = upperBounds[0];
            }
            if (lowerBounds.length <= 0 || lowerBounds[0] == Object.class) continue;
            type = lowerBounds[0];
        }
        return type;
    }
}

