/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.utils;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class TextUtils {
    private TextUtils() {
    }

    public static String trimIndent(String text) {
        if (text == null) {
            return null;
        }
        String newLine = System.lineSeparator();
        String[] lines = text.split(newLine);
        int firstNonEmptyLine = TextUtils.findFirstNonEmptyIndex(lines);
        if (firstNonEmptyLine == -1) {
            return text;
        }
        lines = Arrays.copyOfRange(lines, firstNonEmptyLine, lines.length);
        int minIndent = TextUtils.resolveMinIndent(lines);
        String result = Arrays.stream(lines).map(line -> line.substring(Math.min(line.length(), minIndent))).reduce((a, b) -> a + newLine + b).orElse("");
        if (StringUtils.endsWith((CharSequence)text, (CharSequence)"\n")) {
            result = result.concat(newLine);
        }
        return result;
    }

    private static int findFirstNonEmptyIndex(String[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].trim().isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private static int resolveMinIndent(String[] lines) {
        return Arrays.stream(lines).filter(line -> !line.trim().isEmpty()).mapToInt(line -> StringUtils.indexOfAnyBut((CharSequence)line, (char[])new char[]{' '})).filter(i -> i >= 0).min().orElse(0);
    }
}

