/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.operations;

import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OperationMerger {
    private OperationMerger() {
    }

    public static Map<String, Operation> mergeOperations(List<Operation> operations) {
        HashMap<String, Operation> mergedOperations = new HashMap<String, Operation>();
        for (Operation operation : operations) {
            if (!mergedOperations.containsKey(operation.getOperationId())) {
                mergedOperations.put(operation.getOperationId(), operation);
                continue;
            }
            Operation mergedOperation = OperationMerger.mergeOperation((Operation)mergedOperations.get(operation.getOperationId()), operation);
            mergedOperations.put(operation.getOperationId(), mergedOperation);
        }
        return mergedOperations;
    }

    private static Operation mergeOperation(Operation operation, Operation otherOperation) {
        Operation mergedOperation = operation != null ? operation : otherOperation;
        List<MessageReference> mergedMessages = OperationMerger.mergeMessageReferences(operation.getMessages(), otherOperation.getMessages());
        if (!mergedMessages.isEmpty()) {
            mergedOperation.setMessages(mergedMessages);
        }
        return mergedOperation;
    }

    private static List<MessageReference> mergeMessageReferences(Collection<MessageReference> messages, Collection<MessageReference> otherMessages) {
        HashSet<MessageReference> messageReferences = new HashSet<MessageReference>();
        if (messages != null) {
            messageReferences.addAll(messages);
        }
        if (otherMessages != null) {
            messageReferences.addAll(otherMessages);
        }
        return messageReferences.stream().sorted(Comparator.comparing(MessageReference::getRef)).toList();
    }
}

