/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.operations.annotations;

import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.core.asyncapi.annotations.AsyncOperation;
import io.github.springwolf.core.asyncapi.scanners.common.AsyncAnnotationProvider;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AllMethods;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AnnotationScannerUtil;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AnnotationUtil;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.MethodAndAnnotation;
import io.github.springwolf.core.asyncapi.scanners.common.operation.AsyncAnnotationOperationService;
import io.github.springwolf.core.asyncapi.scanners.operations.OperationsInClassScanner;
import io.github.springwolf.core.asyncapi.scanners.operations.annotations.OperationCustomizer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAnnotationClassLevelOperationsScanner<ClassAnnotation extends Annotation>
implements OperationsInClassScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncAnnotationClassLevelOperationsScanner.class);
    private final Class<ClassAnnotation> classAnnotationClass;
    private final AsyncAnnotationProvider<ClassAnnotation> asyncAnnotationProvider;
    private final AsyncAnnotationOperationService<ClassAnnotation> asyncAnnotationOperationsService;
    private final List<OperationCustomizer> customizers;

    @Override
    public Stream<Operation> scan(Class<?> clazz) {
        Set<MethodAndAnnotation<ClassAnnotation>> methodAndAnnotation = AnnotationScannerUtil.findAnnotatedMethods(clazz, this.classAnnotationClass, AllMethods.class, (cl, m) -> {
            Object classAnnotation = AnnotationUtil.findFirstAnnotation(this.classAnnotationClass, clazz);
            return m.stream().map(method -> new MethodAndAnnotation<Annotation>(method.method(), (Annotation)classAnnotation));
        }).collect(Collectors.toSet());
        if (methodAndAnnotation.isEmpty()) {
            return Stream.empty();
        }
        return this.mapClassToOperation(clazz, methodAndAnnotation);
    }

    private Stream<Operation> mapClassToOperation(Class<?> component, Set<MethodAndAnnotation<ClassAnnotation>> annotatedMethods) {
        ClassAnnotation classAnnotation = AnnotationUtil.findFirstAnnotationOrThrow(this.classAnnotationClass, component);
        AsyncOperation asyncOperation = this.asyncAnnotationProvider.getAsyncOperation(classAnnotation);
        Set<Method> methods = annotatedMethods.stream().map(MethodAndAnnotation::method).collect(Collectors.toSet());
        Operation operation = this.asyncAnnotationOperationsService.buildOperation(asyncOperation, methods);
        annotatedMethods.forEach(method -> this.customizers.forEach(customizer -> customizer.customize(operation, method.method())));
        return Stream.of(operation);
    }

    @Generated
    public AsyncAnnotationClassLevelOperationsScanner(Class<ClassAnnotation> classAnnotationClass, AsyncAnnotationProvider<ClassAnnotation> asyncAnnotationProvider, AsyncAnnotationOperationService<ClassAnnotation> asyncAnnotationOperationsService, List<OperationCustomizer> customizers) {
        this.classAnnotationClass = classAnnotationClass;
        this.asyncAnnotationProvider = asyncAnnotationProvider;
        this.asyncAnnotationOperationsService = asyncAnnotationOperationsService;
        this.customizers = customizers;
    }
}

