/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.operations.annotations;

import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.core.asyncapi.annotations.AsyncOperation;
import io.github.springwolf.core.asyncapi.scanners.common.AsyncAnnotationProvider;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AnnotationScannerUtil;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.MethodAndAnnotation;
import io.github.springwolf.core.asyncapi.scanners.common.operation.AsyncAnnotationOperationService;
import io.github.springwolf.core.asyncapi.scanners.operations.OperationsInClassScanner;
import io.github.springwolf.core.asyncapi.scanners.operations.annotations.OperationCustomizer;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAnnotationMethodLevelOperationsScanner<MethodAnnotation extends Annotation>
implements OperationsInClassScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncAnnotationMethodLevelOperationsScanner.class);
    private final AsyncAnnotationProvider<MethodAnnotation> asyncAnnotationProvider;
    private final AsyncAnnotationOperationService<MethodAnnotation> asyncAnnotationOperationService;
    private final List<OperationCustomizer> customizers;

    @Override
    public Stream<Operation> scan(Class<?> clazz) {
        return AnnotationScannerUtil.findAnnotatedMethods(clazz, this.asyncAnnotationProvider.getAnnotation()).map(this::mapMethodToOperation);
    }

    private Operation mapMethodToOperation(MethodAndAnnotation<MethodAnnotation> methodAndAnnotation) {
        AsyncOperation operationAnnotation = this.asyncAnnotationProvider.getAsyncOperation((Annotation)methodAndAnnotation.annotation());
        Operation operation = this.asyncAnnotationOperationService.buildOperation(operationAnnotation, Set.of(methodAndAnnotation.method()));
        this.customizers.forEach(customizer -> customizer.customize(operation, methodAndAnnotation.method()));
        return operation;
    }

    @Generated
    public AsyncAnnotationMethodLevelOperationsScanner(AsyncAnnotationProvider<MethodAnnotation> asyncAnnotationProvider, AsyncAnnotationOperationService<MethodAnnotation> asyncAnnotationOperationService, List<OperationCustomizer> customizers) {
        this.asyncAnnotationProvider = asyncAnnotationProvider;
        this.asyncAnnotationOperationService = asyncAnnotationOperationService;
        this.customizers = customizers;
    }
}

