/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.operations.annotations;

import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AnnotationScannerUtil;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.MethodAndAnnotation;
import io.github.springwolf.core.asyncapi.scanners.common.headers.HeaderClassExtractor;
import io.github.springwolf.core.asyncapi.scanners.common.operation.SpringAnnotationOperationService;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadMethodParameterService;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadSchemaObject;
import io.github.springwolf.core.asyncapi.scanners.operations.OperationsInClassScanner;
import io.github.springwolf.core.asyncapi.scanners.operations.annotations.OperationCustomizer;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringAnnotationMethodLevelOperationsScanner<MethodAnnotation extends Annotation>
implements OperationsInClassScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAnnotationMethodLevelOperationsScanner.class);
    private final Class<MethodAnnotation> methodAnnotationClass;
    private final HeaderClassExtractor headerClassExtractor;
    private final PayloadMethodParameterService payloadMethodParameterService;
    private final SpringAnnotationOperationService<MethodAnnotation> springAnnotationOperationService;
    private final List<OperationCustomizer> customizers;

    @Override
    public Stream<Operation> scan(Class<?> clazz) {
        return AnnotationScannerUtil.findAnnotatedMethods(clazz, this.methodAnnotationClass).map(this::mapMethodToOperation);
    }

    private Operation mapMethodToOperation(MethodAndAnnotation<MethodAnnotation> method) {
        PayloadSchemaObject payloadSchema = this.payloadMethodParameterService.extractSchema(method.method());
        SchemaObject headerSchema = this.headerClassExtractor.extractHeader(method.method(), payloadSchema);
        Operation operation = this.springAnnotationOperationService.buildOperation(method, payloadSchema, headerSchema);
        this.customizers.forEach(customizer -> customizer.customize(operation, method.method()));
        return operation;
    }

    @Generated
    public SpringAnnotationMethodLevelOperationsScanner(Class<MethodAnnotation> methodAnnotationClass, HeaderClassExtractor headerClassExtractor, PayloadMethodParameterService payloadMethodParameterService, SpringAnnotationOperationService<MethodAnnotation> springAnnotationOperationService, List<OperationCustomizer> customizers) {
        this.methodAnnotationClass = methodAnnotationClass;
        this.headerClassExtractor = headerClassExtractor;
        this.payloadMethodParameterService = payloadMethodParameterService;
        this.springAnnotationOperationService = springAnnotationOperationService;
        this.customizers = customizers;
    }
}

