/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.schemas;

import com.fasterxml.jackson.databind.JavaType;
import io.github.springwolf.asyncapi.v3.model.components.ComponentSchema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.core.asyncapi.annotations.AsyncApiPayload;
import io.github.springwolf.core.asyncapi.components.postprocessors.SchemasPostProcessor;
import io.github.springwolf.core.asyncapi.schemas.SwaggerSchemaUtil;
import io.github.springwolf.core.configuration.properties.SpringwolfConfigProperties;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.jackson.TypeNameResolver;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.core.util.RefUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerSchemaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwaggerSchemaService.class);
    private final ModelConverters converter = ModelConverters.getInstance();
    private final List<SchemasPostProcessor> schemaPostProcessors;
    private final SwaggerSchemaUtil swaggerSchemaUtil;
    private final SpringwolfConfigProperties properties;

    public SwaggerSchemaService(List<ModelConverter> externalModelConverters, List<SchemasPostProcessor> schemaPostProcessors, SwaggerSchemaUtil swaggerSchemaUtil, SpringwolfConfigProperties properties) {
        externalModelConverters.forEach(arg_0 -> ((ModelConverters)this.converter).addConverter(arg_0));
        this.schemaPostProcessors = schemaPostProcessors;
        this.swaggerSchemaUtil = swaggerSchemaUtil;
        this.properties = properties;
    }

    public SchemaObject extractSchema(SchemaObject headers) {
        String schemaName = headers.getTitle();
        ObjectSchema headerSchema = new ObjectSchema();
        headerSchema.setName(schemaName);
        headerSchema.setTitle(headers.getTitle());
        headerSchema.setDescription(headers.getDescription());
        Map<String, io.swagger.v3.oas.models.media.Schema> properties = headers.getProperties().entrySet().stream().map(property -> Map.entry((String)property.getKey(), this.swaggerSchemaUtil.mapToSwagger((SchemaObject)property.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        headerSchema.setProperties(properties);
        Map<String, ObjectSchema> newSchemasToProcess = Map.of(schemaName, headerSchema);
        this.postProcessSchemas(newSchemasToProcess, new HashMap<String, ObjectSchema>(newSchemasToProcess), "application/json");
        return this.swaggerSchemaUtil.mapSchema((io.swagger.v3.oas.models.media.Schema)headerSchema);
    }

    public ExtractedSchemas extractSchema(Class<?> type) {
        return this.resolveSchema(type, "");
    }

    public ExtractedSchemas resolveSchema(Type type, String contentType) {
        String actualContentType = StringUtils.isBlank((CharSequence)contentType) ? this.properties.getDocket().getDefaultContentType() : contentType;
        ResolvedSchema resolvedSchema = this.runWithFqnSetting(unused -> this.converter.resolveAsResolvedSchema(new AnnotatedType(type).resolveAsRef(true)));
        if (resolvedSchema == null) {
            SchemaObject payloadSchema = this.swaggerSchemaUtil.mapSchema(PrimitiveType.fromType(String.class).createProperty());
            return new ExtractedSchemas(ComponentSchema.of((SchemaObject)payloadSchema), Map.of());
        }
        LinkedHashMap<String, io.swagger.v3.oas.models.media.Schema> newSchemasToProcess = new LinkedHashMap<String, io.swagger.v3.oas.models.media.Schema>(resolvedSchema.referencedSchemas);
        newSchemasToProcess.putIfAbsent(this.getNameFromType(type), resolvedSchema.schema);
        this.preProcessSchemas(resolvedSchema.schema, newSchemasToProcess, type);
        HashMap<String, io.swagger.v3.oas.models.media.Schema> processedSchemas = new HashMap<String, io.swagger.v3.oas.models.media.Schema>(newSchemasToProcess);
        this.postProcessSchemas(newSchemasToProcess, processedSchemas, actualContentType);
        return new ExtractedSchemas(this.swaggerSchemaUtil.mapSchemaOrRef(resolvedSchema.schema), this.swaggerSchemaUtil.mapSchemasMap(processedSchemas));
    }

    private void preProcessSchemas(io.swagger.v3.oas.models.media.Schema payloadSchema, Map<String, io.swagger.v3.oas.models.media.Schema> schemas, Type type) {
        this.processCommonModelConverters(payloadSchema, schemas);
        this.processAsyncApiPayloadAnnotation(schemas, type);
        this.processSchemaAnnotation(payloadSchema, type);
    }

    private void processCommonModelConverters(io.swagger.v3.oas.models.media.Schema payloadSchema, Map<String, io.swagger.v3.oas.models.media.Schema> schemas) {
        schemas.values().stream().filter(schema -> schema.getType() == null).filter(schema -> schema.get$ref() != null).forEach(schema -> {
            String targetSchemaName = schema.getName();
            String sourceSchemaName = StringUtils.substringAfterLast((String)schema.get$ref(), (String)"/");
            io.swagger.v3.oas.models.media.Schema actualSchema = (io.swagger.v3.oas.models.media.Schema)schemas.get(sourceSchemaName);
            if (actualSchema != null) {
                schemas.put(targetSchemaName, actualSchema);
                schemas.remove(sourceSchemaName);
                this.adaptPayloadSchema(payloadSchema, targetSchemaName, sourceSchemaName);
            }
        });
    }

    private void adaptPayloadSchema(io.swagger.v3.oas.models.media.Schema schema, String targetSchemaName, String sourceSchemaName) {
        String refTypeName;
        if (schema != null && schema.get$ref() != null && (refTypeName = StringUtils.substringAfterLast((String)schema.get$ref(), (String)"/")).equals(sourceSchemaName)) {
            schema.$ref(RefUtils.constructRef((String)targetSchemaName));
        }
    }

    private void processSchemaAnnotation(io.swagger.v3.oas.models.media.Schema payloadSchema, Type type) {
        Schema schemaAnnotation;
        JavaType javaType = Json.mapper().constructType(type);
        Class clazz = javaType.getRawClass();
        if (payloadSchema != null && (schemaAnnotation = clazz.getAnnotation(Schema.class)) != null && StringUtils.isNotBlank((CharSequence)schemaAnnotation.description())) {
            payloadSchema.setDescription(schemaAnnotation.description());
        }
    }

    private void processAsyncApiPayloadAnnotation(Map<String, io.swagger.v3.oas.models.media.Schema> schemas, Type type) {
        JavaType javaType = Json.mapper().constructType(type);
        Class clazz = javaType.getRawClass();
        List<Field> withPayloadAnnotatedFields = Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(AsyncApiPayload.class)).toList();
        if (withPayloadAnnotatedFields.size() == 1) {
            String schemaName = this.getNameFromType(type);
            String fieldName = withPayloadAnnotatedFields.get(0).getName();
            schemas.entrySet().stream().filter(e -> ((String)e.getKey()).equals(schemaName)).filter(e -> e.getValue() != null).filter(e -> ((io.swagger.v3.oas.models.media.Schema)e.getValue()).getProperties() != null).forEach(e -> e.setValue((io.swagger.v3.oas.models.media.Schema)((io.swagger.v3.oas.models.media.Schema)e.getValue()).getProperties().get(fieldName)));
        } else if (withPayloadAnnotatedFields.size() > 1) {
            log.warn("Found more than one field with @AsyncApiPayload annotation in class {}. Falling back and ignoring annotation.", (Object)type.getTypeName());
        }
    }

    private <R> R runWithFqnSetting(Function<Void, R> callable) {
        boolean previousUseFqn = TypeNameResolver.std.getUseFqn();
        TypeNameResolver.std.setUseFqn(this.properties.isUseFqn());
        R result = callable.apply(null);
        TypeNameResolver.std.setUseFqn(previousUseFqn);
        return result;
    }

    public String getNameFromType(Type type) {
        PrimitiveType primitiveType = PrimitiveType.fromType((Type)type);
        if (primitiveType != null && this.properties.isUseFqn()) {
            return primitiveType.getKeyClass().getName();
        }
        JavaType javaType = Json.mapper().constructType(type);
        return this.runWithFqnSetting(unused -> TypeNameResolver.std.nameForType(javaType, new TypeNameResolver.Options[0]));
    }

    public String getSimpleNameFromType(Type type) {
        JavaType javaType = Json.mapper().constructType(type);
        TypeNameResolver.std.setUseFqn(false);
        String name = TypeNameResolver.std.nameForType(javaType, new TypeNameResolver.Options[0]);
        TypeNameResolver.std.setUseFqn(this.properties.isUseFqn());
        return name;
    }

    private void postProcessSchemas(Map<String, io.swagger.v3.oas.models.media.Schema> schemasToProcess, Map<String, io.swagger.v3.oas.models.media.Schema> schemas, String contentType) {
        boolean schemasHadEntries = !schemas.isEmpty();
        block0: for (io.swagger.v3.oas.models.media.Schema schema : schemasToProcess.values()) {
            for (SchemasPostProcessor processor : this.schemaPostProcessors) {
                processor.process(schema, schemas, contentType);
                if (!schemasHadEntries || schemas.containsValue(schema)) continue;
                continue block0;
            }
        }
    }

    public record ExtractedSchemas(ComponentSchema rootSchema, Map<String, SchemaObject> referencedSchemas) {
    }
}

