/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.configuration.docket;

import io.github.springwolf.asyncapi.v3.model.channel.ChannelObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.info.Info;
import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.asyncapi.v3.model.operation.OperationAction;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;

public class AsyncApiGroup {
    private final String groupName;
    private final Info groupInfo;
    private final List<OperationAction> operationActionsToKeep;
    private final List<Pattern> channelNamesToKeep;
    private final List<Pattern> messageNamesToKeep;

    public boolean isMatch(MessageObject messageObject) {
        return this.getMessageNamesToKeep().stream().anyMatch(pattern -> pattern.matcher(messageObject.getMessageId()).matches());
    }

    public boolean isMatch(Operation operation) {
        return this.getOperationActionsToKeep().contains(operation.getAction());
    }

    public boolean isMatch(ChannelObject channelObject) {
        return this.getChannelNamesToKeep().stream().anyMatch(pattern -> pattern.matcher(channelObject.getAddress()).matches());
    }

    @Generated
    private static Info $default$groupInfo() {
        return Info.builder().build();
    }

    @Generated
    private static List<OperationAction> $default$operationActionsToKeep() {
        return Collections.emptyList();
    }

    @Generated
    private static List<Pattern> $default$channelNamesToKeep() {
        return Collections.emptyList();
    }

    @Generated
    private static List<Pattern> $default$messageNamesToKeep() {
        return Collections.emptyList();
    }

    @Generated
    public static AsyncApiGroupBuilder builder() {
        return new AsyncApiGroupBuilder();
    }

    @Generated
    public AsyncApiGroup(String groupName, Info groupInfo, List<OperationAction> operationActionsToKeep, List<Pattern> channelNamesToKeep, List<Pattern> messageNamesToKeep) {
        this.groupName = groupName;
        this.groupInfo = groupInfo;
        this.operationActionsToKeep = operationActionsToKeep;
        this.channelNamesToKeep = channelNamesToKeep;
        this.messageNamesToKeep = messageNamesToKeep;
    }

    @Generated
    public String getGroupName() {
        return this.groupName;
    }

    @Generated
    public Info getGroupInfo() {
        return this.groupInfo;
    }

    @Generated
    public List<OperationAction> getOperationActionsToKeep() {
        return this.operationActionsToKeep;
    }

    @Generated
    public List<Pattern> getChannelNamesToKeep() {
        return this.channelNamesToKeep;
    }

    @Generated
    public List<Pattern> getMessageNamesToKeep() {
        return this.messageNamesToKeep;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncApiGroup)) {
            return false;
        }
        AsyncApiGroup other = (AsyncApiGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        Info this$groupInfo = this.getGroupInfo();
        Info other$groupInfo = other.getGroupInfo();
        if (this$groupInfo == null ? other$groupInfo != null : !this$groupInfo.equals(other$groupInfo)) {
            return false;
        }
        List<OperationAction> this$operationActionsToKeep = this.getOperationActionsToKeep();
        List<OperationAction> other$operationActionsToKeep = other.getOperationActionsToKeep();
        if (this$operationActionsToKeep == null ? other$operationActionsToKeep != null : !((Object)this$operationActionsToKeep).equals(other$operationActionsToKeep)) {
            return false;
        }
        List<Pattern> this$channelNamesToKeep = this.getChannelNamesToKeep();
        List<Pattern> other$channelNamesToKeep = other.getChannelNamesToKeep();
        if (this$channelNamesToKeep == null ? other$channelNamesToKeep != null : !((Object)this$channelNamesToKeep).equals(other$channelNamesToKeep)) {
            return false;
        }
        List<Pattern> this$messageNamesToKeep = this.getMessageNamesToKeep();
        List<Pattern> other$messageNamesToKeep = other.getMessageNamesToKeep();
        return !(this$messageNamesToKeep == null ? other$messageNamesToKeep != null : !((Object)this$messageNamesToKeep).equals(other$messageNamesToKeep));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AsyncApiGroup;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        Info $groupInfo = this.getGroupInfo();
        result = result * 59 + ($groupInfo == null ? 43 : $groupInfo.hashCode());
        List<OperationAction> $operationActionsToKeep = this.getOperationActionsToKeep();
        result = result * 59 + ($operationActionsToKeep == null ? 43 : ((Object)$operationActionsToKeep).hashCode());
        List<Pattern> $channelNamesToKeep = this.getChannelNamesToKeep();
        result = result * 59 + ($channelNamesToKeep == null ? 43 : ((Object)$channelNamesToKeep).hashCode());
        List<Pattern> $messageNamesToKeep = this.getMessageNamesToKeep();
        result = result * 59 + ($messageNamesToKeep == null ? 43 : ((Object)$messageNamesToKeep).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AsyncApiGroup(groupName=" + this.getGroupName() + ", groupInfo=" + String.valueOf(this.getGroupInfo()) + ", operationActionsToKeep=" + String.valueOf(this.getOperationActionsToKeep()) + ", channelNamesToKeep=" + String.valueOf(this.getChannelNamesToKeep()) + ", messageNamesToKeep=" + String.valueOf(this.getMessageNamesToKeep()) + ")";
    }

    @Generated
    public static class AsyncApiGroupBuilder {
        @Generated
        private String groupName;
        @Generated
        private boolean groupInfo$set;
        @Generated
        private Info groupInfo$value;
        @Generated
        private boolean operationActionsToKeep$set;
        @Generated
        private List<OperationAction> operationActionsToKeep$value;
        @Generated
        private boolean channelNamesToKeep$set;
        @Generated
        private List<Pattern> channelNamesToKeep$value;
        @Generated
        private boolean messageNamesToKeep$set;
        @Generated
        private List<Pattern> messageNamesToKeep$value;

        @Generated
        AsyncApiGroupBuilder() {
        }

        @Generated
        public AsyncApiGroupBuilder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        @Generated
        public AsyncApiGroupBuilder groupInfo(Info groupInfo) {
            this.groupInfo$value = groupInfo;
            this.groupInfo$set = true;
            return this;
        }

        @Generated
        public AsyncApiGroupBuilder operationActionsToKeep(List<OperationAction> operationActionsToKeep) {
            this.operationActionsToKeep$value = operationActionsToKeep;
            this.operationActionsToKeep$set = true;
            return this;
        }

        @Generated
        public AsyncApiGroupBuilder channelNamesToKeep(List<Pattern> channelNamesToKeep) {
            this.channelNamesToKeep$value = channelNamesToKeep;
            this.channelNamesToKeep$set = true;
            return this;
        }

        @Generated
        public AsyncApiGroupBuilder messageNamesToKeep(List<Pattern> messageNamesToKeep) {
            this.messageNamesToKeep$value = messageNamesToKeep;
            this.messageNamesToKeep$set = true;
            return this;
        }

        @Generated
        public AsyncApiGroup build() {
            Info groupInfo$value = this.groupInfo$value;
            if (!this.groupInfo$set) {
                groupInfo$value = AsyncApiGroup.$default$groupInfo();
            }
            List<OperationAction> operationActionsToKeep$value = this.operationActionsToKeep$value;
            if (!this.operationActionsToKeep$set) {
                operationActionsToKeep$value = AsyncApiGroup.$default$operationActionsToKeep();
            }
            List<Pattern> channelNamesToKeep$value = this.channelNamesToKeep$value;
            if (!this.channelNamesToKeep$set) {
                channelNamesToKeep$value = AsyncApiGroup.$default$channelNamesToKeep();
            }
            List<Pattern> messageNamesToKeep$value = this.messageNamesToKeep$value;
            if (!this.messageNamesToKeep$set) {
                messageNamesToKeep$value = AsyncApiGroup.$default$messageNamesToKeep();
            }
            return new AsyncApiGroup(this.groupName, groupInfo$value, operationActionsToKeep$value, channelNamesToKeep$value, messageNamesToKeep$value);
        }

        @Generated
        public String toString() {
            return "AsyncApiGroup.AsyncApiGroupBuilder(groupName=" + this.groupName + ", groupInfo$value=" + String.valueOf(this.groupInfo$value) + ", operationActionsToKeep$value=" + String.valueOf(this.operationActionsToKeep$value) + ", channelNamesToKeep$value=" + String.valueOf(this.channelNamesToKeep$value) + ", messageNamesToKeep$value=" + String.valueOf(this.messageNamesToKeep$value) + ")";
        }
    }
}

