/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.configuration.docket;

import io.github.springwolf.asyncapi.v3.model.info.Info;
import io.github.springwolf.asyncapi.v3.model.server.Server;
import io.github.springwolf.core.configuration.docket.AsyncApiDocket;
import io.github.springwolf.core.configuration.docket.AsyncApiDocketService;
import io.github.springwolf.core.configuration.docket.AsyncApiInfoMapper;
import io.github.springwolf.core.configuration.properties.SpringwolfConfigProperties;
import jakarta.annotation.Nullable;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultAsyncApiDocketService
implements AsyncApiDocketService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAsyncApiDocketService.class);
    private final SpringwolfConfigProperties configProperties;
    @Nullable
    private AsyncApiDocket docket;

    @Override
    public AsyncApiDocket getAsyncApiDocket() {
        if (this.docket == null) {
            this.docket = this.createDocket();
        }
        return this.docket;
    }

    private AsyncApiDocket createDocket() {
        if (this.configProperties.getDocket() == null || !StringUtils.hasText((String)this.configProperties.getDocket().getBasePackage())) {
            throw new IllegalArgumentException("One or more required fields (docket, basePackage) in application.properties with path prefix springwolf is not set.");
        }
        AsyncApiDocket.AsyncApiDocketBuilder builder = AsyncApiDocket.builder().basePackage(this.configProperties.getDocket().getBasePackage()).info(DefaultAsyncApiDocketService.buildInfo(this.configProperties.getDocket().getInfo())).servers(DefaultAsyncApiDocketService.buildServers(this.configProperties.getDocket().getServers()));
        if (this.configProperties.getDocket().getId() != null) {
            builder.id(this.configProperties.getDocket().getId());
        }
        if (this.configProperties.getDocket().getDefaultContentType() != null) {
            builder.defaultContentType(this.configProperties.getDocket().getDefaultContentType());
        }
        return builder.build();
    }

    private static Info buildInfo(@Nullable SpringwolfConfigProperties.ConfigDocket.Info configDocketInfo) {
        if (configDocketInfo == null || !StringUtils.hasText((String)configDocketInfo.getVersion()) || !StringUtils.hasText((String)configDocketInfo.getTitle())) {
            throw new IllegalArgumentException("One or more required fields of the info object (title, version) in application.properties with path prefix springwolf is not set.");
        }
        return AsyncApiInfoMapper.mapInfo(configDocketInfo);
    }

    private static Map<String, Server> buildServers(Map<String, Server> servers) {
        if (servers == null || servers.isEmpty()) {
            throw new IllegalArgumentException("No server has been defined in application.properties with path prefix springwolf");
        }
        servers.forEach((serverName, server) -> {
            if (!StringUtils.hasText((String)server.getProtocol()) || !StringUtils.hasText((String)server.getHost())) {
                throw new IllegalArgumentException("One or more required fields (protocol, host) of the server object (name=" + serverName + ") has not been defined in application.properties with path prefix springwolf");
            }
        });
        return servers;
    }

    @Generated
    public DefaultAsyncApiDocketService(SpringwolfConfigProperties configProperties) {
        this.configProperties = configProperties;
    }
}

