/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.springwolf.asyncapi.v3.jackson.AsyncApiSerializerService;
import io.github.springwolf.asyncapi.v3.model.AsyncAPI;
import io.github.springwolf.core.asyncapi.AsyncApiService;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AsyncApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncApiController.class);
    private final AsyncApiService asyncApiService;
    private final AsyncApiSerializerService serializer;

    @GetMapping(path={"${springwolf.paths.docs:/springwolf/docs}", "${springwolf.paths.docs:/springwolf/docs}.json", "${springwolf.path.base:/springwolf}${springwolf.path.docs:/docs}", "${springwolf.path.base:/springwolf}${springwolf.path.docs:/docs}.json", "${springwolf.path.base:/springwolf}${springwolf.path.docs:/docs}/{group}"}, produces={"application/json"})
    public String asyncApiJson(@PathVariable(required=false) Optional<String> group) throws JsonProcessingException {
        return this.serializer.toJsonString((Object)this.getAsyncAPI(group));
    }

    @GetMapping(path={"${springwolf.paths.docs:/springwolf/docs}", "${springwolf.paths.docs:/springwolf/docs}.yaml", "${springwolf.path.base:/springwolf}${springwolf.path.docs:/docs}", "${springwolf.path.base:/springwolf}${springwolf.path.docs:/docs}.yaml", "${springwolf.path.base:/springwolf}${springwolf.path.docs:/docs}/{group}"}, produces={"application/yaml"})
    public String asyncApiYaml(@PathVariable(required=false) Optional<String> group) throws JsonProcessingException {
        return this.serializer.toYaml((Object)this.getAsyncAPI(group));
    }

    private AsyncAPI getAsyncAPI(Optional<String> group) {
        log.debug("Returning AsyncApi document for group {}", (Object)group.orElse("default"));
        return group.map(groupName -> this.asyncApiService.getForGroupName((String)groupName).orElseThrow(() -> new IllegalArgumentException("AsyncAPI group %s was not found".formatted(groupName)))).orElseGet(this.asyncApiService::getAsyncAPI);
    }

    @Generated
    public AsyncApiController(AsyncApiService asyncApiService, AsyncApiSerializerService serializer) {
        this.asyncApiService = asyncApiService;
        this.serializer = serializer;
    }
}

