/*
 * Decompiled with CFR 0.152.
 */
package atu.testng.reports;

import atu.testng.reports.exceptions.ATUReporterStepFailedException;
import atu.testng.reports.logging.LogAs;
import atu.testng.reports.utils.AuthorDetails;
import atu.testng.reports.utils.Directory;
import atu.testng.reports.utils.Platform;
import atu.testng.reports.utils.Steps;
import atu.testng.selenium.reports.CaptureScreen;
import com.google.common.io.Files;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Augmenter;
import org.testng.ITestResult;
import org.testng.Reporter;

public class ATUReports {
    private static WebDriver driver;
    public static final int MAX_BAR_REPORTS = 10;
    public static final String MESSAGE = "ATU Reporter: Preparing Reports";
    public static String indexPageDescription;
    public static String currentRunDescription;
    private static String screenShotNumber;
    private static long lastExecutionTime;
    private static long currentExecutionTime;
    public static final String EMPTY = "";
    public static final String STEP_NUM = "STEP";
    public static final String PASSED_BUT_FAILED = "passedButFailed";

    public static void setWebDriver(WebDriver webDriver) {
        driver = webDriver;
        Platform.prepareDetails(driver);
    }

    public static WebDriver getWebDriver() {
        return driver;
    }

    public static void setAuthorInfo(String string, String string2, String string3) {
        AuthorDetails authorDetails = new AuthorDetails();
        authorDetails.setAuthorName(string);
        authorDetails.setCreationDate(string2);
        authorDetails.setVersion(string3);
        Reporter.getCurrentTestResult().setAttribute("authorInfo", (Object)authorDetails);
    }

    public static void setTestCaseReqCoverage(String string) {
        Reporter.getCurrentTestResult().setAttribute("reqCoverage", (Object)string);
    }

    private static void stepFailureHandler(ITestResult iTestResult, Steps steps, LogAs logAs) {
        if (logAs == LogAs.FAILED) {
            ATUReports.buildReportData(steps);
            if (!Directory.continueExecutionAfterStepFailed) {
                throw new ATUReporterStepFailedException();
            }
            iTestResult.setAttribute(PASSED_BUT_FAILED, (Object)PASSED_BUT_FAILED);
            return;
        }
        ATUReports.buildReportData(steps);
    }

    public static void add(String string, LogAs logAs, CaptureScreen captureScreen) {
        if (captureScreen != null) {
            if (captureScreen.isCaptureBrowserPage()) {
                ATUReports.takeBrowserPageScreenShot();
            } else if (captureScreen.isCaptureDesktop()) {
                ATUReports.takeDesktopScreenshot();
            } else if (captureScreen.isCaptureWebElement()) {
                ATUReports.takeWebElementScreenShot(captureScreen.getElement());
            }
        }
        Steps steps = new Steps();
        steps.setDescription(string);
        steps.setInputValue(EMPTY);
        steps.setExpectedValue(EMPTY);
        steps.setActualValue(EMPTY);
        steps.setTime(ATUReports.getExecutionTime());
        steps.setLineNum(ATUReports.getLineNumDesc());
        steps.setScreenShot(screenShotNumber);
        steps.setLogAs(logAs);
        ATUReports.stepFailureHandler(Reporter.getCurrentTestResult(), steps, logAs);
    }

    public static void add(String string, String string2, LogAs logAs, CaptureScreen captureScreen) {
        if (captureScreen != null) {
            if (captureScreen.isCaptureBrowserPage()) {
                ATUReports.takeBrowserPageScreenShot();
            } else if (captureScreen.isCaptureDesktop()) {
                ATUReports.takeDesktopScreenshot();
            } else if (captureScreen.isCaptureWebElement()) {
                ATUReports.takeWebElementScreenShot(captureScreen.getElement());
            }
        }
        Steps steps = new Steps();
        steps.setDescription(string);
        steps.setInputValue(string2);
        steps.setExpectedValue(EMPTY);
        steps.setActualValue(EMPTY);
        steps.setTime(ATUReports.getExecutionTime());
        steps.setLineNum(ATUReports.getLineNumDesc());
        steps.setScreenShot(screenShotNumber);
        steps.setLogAs(logAs);
        ATUReports.stepFailureHandler(Reporter.getCurrentTestResult(), steps, logAs);
    }

    public static void add(String string, String string2, String string3, LogAs logAs, CaptureScreen captureScreen) {
        if (captureScreen != null) {
            if (captureScreen.isCaptureBrowserPage()) {
                ATUReports.takeBrowserPageScreenShot();
            } else if (captureScreen.isCaptureDesktop()) {
                ATUReports.takeDesktopScreenshot();
            } else if (captureScreen.isCaptureWebElement()) {
                ATUReports.takeWebElementScreenShot(captureScreen.getElement());
            }
        }
        Steps steps = new Steps();
        steps.setDescription(string);
        steps.setInputValue(EMPTY);
        steps.setExpectedValue(string2);
        steps.setActualValue(string3);
        steps.setTime(ATUReports.getExecutionTime());
        steps.setLineNum(ATUReports.getLineNumDesc());
        steps.setScreenShot(screenShotNumber);
        steps.setLogAs(logAs);
        ATUReports.stepFailureHandler(Reporter.getCurrentTestResult(), steps, logAs);
    }

    public static void add(String string, String string2, String string3, String string4, LogAs logAs, CaptureScreen captureScreen) {
        if (captureScreen != null) {
            if (captureScreen.isCaptureBrowserPage()) {
                ATUReports.takeBrowserPageScreenShot();
            } else if (captureScreen.isCaptureDesktop()) {
                ATUReports.takeDesktopScreenshot();
            } else if (captureScreen.isCaptureWebElement()) {
                ATUReports.takeWebElementScreenShot(captureScreen.getElement());
            }
        }
        Steps steps = new Steps();
        steps.setDescription(string);
        steps.setInputValue(string2);
        steps.setExpectedValue(string3);
        steps.setActualValue(string4);
        steps.setTime(ATUReports.getExecutionTime());
        steps.setLineNum(ATUReports.getLineNumDesc());
        steps.setScreenShot(screenShotNumber);
        steps.setLogAs(logAs);
        ATUReports.stepFailureHandler(Reporter.getCurrentTestResult(), steps, logAs);
    }

    private static void buildReportData(Steps steps) {
        screenShotNumber = null;
        int n = Reporter.getOutput().size() + 1;
        Reporter.getCurrentTestResult().setAttribute(STEP_NUM + n, (Object)steps);
        Reporter.log((String)(STEP_NUM + n));
    }

    private static String getExecutionTime() {
        currentExecutionTime = System.currentTimeMillis();
        long l = currentExecutionTime - lastExecutionTime;
        if (l > 1000L) {
            lastExecutionTime = currentExecutionTime;
            return (l /= 1000L) + " Sec";
        }
        lastExecutionTime = currentExecutionTime;
        return l + " Milli Sec";
    }

    private static String getLineNumDesc() {
        String string = EMPTY + Thread.currentThread().getStackTrace()[3].getLineNumber();
        return string;
    }

    private static void takeDesktopScreenshot() {
        if (!Directory.takeScreenshot) {
            return;
        }
        ITestResult iTestResult = Reporter.getCurrentTestResult();
        String string = iTestResult.getAttribute("reportDir").toString() + Directory.SEP + Directory.IMGDIRName;
        screenShotNumber = Reporter.getOutput((ITestResult)Reporter.getCurrentTestResult()).size() + 1 + EMPTY;
        File file = new File(string + Directory.SEP + screenShotNumber + ".PNG");
        try {
            Rectangle rectangle = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
            BufferedImage bufferedImage = new Robot().createScreenCapture(rectangle);
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        }
        catch (Exception exception) {
            screenShotNumber = null;
        }
    }

    private static void takeBrowserPageScreenShot() {
        if (!Directory.takeScreenshot) {
            return;
        }
        if (ATUReports.getWebDriver() == null) {
            screenShotNumber = null;
            return;
        }
        ITestResult iTestResult = Reporter.getCurrentTestResult();
        String string = iTestResult.getAttribute("reportDir").toString() + Directory.SEP + Directory.IMGDIRName;
        screenShotNumber = Reporter.getOutput((ITestResult)Reporter.getCurrentTestResult()).size() + 1 + EMPTY;
        File file = new File(string + Directory.SEP + screenShotNumber + ".PNG");
        try {
            WebDriver webDriver = ATUReports.getWebDriver().getClass().getName().equals("org.openqa.selenium.remote.RemoteWebDriver") ? new Augmenter().augment(ATUReports.getWebDriver()) : ATUReports.getWebDriver();
            if (webDriver instanceof TakesScreenshot) {
                byte[] byArray = (byte[])((TakesScreenshot)webDriver).getScreenshotAs(OutputType.BYTES);
                Files.write((byte[])byArray, (File)file);
            } else {
                screenShotNumber = null;
            }
        }
        catch (Exception exception) {
            screenShotNumber = null;
        }
    }

    private static void takeWebElementScreenShot(WebElement webElement) {
        if (!Directory.takeScreenshot) {
            return;
        }
        if (ATUReports.getWebDriver() == null) {
            screenShotNumber = null;
            return;
        }
        ITestResult iTestResult = Reporter.getCurrentTestResult();
        String string = iTestResult.getAttribute("reportDir").toString() + Directory.SEP + Directory.IMGDIRName;
        screenShotNumber = Reporter.getOutput((ITestResult)Reporter.getCurrentTestResult()).size() + 1 + EMPTY;
        File file = new File(string + Directory.SEP + screenShotNumber + ".PNG");
        try {
            WebDriver webDriver = ATUReports.getWebDriver().getClass().getName().equals("org.openqa.selenium.remote.RemoteWebDriver") ? new Augmenter().augment(ATUReports.getWebDriver()) : ATUReports.getWebDriver();
            if (webDriver instanceof TakesScreenshot) {
                File file2 = (File)((TakesScreenshot)driver).getScreenshotAs(OutputType.FILE);
                BufferedImage bufferedImage = ImageIO.read(file2);
                Point point = webElement.getLocation();
                int n = webElement.getSize().getWidth();
                int n2 = webElement.getSize().getHeight();
                BufferedImage bufferedImage2 = bufferedImage.getSubimage(point.getX(), point.getY(), n, n2);
                ImageIO.write((RenderedImage)bufferedImage2, "PNG", file);
            } else {
                screenShotNumber = null;
            }
        }
        catch (Exception exception) {
            screenShotNumber = null;
        }
    }

    @Deprecated
    public static void add(String string, boolean bl) {
        if (bl) {
            ATUReports.takeScreenShot();
        }
        Steps steps = new Steps();
        steps.setDescription(string);
        steps.setInputValue(EMPTY);
        steps.setExpectedValue(EMPTY);
        steps.setActualValue(EMPTY);
        steps.setTime(ATUReports.getExecutionTime());
        steps.setLineNum(ATUReports.getLineNumDesc());
        steps.setScreenShot(screenShotNumber);
        steps.setLogAs(LogAs.PASSED);
        ATUReports.buildReportData(steps);
    }

    @Deprecated
    public static void add(String string, String string2, boolean bl) {
        if (bl) {
            ATUReports.takeScreenShot();
        }
        Steps steps = new Steps();
        steps.setDescription(string);
        steps.setInputValue(string2);
        steps.setExpectedValue(EMPTY);
        steps.setActualValue(EMPTY);
        steps.setTime(ATUReports.getExecutionTime());
        steps.setLineNum(ATUReports.getLineNumDesc());
        steps.setScreenShot(screenShotNumber);
        steps.setLogAs(LogAs.PASSED);
        ATUReports.buildReportData(steps);
    }

    @Deprecated
    public static void add(String string, String string2, String string3, boolean bl) {
        if (bl) {
            ATUReports.takeScreenShot();
        }
        Steps steps = new Steps();
        steps.setDescription(string);
        steps.setInputValue(EMPTY);
        steps.setExpectedValue(string2);
        steps.setActualValue(string3);
        steps.setTime(ATUReports.getExecutionTime());
        steps.setLineNum(ATUReports.getLineNumDesc());
        steps.setScreenShot(screenShotNumber);
        steps.setLogAs(LogAs.PASSED);
        ATUReports.buildReportData(steps);
    }

    @Deprecated
    public static void add(String string, String string2, String string3, String string4, boolean bl) {
        if (bl) {
            ATUReports.takeScreenShot();
        }
        Steps steps = new Steps();
        steps.setDescription(string);
        steps.setInputValue(string2);
        steps.setExpectedValue(string3);
        steps.setActualValue(string4);
        steps.setTime(ATUReports.getExecutionTime());
        steps.setLineNum(ATUReports.getLineNumDesc());
        steps.setScreenShot(screenShotNumber);
        steps.setLogAs(LogAs.PASSED);
        ATUReports.buildReportData(steps);
    }

    private static void takeScreenShot() {
        if (!Directory.takeScreenshot) {
            return;
        }
        if (ATUReports.getWebDriver() == null) {
            screenShotNumber = null;
            return;
        }
        ITestResult iTestResult = Reporter.getCurrentTestResult();
        String string = iTestResult.getAttribute("reportDir").toString() + Directory.SEP + Directory.IMGDIRName;
        screenShotNumber = Reporter.getOutput((ITestResult)Reporter.getCurrentTestResult()).size() + 1 + EMPTY;
        File file = new File(string + Directory.SEP + screenShotNumber + ".PNG");
        try {
            WebDriver webDriver = ATUReports.getWebDriver().getClass().getName().equals("org.openqa.selenium.remote.RemoteWebDriver") ? new Augmenter().augment(ATUReports.getWebDriver()) : ATUReports.getWebDriver();
            if (webDriver instanceof TakesScreenshot) {
                byte[] byArray = (byte[])((TakesScreenshot)webDriver).getScreenshotAs(OutputType.BYTES);
                Files.write((byte[])byArray, (File)file);
            } else {
                screenShotNumber = null;
            }
        }
        catch (Exception exception) {
            screenShotNumber = null;
        }
    }

    static {
        indexPageDescription = "Reports Description";
        currentRunDescription = "Here you can give description about the current Run";
        try {
            lastExecutionTime = Reporter.getCurrentTestResult().getStartMillis();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

