/*
 * Decompiled with CFR 0.152.
 */
package atu.testng.reports.excel;

import atu.testng.reports.chart.PieChart;
import atu.testng.reports.excel.ExcelStyler;
import atu.testng.reports.utils.Directory;
import atu.testng.reports.utils.Steps;
import atu.testng.reports.writers.CurrentRunPageWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jfree.chart.JFreeChart;
import org.testng.ITestResult;
import org.testng.Reporter;

public class ExcelReports {
    public static final String TEST_ID_PREFIX = "ATU_TC_";
    public static int atuTC_ID = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateExcelReport(String string, List<ITestResult> list, List<ITestResult> list2, List<ITestResult> list3) {
        FileOutputStream fileOutputStream = null;
        XSSFWorkbook xSSFWorkbook = null;
        Object var6_6 = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            xSSFWorkbook = new XSSFWorkbook();
            ExcelReports.testSummary((Workbook)xSSFWorkbook, var6_6, list, list2, list3);
            ExcelReports.testCaseList((Workbook)xSSFWorkbook, var6_6, list, list2, list3);
            ExcelReports.testStepDescription((Workbook)xSSFWorkbook, var6_6, list);
            ExcelReports.testStepDescription((Workbook)xSSFWorkbook, var6_6, list2);
            xSSFWorkbook.write((OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        finally {
            var6_6 = null;
            xSSFWorkbook = null;
            fileOutputStream = null;
        }
    }

    private static void addPieChartTOExcel(Workbook workbook, Sheet sheet, List<ITestResult> list, List<ITestResult> list2, List<ITestResult> list3) {
        byte[] byArray = ExcelChart.writeChartToExcel(list.size(), list2.size(), list3.size());
        int n = workbook.addPicture(byArray, 6);
        CreationHelper creationHelper = workbook.getCreationHelper();
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor clientAnchor = creationHelper.createClientAnchor();
        clientAnchor.setCol1(0);
        clientAnchor.setRow1(6);
        Picture picture = drawing.createPicture(clientAnchor, n);
        picture.resize();
    }

    private static void testSummary(Workbook workbook, Sheet sheet, List<ITestResult> list, List<ITestResult> list2, List<ITestResult> list3) {
        sheet = workbook.createSheet("TestSummary");
        Row row = sheet.createRow(0);
        row.setHeight((short)420);
        Cell cell = row.createCell(0);
        cell.setCellValue("Total Test Cases");
        ExcelStyler.setHeaderCellStyle(workbook, cell);
        cell = row.createCell(1);
        cell.setCellValue((double)(list.size() + list2.size() + list3.size()));
        ExcelStyler.setHeaderCellStyle(workbook, cell);
        row = sheet.createRow(1);
        cell = row.createCell(0);
        cell.setCellValue("Test Cases Passed");
        ExcelStyler.setResultCellStyle(workbook, cell, 1);
        cell = row.createCell(1);
        cell.setCellValue((double)list.size());
        ExcelStyler.setResultCellStyle(workbook, cell, 1);
        row = sheet.createRow(2);
        cell = row.createCell(0);
        cell.setCellValue("Test Cases Failed");
        ExcelStyler.setResultCellStyle(workbook, cell, 2);
        cell = row.createCell(1);
        cell.setCellValue((double)list2.size());
        ExcelStyler.setResultCellStyle(workbook, cell, 2);
        row = sheet.createRow(3);
        cell = row.createCell(0);
        cell.setCellValue("Test Cases Skipped");
        ExcelStyler.setResultCellStyle(workbook, cell, 3);
        cell = row.createCell(1);
        cell.setCellValue((double)list3.size());
        ExcelStyler.setResultCellStyle(workbook, cell, 3);
        ExcelReports.addPieChartTOExcel(workbook, sheet, list, list2, list3);
        sheet.autoSizeColumn(0);
        ExcelStyler.setSheetTabColor(sheet);
    }

    private static void testCaseList(Workbook workbook, Sheet sheet, List<ITestResult> list, List<ITestResult> list2, List<ITestResult> list3) {
        sheet = workbook.createSheet("TestSuite");
        Row row = sheet.createRow(0);
        row.setHeight((short)420);
        Cell cell = row.createCell(0);
        cell.setCellValue("S.No");
        ExcelStyler.setHeaderCellStyle(workbook, cell);
        cell = row.createCell(1);
        cell.setCellValue("Package");
        ExcelStyler.setHeaderCellStyle(workbook, cell);
        sheet.autoSizeColumn(1);
        cell = row.createCell(2);
        cell.setCellValue("ClassName");
        ExcelStyler.setHeaderCellStyle(workbook, cell);
        sheet.autoSizeColumn(2);
        cell = row.createCell(3);
        cell.setCellValue("TestCase Name");
        ExcelStyler.setHeaderCellStyle(workbook, cell);
        sheet.autoSizeColumn(3);
        cell = row.createCell(4);
        cell.setCellValue("Iteration");
        ExcelStyler.setHeaderCellStyle(workbook, cell);
        sheet.autoSizeColumn(4);
        cell = row.createCell(5);
        cell.setCellValue("Time Taken");
        ExcelStyler.setHeaderCellStyle(workbook, cell);
        sheet.autoSizeColumn(5);
        cell = row.createCell(6);
        cell.setCellValue("Result");
        ExcelStyler.setHeaderCellStyle(workbook, cell);
        cell = row.createCell(7);
        cell.setCellValue("ATU_TestCase_ID");
        CellStyle cellStyle = ExcelStyler.setHeaderCellStyle(workbook, cell);
        cellStyle.setBorderRight((short)1);
        cellStyle.setRightBorderColor(ExcelStyler.HEADER_BG_COLOR);
        cell.setCellStyle(cellStyle);
        sheet.autoSizeColumn(7);
        int n = 1;
        n = ExcelReports.writeSummaryData(workbook, sheet, list, n);
        n = ExcelReports.writeSummaryData(workbook, sheet, list2, n);
        n = ExcelReports.writeSummaryData(workbook, sheet, list3, n);
        Row row2 = sheet.getRow(n - 1);
        ExcelStyler.setBorderLine(workbook, row2);
        ExcelStyler.setSheetTabColor(sheet);
    }

    private static int writeSummaryData(Workbook workbook, Sheet sheet, List<ITestResult> list, int n) {
        list.size();
        for (ITestResult iTestResult : list) {
            Row row = sheet.createRow(n);
            Cell cell = row.createCell(0);
            cell.setCellValue((double)n);
            ExcelReports.setHyperLink(iTestResult, workbook, cell);
            cell = row.createCell(1);
            cell.setCellValue(CurrentRunPageWriter.getPackageName(iTestResult));
            ExcelReports.setHyperLink(iTestResult, workbook, cell);
            cell = row.createCell(2);
            cell.setCellValue(CurrentRunPageWriter.getClassName(iTestResult));
            ExcelReports.setHyperLink(iTestResult, workbook, cell);
            cell = row.createCell(3);
            cell.setCellValue(CurrentRunPageWriter.getTestCaseName(iTestResult));
            ExcelReports.setHyperLink(iTestResult, workbook, cell);
            cell = row.createCell(4);
            cell.setCellValue(CurrentRunPageWriter.getIteration(iTestResult));
            ExcelReports.setHyperLink(iTestResult, workbook, cell);
            cell = row.createCell(5);
            cell.setCellValue(CurrentRunPageWriter.getExecutionTime(iTestResult));
            ExcelReports.setHyperLink(iTestResult, workbook, cell);
            cell = row.createCell(6);
            ExcelStyler.setResultCellStyle(workbook, cell, iTestResult);
            ExcelReports.setHyperLink(iTestResult, workbook, cell);
            cell = row.createCell(7);
            cell.setCellValue(TEST_ID_PREFIX + atuTC_ID);
            ExcelReports.setHyperLink(iTestResult, workbook, cell);
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setBorderRight((short)1);
            cellStyle.setRightBorderColor(ExcelStyler.HEADER_BG_COLOR);
            cell.setCellStyle(cellStyle);
            ++atuTC_ID;
            ++n;
        }
        return n;
    }

    private static void setHyperLink(ITestResult iTestResult, Workbook workbook, Cell cell) {
        if (iTestResult.getStatus() != 3) {
            CreationHelper creationHelper = workbook.getCreationHelper();
            Hyperlink hyperlink = creationHelper.createHyperlink(2);
            hyperlink.setAddress("'ATU_TC_" + atuTC_ID + "'!A1");
            iTestResult.setAttribute("testID", (Object)atuTC_ID);
            cell.setHyperlink(hyperlink);
        }
    }

    private static void setHyperLink(String string, Workbook workbook, Cell cell) {
        CreationHelper creationHelper = workbook.getCreationHelper();
        Hyperlink hyperlink = creationHelper.createHyperlink(2);
        hyperlink.setAddress("'" + string + "'!A1");
        cell.setHyperlink(hyperlink);
    }

    private static void testStepDescription(Workbook workbook, Sheet sheet, List<ITestResult> list) {
        for (ITestResult iTestResult : list) {
            sheet = workbook.createSheet(TEST_ID_PREFIX + iTestResult.getAttribute("testID").toString());
            ExcelStyler.setSheetTabColor(sheet, iTestResult);
            Row row = sheet.createRow(0);
            row.setHeight((short)420);
            Cell cell = row.createCell(0);
            cell.setCellValue("S.No");
            ExcelStyler.setHeaderCellStyle(workbook, cell);
            cell = row.createCell(1);
            cell.setCellValue("Step Description");
            ExcelStyler.setHeaderCellStyle(workbook, cell);
            sheet.autoSizeColumn(1);
            cell = row.createCell(2);
            cell.setCellValue("Input Value");
            ExcelStyler.setHeaderCellStyle(workbook, cell);
            sheet.autoSizeColumn(2);
            cell = row.createCell(3);
            cell.setCellValue("Expected value");
            ExcelStyler.setHeaderCellStyle(workbook, cell);
            sheet.autoSizeColumn(3);
            cell = row.createCell(4);
            cell.setCellValue("Actual Value");
            ExcelStyler.setHeaderCellStyle(workbook, cell);
            sheet.autoSizeColumn(4);
            cell = row.createCell(5);
            cell.setCellValue("Time Taken");
            ExcelStyler.setHeaderCellStyle(workbook, cell);
            sheet.autoSizeColumn(5);
            cell = row.createCell(6);
            cell.setCellValue("Line No");
            ExcelStyler.setHeaderCellStyle(workbook, cell);
            cell = row.createCell(7);
            cell.setCellValue("Screenshot");
            ExcelStyler.setHeaderCellStyle(workbook, cell);
            sheet.autoSizeColumn(7);
            List list2 = Reporter.getOutput((ITestResult)iTestResult);
            int n = 1;
            for (String string : list2) {
                Steps steps = (Steps)iTestResult.getAttribute(string);
                Row row2 = sheet.createRow(n);
                if (steps == null) {
                    cell = row2.createCell(0);
                    cell.setCellValue(string);
                    continue;
                }
                cell = row2.createCell(0);
                cell.setCellValue((double)n);
                cell = row2.createCell(1);
                cell.setCellValue(steps.getDescription());
                cell = row2.createCell(2);
                cell.setCellValue(steps.getInputValue());
                cell = row2.createCell(3);
                cell.setCellValue(steps.getExpectedValue());
                cell = row2.createCell(4);
                cell.setCellValue(steps.getActualValue());
                cell = row2.createCell(5);
                cell.setCellValue(steps.getTime());
                cell = row2.createCell(6);
                cell.setCellValue(steps.getLineNum());
                cell = row2.createCell(7);
                try {
                    Integer.parseInt(steps.getScreenShot().trim());
                    CreationHelper creationHelper = workbook.getCreationHelper();
                    Hyperlink hyperlink = creationHelper.createHyperlink(4);
                    String string2 = iTestResult.getAttribute("relativeReportDir") + Directory.SEP + Directory.SCREENSHOT_DIRName;
                    string2 = string2.replace(" ", "%20").replace(Directory.SEP, "/");
                    string2 = string2 + "/" + n + ".PNG";
                    hyperlink.setAddress(string2);
                    cell.setCellValue("Screenshot");
                    cell.setHyperlink(hyperlink);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
            Row row3 = sheet.createRow(n);
            cell = row3.createCell(0);
            cell.setCellValue("Go To TestSuite Sheet");
            ExcelReports.setHyperLink("TestSuite", workbook, cell);
            cell = row3.createCell(1);
            cell = row3.createCell(2);
            cell = row3.createCell(3);
            cell = row3.createCell(4);
            cell = row3.createCell(5);
            cell = row3.createCell(6);
            cell = row3.createCell(7);
            int n2 = sheet.addMergedRegion(new CellRangeAddress(n, n, 0, 7));
            cell = sheet.getRow(n).getCell(n2 - 1);
            cell.setCellStyle(ExcelStyler.setColor(workbook, ExcelStyler.FOOTER_BG_COLOR, ExcelStyler.FONT_COLOR));
        }
    }

    public static class ExcelChart {
        private static byte[] writeChartToByteStream(JFreeChart jFreeChart) {
            BufferedImage bufferedImage = jFreeChart.createBufferedImage(450, 450);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }

        public static byte[] writeChartToExcel(int n, int n2, int n3) {
            return ExcelChart.writeChartToByteStream(PieChart.generate2DPieChart(n, n2, n3));
        }
    }
}

