/*
 * Decompiled with CFR 0.152.
 */
package atu.testng.reports.excel;

import atu.testng.reports.enums.ReportLabels;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.testng.ITestResult;

public class ExcelStyler {
    public static final short RESULT_PASS_COLOR = IndexedColors.GREEN.getIndex();
    public static final short RESULT_FAIL_COLOR = IndexedColors.RED.getIndex();
    public static final short RESULT_SKIP_COLOR = IndexedColors.ROYAL_BLUE.getIndex();
    public static final short FONT_COLOR = IndexedColors.WHITE.getIndex();
    public static final short HEADER_BG_COLOR = IndexedColors.GREY_50_PERCENT.getIndex();
    public static final short FOOTER_BG_COLOR = IndexedColors.DARK_TEAL.getIndex();
    public static final short HEADER_HEIGHT = 420;
    public static final short SHEET_COLOR = IndexedColors.DARK_TEAL.getIndex();

    public static void setSheetTabColor(Sheet sheet, ITestResult iTestResult) {
        if (iTestResult.getStatus() == 2) {
            ((XSSFSheet)sheet).setTabColor((int)IndexedColors.RED.index);
        } else if (iTestResult.getStatus() == 1) {
            ((XSSFSheet)sheet).setTabColor((int)IndexedColors.GREEN.index);
        } else {
            ((XSSFSheet)sheet).setTabColor((int)IndexedColors.BLUE.index);
        }
    }

    public static void setSheetTabColor(Sheet sheet) {
        ((XSSFSheet)sheet).setTabColor((int)SHEET_COLOR);
    }

    public static void setBorderLine(Workbook workbook, Row row) {
        for (int i = 0; i < 8; ++i) {
            Cell cell = row.getCell(i);
            CellStyle cellStyle = workbook.createCellStyle();
            if (i == 6 || i == 7) {
                cellStyle = cell.getCellStyle();
            }
            cellStyle.setBorderBottom((short)1);
            cellStyle.setBottomBorderColor(HEADER_BG_COLOR);
            cell.setCellStyle(cellStyle);
        }
    }

    public static CellStyle setHeaderCellStyle(Workbook workbook, Cell cell) {
        Font font = workbook.createFont();
        font.setColor(FONT_COLOR);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFillForegroundColor(HEADER_BG_COLOR);
        cellStyle.setFillPattern((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        cellStyle.setFont(font);
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        cell.setCellStyle(cellStyle);
        return cellStyle;
    }

    static CellStyle setColor(Workbook workbook, short s, short s2) {
        Font font = workbook.createFont();
        font.setColor(s2);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFillForegroundColor(s);
        cellStyle.setFillPattern((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        cellStyle.setFont(font);
        cellStyle.setAlignment((short)2);
        return cellStyle;
    }

    static void setResultCellStyle(Workbook workbook, Cell cell, int n) {
        if (n == 2) {
            cell.setCellStyle(ExcelStyler.setColor(workbook, RESULT_FAIL_COLOR, FONT_COLOR));
        } else if (n == 1) {
            cell.setCellStyle(ExcelStyler.setColor(workbook, RESULT_PASS_COLOR, FONT_COLOR));
        } else if (n == 3) {
            cell.setCellStyle(ExcelStyler.setColor(workbook, RESULT_SKIP_COLOR, FONT_COLOR));
        }
    }

    static void setResultCellStyle(Workbook workbook, Cell cell, ITestResult iTestResult) {
        if (iTestResult.getStatus() == 2) {
            cell.setCellValue(ReportLabels.FAIL.getLabel());
            cell.setCellStyle(ExcelStyler.setColor(workbook, RESULT_FAIL_COLOR, FONT_COLOR));
        } else if (iTestResult.getStatus() == 1) {
            cell.setCellValue(ReportLabels.PASS.getLabel());
            cell.setCellStyle(ExcelStyler.setColor(workbook, RESULT_PASS_COLOR, FONT_COLOR));
        } else if (iTestResult.getStatus() == 3) {
            cell.setCellValue(ReportLabels.SKIP.getLabel());
            cell.setCellStyle(ExcelStyler.setColor(workbook, RESULT_SKIP_COLOR, FONT_COLOR));
        }
    }
}

