/*
 * Decompiled with CFR 0.152.
 */
package atu.testng.reports.listeners;

import atu.testng.reports.ATUReports;
import atu.testng.reports.excel.ExcelReports;
import atu.testng.reports.exceptions.ATUReporterStepFailedException;
import atu.testng.reports.listeners.ConfigurationListener;
import atu.testng.reports.utils.Directory;
import atu.testng.reports.utils.Platform;
import atu.testng.reports.utils.SettingsFile;
import atu.testng.reports.writers.ConsolidatedReportsPageWriter;
import atu.testng.reports.writers.CurrentRunPageWriter;
import atu.testng.reports.writers.HTMLDesignFilesJSWriter;
import atu.testng.reports.writers.IndexPageWriter;
import atu.testng.reports.writers.TestCaseReportsPageWriter;
import atu.testrecorder.ATUTestRecorder;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.xml.XmlTest;

public class ATUReportsListener
implements ITestListener,
ISuiteListener {
    int runCount = 0;
    ISuite iSuite;
    List<ITestResult> passedTests = new ArrayList<ITestResult>();
    List<ITestResult> failedTests = new ArrayList<ITestResult>();
    List<ITestResult> skippedTests = new ArrayList<ITestResult>();
    private ATUTestRecorder recorder;

    public void onFinish(ITestContext iTestContext) {
    }

    public void onStart(ITestContext iTestContext) {
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
    }

    public void onTestFailure(ITestResult iTestResult) {
        this.failedTests.add(iTestResult);
    }

    public void onTestSkipped(ITestResult iTestResult) {
        ATUReportsListener.createReportDir(iTestResult);
        this.skippedTests.add(iTestResult);
    }

    public void onTestStart(ITestResult iTestResult) {
    }

    public void onTestSuccess(ITestResult iTestResult) {
        try {
            if (iTestResult.getAttribute("passedButFailed").equals("passedButFailed")) {
                iTestResult.setStatus(2);
                iTestResult.setThrowable((Throwable)new ATUReporterStepFailedException());
                this.failedTests.add(iTestResult);
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.passedTests.add(iTestResult);
    }

    public static void setPlatfromBrowserDetails(ITestResult iTestResult) {
        Platform.prepareDetails(ATUReports.getWebDriver());
        iTestResult.setAttribute(Platform.BROWSER_NAME_PROP, (Object)Platform.BROWSER_NAME);
        iTestResult.setAttribute(Platform.BROWSER_VERSION_PROP, (Object)Platform.BROWSER_VERSION);
    }

    public static void createReportDir(ITestResult iTestResult) {
        String string = ATUReportsListener.getReportDir(iTestResult);
        Directory.mkDirs(string);
        Directory.mkDirs(string + Directory.SEP + Directory.SCREENSHOT_DIRName);
    }

    public static String getRelativePathFromSuiteLevel(ITestResult iTestResult) {
        String string = iTestResult.getTestContext().getSuite().getName();
        String string2 = iTestResult.getTestContext().getCurrentXmlTest().getName();
        String string3 = iTestResult.getTestClass().getName().replace(".", Directory.SEP);
        String string4 = iTestResult.getMethod().getMethodName();
        string4 = string4 + "_Iteration" + (iTestResult.getMethod().getCurrentInvocationCount() + 1);
        return string + Directory.SEP + string2 + Directory.SEP + string3 + Directory.SEP + string4;
    }

    public static String getReportDir(ITestResult iTestResult) {
        String string = ATUReportsListener.getRelativePathFromSuiteLevel(iTestResult);
        iTestResult.setAttribute("relativeReportDir", (Object)string);
        String string2 = Directory.RUNDir + Directory.SEP + string;
        iTestResult.setAttribute("iteration", (Object)(iTestResult.getMethod().getCurrentInvocationCount() + 1));
        iTestResult.setAttribute("reportDir", (Object)string2);
        return string2;
    }

    public void onFinish(ISuite iSuite) {
        try {
            this.iSuite = iSuite;
            String string = SettingsFile.get("passedList") + this.passedTests.size() + ';';
            String string2 = SettingsFile.get("failedList") + this.failedTests.size() + ';';
            String string3 = SettingsFile.get("skippedList") + this.skippedTests.size() + ';';
            SettingsFile.set("passedList", string);
            SettingsFile.set("failedList", string2);
            SettingsFile.set("skippedList", string3);
            HTMLDesignFilesJSWriter.lineChartJS(string, string2, string3, this.runCount);
            HTMLDesignFilesJSWriter.barChartJS(string, string2, string3, this.runCount);
            HTMLDesignFilesJSWriter.pieChartJS(this.passedTests.size(), this.failedTests.size(), this.skippedTests.size(), this.runCount);
            this.generateIndexPage();
            iSuite.setAttribute("endExecution", (Object)System.currentTimeMillis());
            long l = (Long)iSuite.getAttribute("startExecution");
            this.generateConsolidatedPage();
            this.generateCurrentRunPage(l, System.currentTimeMillis());
            this.startReportingForPassed(this.passedTests);
            this.startReportingForFailed(this.failedTests);
            this.startReportingForSkipped(this.skippedTests);
            if (Directory.generateExcelReports) {
                ExcelReports.generateExcelReport(Directory.RUNDir + Directory.SEP + "(" + Directory.REPORTSDIRName + ") " + Directory.RUNName + this.runCount + ".xlsx", this.passedTests, this.failedTests, this.skippedTests);
            }
            if (Directory.generateConfigReports) {
                ConfigurationListener.startConfigurationMethodsReporting(this.runCount);
            }
            if (Directory.recordSuiteExecution) {
                try {
                    this.recorder.stop();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public void onStart(ISuite iSuite) {
        try {
            iSuite.setAttribute("startExecution", (Object)System.currentTimeMillis());
            Directory.verifyRequiredFiles();
            SettingsFile.correctErrors();
            this.runCount = Integer.parseInt(SettingsFile.get("run").trim()) + 1;
            SettingsFile.set("run", "" + this.runCount);
            Directory.RUNDir = Directory.RUNDir + this.runCount;
            Directory.mkDirs(Directory.RUNDir);
            if (Directory.recordSuiteExecution) {
                try {
                    this.recorder = new ATUTestRecorder(Directory.RUNDir, "ATU_CompleteSuiteRecording", false);
                    this.recorder.start();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Directory.mkDirs(Directory.RUNDir + Directory.SEP + iSuite.getName());
            for (XmlTest xmlTest : iSuite.getXmlSuite().getTests()) {
                Directory.mkDirs(Directory.RUNDir + Directory.SEP + iSuite.getName() + Directory.SEP + xmlTest.getName());
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateIndexPage() {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(Directory.REPORTSDir + Directory.SEP + "index.html");
            IndexPageWriter.header(printWriter);
            IndexPageWriter.content(printWriter, ATUReports.indexPageDescription);
            IndexPageWriter.footer(printWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {
                printWriter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCurrentRunPage(long l, long l2) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(Directory.RUNDir + Directory.SEP + "CurrentRun.html");
            CurrentRunPageWriter.header(printWriter);
            CurrentRunPageWriter.menuLink(printWriter, 0);
            CurrentRunPageWriter.content(printWriter, this.iSuite, this.passedTests, this.failedTests, this.skippedTests, ConfigurationListener.passedConfigurations, ConfigurationListener.failedConfigurations, ConfigurationListener.skippedConfigurations, this.runCount, l, l2);
            CurrentRunPageWriter.footer(printWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {
                printWriter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateConsolidatedPage() {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(Directory.RESULTSDir + Directory.SEP + "ConsolidatedPage.html");
            ConsolidatedReportsPageWriter.header(printWriter);
            ConsolidatedReportsPageWriter.menuLink(printWriter, this.runCount);
            ConsolidatedReportsPageWriter.content(printWriter);
            ConsolidatedReportsPageWriter.footer(printWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {
                printWriter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReportingForPassed(List<ITestResult> list) {
        PrintWriter printWriter = null;
        for (ITestResult iTestResult : list) {
            String string = iTestResult.getAttribute("reportDir").toString();
            try {
                printWriter = new PrintWriter(string + Directory.SEP + iTestResult.getName() + ".html");
                TestCaseReportsPageWriter.header(printWriter, iTestResult);
                TestCaseReportsPageWriter.menuLink(printWriter, iTestResult, 0);
                TestCaseReportsPageWriter.content(printWriter, iTestResult, this.runCount);
                TestCaseReportsPageWriter.footer(printWriter);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            finally {
                try {
                    printWriter.close();
                }
                catch (Exception exception) {
                    printWriter = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReportingForFailed(List<ITestResult> list) {
        PrintWriter printWriter = null;
        for (ITestResult iTestResult : list) {
            String string = iTestResult.getAttribute("reportDir").toString();
            try {
                printWriter = new PrintWriter(string + Directory.SEP + iTestResult.getName() + ".html");
                TestCaseReportsPageWriter.header(printWriter, iTestResult);
                TestCaseReportsPageWriter.menuLink(printWriter, iTestResult, 0);
                TestCaseReportsPageWriter.content(printWriter, iTestResult, this.runCount);
                TestCaseReportsPageWriter.footer(printWriter);
            }
            catch (FileNotFoundException fileNotFoundException) {}
            continue;
            finally {
                try {
                    printWriter.close();
                }
                catch (Exception exception) {
                    printWriter = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReportingForSkipped(List<ITestResult> list) {
        PrintWriter printWriter = null;
        for (ITestResult iTestResult : list) {
            String string = iTestResult.getAttribute("reportDir").toString();
            try {
                printWriter = new PrintWriter(string + Directory.SEP + iTestResult.getName() + ".html");
                TestCaseReportsPageWriter.header(printWriter, iTestResult);
                TestCaseReportsPageWriter.menuLink(printWriter, iTestResult, 0);
                TestCaseReportsPageWriter.content(printWriter, iTestResult, this.runCount);
                TestCaseReportsPageWriter.footer(printWriter);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            finally {
                try {
                    printWriter.close();
                }
                catch (Exception exception) {
                    printWriter = null;
                }
            }
        }
    }
}

