/*
 * Decompiled with CFR 0.152.
 */
package atu.testng.reports.listeners;

import atu.testng.reports.listeners.ATUReportsListener;
import atu.testng.reports.utils.Directory;
import atu.testng.reports.writers.TestCaseReportsPageWriter;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.testng.IConfigurationListener2;
import org.testng.ITestResult;

public class ConfigurationListener
implements IConfigurationListener2 {
    static List<ITestResult> passedConfigurations = new ArrayList<ITestResult>();
    static List<ITestResult> failedConfigurations = new ArrayList<ITestResult>();
    static List<ITestResult> skippedConfigurations = new ArrayList<ITestResult>();

    public void onConfigurationFailure(ITestResult iTestResult) {
        if (Directory.generateConfigReports) {
            failedConfigurations.add(iTestResult);
        }
    }

    public void onConfigurationSkip(ITestResult iTestResult) {
        if (Directory.generateConfigReports) {
            ATUReportsListener.createReportDir(iTestResult);
            skippedConfigurations.add(iTestResult);
        }
    }

    public void onConfigurationSuccess(ITestResult iTestResult) {
        if (Directory.generateConfigReports) {
            passedConfigurations.add(iTestResult);
        }
    }

    public static void startConfigurationMethodsReporting(int n) {
        ConfigurationListener.startReportingForPassedConfigurations(passedConfigurations, n);
        ConfigurationListener.startReportingForFailedConfigurations(failedConfigurations, n);
        ConfigurationListener.startReportingForSkippedConfigurations(skippedConfigurations, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startReportingForPassedConfigurations(List<ITestResult> list, int n) {
        PrintWriter printWriter = null;
        for (ITestResult iTestResult : list) {
            String string = null;
            string = iTestResult.getAttribute("reportDir").toString();
            try {
                printWriter = new PrintWriter(string + Directory.SEP + iTestResult.getName() + ".html");
                TestCaseReportsPageWriter.header(printWriter, iTestResult);
                TestCaseReportsPageWriter.menuLink(printWriter, iTestResult, 0);
                TestCaseReportsPageWriter.content(printWriter, iTestResult, n);
                TestCaseReportsPageWriter.footer(printWriter);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            finally {
                try {
                    printWriter.close();
                }
                catch (Exception exception) {
                    printWriter = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startReportingForFailedConfigurations(List<ITestResult> list, int n) {
        PrintWriter printWriter = null;
        for (ITestResult iTestResult : list) {
            String string = iTestResult.getAttribute("reportDir").toString();
            try {
                printWriter = new PrintWriter(string + Directory.SEP + iTestResult.getName() + ".html");
                TestCaseReportsPageWriter.header(printWriter, iTestResult);
                TestCaseReportsPageWriter.menuLink(printWriter, iTestResult, 0);
                TestCaseReportsPageWriter.content(printWriter, iTestResult, n);
                TestCaseReportsPageWriter.footer(printWriter);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            finally {
                try {
                    printWriter.close();
                }
                catch (Exception exception) {
                    printWriter = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startReportingForSkippedConfigurations(List<ITestResult> list, int n) {
        PrintWriter printWriter = null;
        for (ITestResult iTestResult : list) {
            String string = iTestResult.getAttribute("reportDir").toString();
            try {
                printWriter = new PrintWriter(string + Directory.SEP + iTestResult.getName() + ".html");
                TestCaseReportsPageWriter.header(printWriter, iTestResult);
                TestCaseReportsPageWriter.menuLink(printWriter, iTestResult, 0);
                TestCaseReportsPageWriter.content(printWriter, iTestResult, n);
                TestCaseReportsPageWriter.footer(printWriter);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            finally {
                try {
                    printWriter.close();
                }
                catch (Exception exception) {
                    printWriter = null;
                }
            }
        }
    }

    public void beforeConfiguration(ITestResult iTestResult) {
        ATUReportsListener.createReportDir(iTestResult);
    }
}

