/*
 * Decompiled with CFR 0.152.
 */
package atu.testng.reports.utils;

import atu.testng.reports.ATUReports;
import atu.testng.reports.enums.RecordingFor;
import atu.testng.reports.enums.ReportLabels;
import atu.testng.reports.exceptions.ATUReporterException;
import atu.testng.reports.utils.SettingsFile;
import atu.testng.reports.writers.HTMLDesignFilesWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;

public class Directory {
    public static final String ATU_VERSION = "v5.1.1";
    public static final String CURRENTDir = System.getProperty("user.dir");
    public static final String SEP = System.getProperty("file.separator");
    public static String REPORTSDIRName = "ATU Reports";
    public static String REPORTSDir = CURRENTDir + SEP + REPORTSDIRName;
    public static String RESULTSDir = REPORTSDir + SEP + "Results";
    public static String HTMLDESIGNDIRName = "HTML_Design_Files";
    public static String HTMLDESIGNDir = REPORTSDir + SEP + HTMLDESIGNDIRName;
    public static String CSSDIRName = "CSS";
    public static String CSSDir = HTMLDESIGNDir + SEP + CSSDIRName;
    public static String IMGDIRName = "IMG";
    public static String IMGDir = HTMLDESIGNDir + SEP + IMGDIRName;
    public static String JSDIRName = "JS";
    public static String JSDir = HTMLDESIGNDir + SEP + JSDIRName;
    public static String RUNName = "Run_";
    public static String RUNDir = RESULTSDir + SEP + RUNName;
    public static String SETTINGSFile = RESULTSDir + SEP + "Settings.properties";
    public static final char JS_SETTINGS_DELIM = ';';
    public static final String REPO_DELIM = "##@##@##";
    public static final char JS_FILE_DELIM = ',';
    public static final String MENU_LINK_NAME = "Run ";
    public static final String SCREENSHOT_TYPE = "PNG";
    public static final String SCREENSHOT_EXTENSION = ".PNG";
    private static String logo = null;
    public static String SCREENSHOT_DIRName = "img";
    public static boolean generateConfigReports = true;
    public static boolean generateExcelReports = false;
    public static boolean takeScreenshot = false;
    public static boolean continueExecutionAfterStepFailed = false;
    public static boolean recordExecutionAvailable = false;
    public static boolean recordSuiteExecution = false;
    public static boolean recordTestMethodExecution = false;
    public static final String MAIN_RECORD_FILE_NAME = "ATU_CompleteSuiteRecording";

    public static void init() throws ATUReporterException {
        if (Directory.getCustomProperties() != null) {
            Properties properties = new Properties();
            try {
                properties.load(new FileReader(Directory.getCustomProperties()));
                String string = properties.getProperty("atu.reports.dir").trim();
                String string2 = properties.getProperty("atu.proj.header.text").trim();
                logo = properties.getProperty("atu.proj.header.logo").trim();
                String string3 = properties.getProperty("atu.proj.description").trim();
                String string4 = properties.getProperty("atu.reports.takescreenshot").trim();
                String string5 = properties.getProperty("atu.reports.configurationreports").trim();
                String string6 = properties.getProperty("atu.reports.excel").trim();
                String string7 = properties.getProperty("atu.reports.continueExecutionAfterStepFailed").trim();
                String string8 = properties.getProperty("atu.reports.recordExecution").trim();
                try {
                    if (string2 != null && string2.length() > 0) {
                        ReportLabels.HEADER_TEXT.setLabel(string2);
                    }
                    if (string4 != null && string4.length() > 0) {
                        try {
                            takeScreenshot = Boolean.parseBoolean(string4);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (string5 != null && string5.length() > 0) {
                        try {
                            generateConfigReports = Boolean.parseBoolean(string5);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (string6 != null && string6.length() > 0) {
                        try {
                            generateExcelReports = Boolean.parseBoolean(string6);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (string7 != null && string7.length() > 0) {
                        try {
                            continueExecutionAfterStepFailed = Boolean.parseBoolean(string7);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (string8 != null && string8.length() > 0) {
                        try {
                            RecordingFor recordingFor = RecordingFor.valueOf(string8.toUpperCase());
                            if (recordingFor == RecordingFor.SUITE) {
                                recordSuiteExecution = true;
                            } else if (recordingFor == RecordingFor.TESTMETHOD) {
                                recordTestMethodExecution = true;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (string3 != null && string3.length() > 0) {
                        ATUReports.indexPageDescription = string3;
                    }
                    if (string != null && string.length() > 0) {
                        REPORTSDir = string;
                        REPORTSDIRName = new File(REPORTSDir).getName();
                        RESULTSDir = REPORTSDir + SEP + "Results";
                        HTMLDESIGNDIRName = "HTML_Design_Files";
                        HTMLDESIGNDir = REPORTSDir + SEP + HTMLDESIGNDIRName;
                        CSSDIRName = "CSS";
                        CSSDir = HTMLDESIGNDir + SEP + CSSDIRName;
                        IMGDIRName = "IMG";
                        IMGDir = HTMLDESIGNDir + SEP + IMGDIRName;
                        JSDIRName = "JS";
                        JSDir = HTMLDESIGNDir + SEP + JSDIRName;
                        RUNName = "Run_";
                        RUNDir = RESULTSDir + SEP + RUNName;
                        SETTINGSFile = RESULTSDir + SEP + "Settings.properties";
                    }
                }
                catch (Exception exception) {
                    throw new ATUReporterException(exception.toString());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ATUReporterException("The Path for the Custom Properties file could not be found");
            }
            catch (IOException iOException) {
                throw new ATUReporterException("Problem Occured while reading the ATU Reporter Config File");
            }
        }
    }

    public static void mkDirs(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static boolean exists(String string) {
        File file = new File(string);
        return file.exists();
    }

    public static void verifyRequiredFiles() throws ATUReporterException {
        Directory.init();
        Directory.mkDirs(REPORTSDir);
        if (!Directory.exists(RESULTSDir)) {
            Directory.mkDirs(RESULTSDir);
            SettingsFile.initSettingsFile();
        }
        if (!Directory.exists(HTMLDESIGNDir)) {
            Directory.mkDirs(HTMLDESIGNDir);
            Directory.mkDirs(CSSDir);
            Directory.mkDirs(JSDir);
            Directory.mkDirs(IMGDir);
            HTMLDesignFilesWriter.writeCSS();
            HTMLDesignFilesWriter.writeIMG();
            HTMLDesignFilesWriter.writeJS();
        }
        if (logo != null && logo.length() > 0) {
            String string = new File(logo).getName();
            if (!new File(IMGDir + SEP + string).exists()) {
                Directory.copyImage(logo);
            }
            ReportLabels.PROJ_LOGO.setLabel(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyImage(String string) throws ATUReporterException {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        FileImageInputStream fileImageInputStream = null;
        FileImageOutputStream fileImageOutputStream = null;
        try {
            fileImageInputStream = new FileImageInputStream(new File(string));
            fileImageOutputStream = new FileImageOutputStream(new File(IMGDir + SEP + file.getName()));
            int n = 0;
            while ((n = fileImageInputStream.read()) >= 0) {
                fileImageOutputStream.write(n);
            }
            fileImageOutputStream.close();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                fileImageInputStream.close();
                fileImageOutputStream.close();
                file = null;
            }
            catch (Exception exception) {
                fileImageInputStream = null;
                fileImageOutputStream = null;
                file = null;
            }
        }
    }

    private static String getCustomProperties() {
        return System.getProperty("atu.reporter.config");
    }
}

