/*
 * Decompiled with CFR 0.152.
 */
package atu.testng.reports.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.BuildInfo;
import org.openqa.selenium.remote.RemoteWebDriver;

public class Platform {
    private static BuildInfo driverInfo = new BuildInfo();
    public static final String DRIVER_VERSION = driverInfo.getReleaseLabel();
    public static final String DRIVER_REVISION = driverInfo.getBuildRevision();
    public static final String USER = System.getProperty("user.name");
    public static final String OS = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static String BROWSER_NAME = "Unknown";
    public static String BROWSER_VERSION = "";
    public static String BROWSER_NAME_PROP = "BrowserName";
    public static String BROWSER_VERSION_PROP = "BrowserVersion";

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "Unknown";
        }
    }

    public static void prepareDetails(WebDriver webDriver) {
        BROWSER_VERSION = "";
        BROWSER_NAME = "UnKnown";
        if (webDriver == null) {
            BROWSER_VERSION = "";
            BROWSER_NAME = "UnKnown";
            return;
        }
        try {
            String string = (String)((JavascriptExecutor)webDriver).executeScript("return navigator.userAgent;", new Object[0]);
            if (string.contains("MSIE")) {
                BROWSER_VERSION = string.substring(string.indexOf("MSIE") + 5, string.indexOf("Windows NT") - 2);
                BROWSER_NAME = "Internet Explorer";
            } else if (string.contains("Firefox/")) {
                BROWSER_VERSION = string.substring(string.indexOf("Firefox/") + 8);
                BROWSER_NAME = "Mozilla Firefox";
            } else if (string.contains("Chrome/")) {
                BROWSER_VERSION = string.substring(string.indexOf("Chrome/") + 7, string.lastIndexOf("Safari/"));
                BROWSER_NAME = "Google Chrome";
            } else if (string.contains("AppleWebKit") && string.contains("Version/")) {
                BROWSER_VERSION = string.substring(string.indexOf("Version/") + 8, string.lastIndexOf("Safari/"));
                BROWSER_NAME = "Apple Safari";
            } else if (string.startsWith("Opera/")) {
                BROWSER_VERSION = string.substring(string.indexOf("Version/") + 8);
                BROWSER_NAME = "Opera";
            } else {
                return;
            }
            Platform.getCapabilitiesDetails(webDriver);
        }
        catch (Exception exception) {
            try {
                Platform.getCapabilitiesDetails(webDriver);
            }
            catch (Exception exception2) {
                return;
            }
            return;
        }
        BROWSER_VERSION = "v" + BROWSER_VERSION;
    }

    private static void getCapabilitiesDetails(WebDriver webDriver) {
        Capabilities capabilities = ((RemoteWebDriver)webDriver).getCapabilities();
        BROWSER_NAME = capabilities.getBrowserName();
        BROWSER_VERSION = capabilities.getVersion();
    }
}

