/*
 * Decompiled with CFR 0.152.
 */
package atu.testng.reports.writers;

import atu.testng.reports.enums.Colors;
import atu.testng.reports.enums.ExceptionDetails;
import atu.testng.reports.enums.ReportLabels;
import atu.testng.reports.logging.LogAs;
import atu.testng.reports.utils.AuthorDetails;
import atu.testng.reports.utils.Directory;
import atu.testng.reports.utils.Platform;
import atu.testng.reports.utils.Steps;
import atu.testng.reports.utils.Utils;
import atu.testng.reports.writers.CurrentRunPageWriter;
import atu.testng.reports.writers.ReportsPage;
import java.io.PrintWriter;
import org.testng.ITestResult;
import org.testng.Reporter;

public class TestCaseReportsPageWriter
extends ReportsPage {
    public static void header(PrintWriter printWriter, ITestResult iTestResult) {
        printWriter.println("<!DOCTYPE html>\n\n<html>\n    <head>\n        <title>Pie Charts</title>\n\n        <link rel=\"stylesheet\" type=\"text/css\" href=\"../" + TestCaseReportsPageWriter.getTestCaseHTMLPath(iTestResult) + "HTML_Design_Files/CSS/design.css\" />\n" + "        <link rel=\"stylesheet\" type=\"text/css\" href=\"../" + TestCaseReportsPageWriter.getTestCaseHTMLPath(iTestResult) + "HTML_Design_Files/CSS/jquery.jqplot.css\" />\n" + "\n" + "        <script type=\"text/javascript\" src=\"../" + TestCaseReportsPageWriter.getTestCaseHTMLPath(iTestResult) + "HTML_Design_Files/JS/jquery.min.js\"></script>\n" + "        <script type=\"text/javascript\" src=\"../" + TestCaseReportsPageWriter.getTestCaseHTMLPath(iTestResult) + "HTML_Design_Files/JS/jquery.jqplot.min.js\"></script>\n" + "        <!--[if lt IE 9]>\n" + "        <script language=\"javascript\" type=\"text/javascript\" src=\"../" + TestCaseReportsPageWriter.getTestCaseHTMLPath(iTestResult) + "HTML_Design_Files/JS/excanvas.js\"></script>\n" + "        <![endif]-->\n" + "\n" + "        <script language=\"javascript\" type=\"text/javascript\" src=\"../" + TestCaseReportsPageWriter.getTestCaseHTMLPath(iTestResult) + "HTML_Design_Files/JS/jqplot.pieRenderer.min.js\"></script>\n" + "        <script language=\"javascript\" type=\"text/javascript\">" + "$(document).ready(function() {" + " $(\".exception\").hide();" + " $(\"#showmenu\").show();" + " $('#showmenu').click(function() {" + " $('.exception').toggle(\"slide\");" + " });" + " });" + "        </script>" + "    </head>\n" + "    <body>\n" + "        <table id=\"mainTable\">\n" + "            <tr id=\"header\" >\n" + "                <td id=\"logo\">" + "<img src=\"../" + TestCaseReportsPageWriter.getTestCaseHTMLPath(iTestResult) + "HTML_Design_Files/IMG/" + ReportLabels.ATU_LOGO.getLabel() + "\" alt=\"Logo\" height=\"80\" width=\"140\" /> " + "<br/>" + ReportLabels.ATU_CAPTION.getLabel() + "</td>\n" + "                <td id=\"headertext\">\n" + "           " + ReportLabels.HEADER_TEXT.getLabel() + "         \n" + "<div style=\"padding-right:20px;float:right\"><img src=\"../" + TestCaseReportsPageWriter.getTestCaseHTMLPath(iTestResult) + "HTML_Design_Files/IMG/" + ReportLabels.PROJ_LOGO.getLabel() + "\" height=\"70\" width=\"140\" /> </i></div>" + "                </td>\n" + "            </tr>");
    }

    public static String getExecutionTime(ITestResult iTestResult) {
        long l = iTestResult.getEndMillis() - iTestResult.getStartMillis();
        if (l > 1000L) {
            return (l /= 1000L) + " Sec";
        }
        return l + " Milli Sec";
    }

    private static String getExceptionDetails(ITestResult iTestResult) {
        String string;
        try {
            iTestResult.getThrowable().toString();
        }
        catch (Throwable throwable) {
            return "";
        }
        String string2 = string = iTestResult.getThrowable().toString();
        if (string.contains(":")) {
            string2 = string.substring(0, string.indexOf(":")).trim();
        } else {
            string = "";
        }
        try {
            string2 = TestCaseReportsPageWriter.getExceptionClassName(string2, string);
            if (string2.equals("Assertion Error")) {
                if (string.contains(">")) {
                    string2 = string2 + string.substring(string.indexOf(":"), string.lastIndexOf(">") + 1).replace(">", "\"");
                    string2 = string2.replace("<", "\"");
                }
                if (iTestResult.getThrowable().getMessage().trim().length() > 0) {
                    string2 = iTestResult.getThrowable().getMessage().trim();
                }
            } else if (string.contains("{")) {
                string2 = string2 + string.substring(string.indexOf("{"), string.lastIndexOf("}"));
                string2 = string2.replace("{\"method\":", " With ").replace(",\"selector\":", " = ");
            } else if (string2.equals("Unable to connect Browser") && string.contains(".")) {
                string2 = string2 + ": Browser is Closed";
            } else if (string2.equals("WebDriver Exception")) {
                string2 = iTestResult.getThrowable().getMessage();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        string2 = string2.replace(">", "\"");
        string2 = string2.replace("<", "\"");
        return string2;
    }

    private static String getExceptionClassName(String string, String string2) throws ClassNotFoundException {
        String string3 = "";
        try {
            string3 = ExceptionDetails.valueOf(string.trim().replace(".", "_")).getExceptionInfo();
        }
        catch (Exception exception) {
            string3 = string;
        }
        return string3;
    }

    public static String getReqCoverageInfo(ITestResult iTestResult) {
        try {
            if (iTestResult.getAttribute("reqCoverage") == null) {
                return ReportLabels.TC_INFO_LABEL.getLabel();
            }
            return iTestResult.getAttribute("reqCoverage").toString();
        }
        catch (Exception exception) {
            return ReportLabels.TC_INFO_LABEL.getLabel();
        }
    }

    public static void content(PrintWriter printWriter, ITestResult iTestResult, int n) {
        Object[] objectArray;
        printWriter.println("<td id=\"content\">   \n                    <div class=\"info\">\n                        The following table lists down the Sequential Steps during the Run <br/>\nTestCase Name: <b>" + iTestResult.getName() + "  :  Iteration " + iTestResult.getAttribute("iteration").toString() + "</b><br/>" + "                        Time Taken for Executing: <b>" + TestCaseReportsPageWriter.getExecutionTime(iTestResult) + "</b> <br/>\n" + "                        Current Run Number: <b>Run " + n + "</b></br>\n" + "Method Type: <b>" + CurrentRunPageWriter.getMethodType(iTestResult) + "</b></br>" + "                    </div>");
        printWriter.println("<div class=\"info\"><br/><b>Requirement Coverage/ TestCase Description</b><br/><br/>" + TestCaseReportsPageWriter.getReqCoverageInfo(iTestResult) + "</div>");
        printWriter.println("<div class=\"chartStyle summary\" style=\"background-color: #646D7E;width: 30%; height: 200px;\">          \n                        <b>Execution Platform Details</b><br/><br/>\n                        <table>\n                            <tr>\n                                <td>O.S</td>\n                                <td>&nbsp;&nbsp;:&nbsp;&nbsp;</td>\n                                <td>" + Platform.OS + ", " + Platform.OS_ARCH + "Bit, v" + Platform.OS_VERSION + "</td>\n" + "                            </tr>\n" + "                            <tr>\n" + "                                <td>Java</td>\n" + "                                <td>&nbsp;&nbsp;:&nbsp;&nbsp;</td>\n" + "                                <td>" + Platform.JAVA_VERSION + "</td>\n" + "                            </tr>\n" + "\n" + "                            <tr>\n" + "                                <td>Hostname</td>\n" + "                                <td>&nbsp;&nbsp;:&nbsp;&nbsp;</td>\n" + "                                <td>" + Platform.getHostName() + "</td>\n" + "                            </tr>\n" + "\n" + "                            <tr>\n" + "                                <td>Selenium</td>\n" + "                                <td>&nbsp;&nbsp;:&nbsp;&nbsp;</td>\n" + "                                <td>" + Platform.DRIVER_VERSION + "</td>\n" + "                            </tr>\n" + "                        </table>  \n" + "                    </div>\n" + "                   ");
        printWriter.println(" <div class=\"chartStyle summary\" style=\"background-color: " + TestCaseReportsPageWriter.getColorBasedOnResult(iTestResult) + ";margin-left: 20px; height: 200px;width: 30%; \">\n" + "                        <b>Summary</b><br/><br/>\n" + "                        <table>\n" + "                            <tr>\n" + "                                <td>Status</td>\n" + "                                <td>&nbsp;&nbsp;:&nbsp;&nbsp;</td>\n" + "                                <td>" + TestCaseReportsPageWriter.getResult(iTestResult) + "</td>\n" + "                            </tr>\n" + "                            <tr>\n" + "                                <td>Execution Date</td>\n" + "                                <td>&nbsp;&nbsp;:&nbsp;&nbsp;</td>\n" + "                                <td>" + Utils.getCurrentTime() + "</td>\n" + "                            </tr>\n" + "                            \n" + "\n" + "                            <tr>\n" + "                                <td>Browser</td>\n" + "                                <td>&nbsp;&nbsp;:&nbsp;&nbsp;</td>\n" + "                                <td>" + TestCaseReportsPageWriter.getBrowserName(iTestResult) + "," + TestCaseReportsPageWriter.getBrowserVersion(iTestResult) + "</td>\n" + "                            </tr>\n" + "                        </table> \n" + "                    </div>");
        AuthorDetails authorDetails = null;
        try {
            authorDetails = iTestResult.getAttribute("authorInfo") == null ? new AuthorDetails() : (AuthorDetails)iTestResult.getAttribute("authorInfo");
        }
        catch (Exception exception) {
            // empty catch block
        }
        printWriter.println(" <div class=\"chartStyle summary\" style=\"background-color: #7F525D;margin-left: 20px; height: 200px;width: 30%; \">\n                       <b>Author Info</b><br/><br/>\n                        <table>\n                            <tr>\n                                <td>Author Name</td>\n                                <td>&nbsp;&nbsp;:&nbsp;&nbsp;</td>\n                                <td>" + authorDetails.getAuthorName() + "</td>                                \n" + "                            </tr>\n" + "                            <tr>\n" + "                                <td>Creation Date</td>\n" + "                                <td>&nbsp;&nbsp;:&nbsp;&nbsp;</td>\n" + "                                <td>" + authorDetails.getCreationDate() + "</td>\n" + "                            </tr>\n" + "                            <tr>\n" + "                                <td>Version</td>\n" + "                                <td>&nbsp;&nbsp;:&nbsp;&nbsp;</td>\n" + "                                <td>" + authorDetails.getVersion() + "</td>\n" + "                            </tr>\n" + "                            <tr>\n" + "                                <td>System User</td>\n" + "                                <td>&nbsp;&nbsp;:&nbsp;&nbsp;</td>\n" + "                                <td>" + Platform.USER + "</td>\n" + "                            </tr>\n" + "                        </table> \n" + "                    </div>\n" + "                    ");
        if (iTestResult.getStatus() != 3) {
            objectArray = Reporter.getOutput((ITestResult)iTestResult);
            printWriter.println("   <div>\n                        <table class=\"chartStyle\" id=\"tableStyle\" style=\"height:50px; float: left\">\n                            <tr>\n                                <th>S.No</th>\n                                <th>Step Description</th>\n                                <th>Input Value</th>\n                                <th>Expected Value</th>\n                                <th>Actual Value</th>\n                                <th>Time</th>\n                                <th>Line No</th>\n                                <th>Status</th>\n                                <th>Screen shot</th>\n                            </tr>\n                           \n");
            int n2 = 1;
            if (Reporter.getOutput((ITestResult)iTestResult).size() <= 0) {
                printWriter.print("<tr>");
                printWriter.print("<td colspan=\"8\"><b>No Steps Available</b></td>");
                printWriter.print("</tr>");
            }
            n2 = 1;
            for (String objectArray2 : objectArray) {
                Steps steps = null;
                steps = (Steps)iTestResult.getAttribute(objectArray2);
                if (steps == null) {
                    printWriter.print("<tr>");
                    printWriter.println("<td>" + n2 + "</td>");
                    printWriter.print("<td style=\"text-align:left\" colspan=\"8\">" + objectArray2 + "</td></tr>");
                    ++n2;
                    continue;
                }
                printWriter.print("<tr>");
                printWriter.println("<td>" + n2 + "</td>");
                printWriter.println("<td>" + steps.getDescription() + "</td>");
                printWriter.println("<td>" + steps.getInputValue() + "</td>");
                printWriter.println("<td>" + steps.getExpectedValue() + "</td>");
                printWriter.println("<td>" + steps.getActualValue() + "</td>");
                printWriter.println("<td>" + steps.getTime() + "</td>");
                printWriter.println("<td>" + steps.getLineNum() + "</td>");
                printWriter.println("<td>" + TestCaseReportsPageWriter.getLogDescription(steps.getLogAs(), iTestResult) + "</td>");
                try {
                    Integer.parseInt(steps.getScreenShot().trim());
                    printWriter.println("<td><a href=\"img/" + n2 + ".PNG" + "\"><img alt=\"No Screenshot\" src=\"img/" + n2 + ".PNG" + "\"/></a></td>");
                }
                catch (Exception exception) {
                    printWriter.println("<td></td>");
                }
                printWriter.print("</tr>");
                ++n2;
            }
            printWriter.print("\n                        </table>  \n");
        }
        if (iTestResult.getParameters().length > 0 || iTestResult.getStatus() == 3 || iTestResult.getStatus() == 2) {
            printWriter.println(" <div class=\"chartStyle summary\" style=\"color: black;width: 98%; height: 100%; padding-bottom: 30px;\">          \n");
            if (iTestResult.getParameters().length > 0) {
                printWriter.print("<b>Parameters: </b><br/>");
                for (Object object : iTestResult.getParameters()) {
                    printWriter.print("Param: " + object.toString() + "<br/>");
                }
            }
            if (iTestResult.getStatus() == 3) {
                Object object;
                printWriter.print("<br/><br/>");
                printWriter.println("                      <b>Reason for Skipping</b><br/><br/>\n");
                objectArray = iTestResult.getMethod().getGroupsDependedUpon();
                String[] stringArray = iTestResult.getMethod().getMethodsDependedUpon();
                if (objectArray.length > 0) {
                    object = "";
                    for (Object object2 : objectArray) {
                        object = (String)object + (String)object2 + "<br/>";
                    }
                    printWriter.print("<b>Depends on Groups: </b><br/>" + (String)object);
                }
                if (stringArray.length > 0) {
                    object = "";
                    for (String string : stringArray) {
                        object = (String)object + string + "<br/>";
                    }
                    printWriter.print("<b>Depends on Methods: </b><br/>" + (String)object + "<br/><br/>");
                }
                printWriter.print("                    </div>");
            }
            if (iTestResult.getStatus() == 2) {
                printWriter.println("                        <br/><br/><b>Reason for Failure:&nbsp;&nbsp;</b>" + TestCaseReportsPageWriter.getExceptionDetails(iTestResult) + "<br/><br/>\n" + "<b id=\"showmenu\">Click Me to Show/Hide the Full Stack Trace</b>" + "<div class=\"exception\">");
                try {
                    iTestResult.getThrowable().printStackTrace(printWriter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                printWriter.print("</div>");
            }
            printWriter.print("                    </div>");
        }
        printWriter.print("                    </div>\n\n                </td>\n            </tr>");
    }

    public static String getLogDescription(LogAs logAs, ITestResult iTestResult) {
        switch (logAs) {
            case PASSED: {
                return "<img style=\"height:20px;width:20px;border:none\"  alt=\"PASS\" src=\"../" + TestCaseReportsPageWriter.getTestCaseHTMLPath(iTestResult) + "/HTML_Design_Files/IMG/logpass.png\" />";
            }
            case FAILED: {
                return "<img style=\"height:18px;width:18px;border:none\"  alt=\"FAIL\" src=\"../" + TestCaseReportsPageWriter.getTestCaseHTMLPath(iTestResult) + "/HTML_Design_Files/IMG/logfail.png\" />";
            }
            case INFO: {
                return "<img style=\"height:20px;width:20px;border:none\" alt=\"INFO\" src=\"../" + TestCaseReportsPageWriter.getTestCaseHTMLPath(iTestResult) + "/HTML_Design_Files/IMG/loginfo.png\" />";
            }
            case WARNING: {
                return "<img style=\"height:20px;width:20px;border:none\"  alt=\"WARNING\" src=\"../" + TestCaseReportsPageWriter.getTestCaseHTMLPath(iTestResult) + "/HTML_Design_Files/IMG/logwarning.png\" />";
            }
        }
        return "img";
    }

    /*
     * WARNING - void declaration
     */
    public static String getSkippedDescription(ITestResult iTestResult) {
        String[] stringArray = iTestResult.getMethod().getGroupsDependedUpon();
        String[] stringArray2 = iTestResult.getMethod().getMethodsDependedUpon();
        String string = "";
        for (String string2 : stringArray) {
            string = string + string2;
        }
        String string3 = "";
        for (String string4 : stringArray2) {
            void var4_6;
            String string5 = (String)var4_6 + string4;
        }
        return "";
    }

    private static String getBrowserName(ITestResult iTestResult) {
        try {
            return iTestResult.getAttribute(Platform.BROWSER_NAME_PROP).toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getBrowserVersion(ITestResult iTestResult) {
        try {
            return iTestResult.getAttribute(Platform.BROWSER_VERSION_PROP).toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getColorBasedOnResult(ITestResult iTestResult) {
        if (iTestResult.getStatus() == 1) {
            return Colors.PASS.getColor();
        }
        if (iTestResult.getStatus() == 2) {
            return Colors.FAIL.getColor();
        }
        if (iTestResult.getStatus() == 3) {
            return Colors.SKIP.getColor();
        }
        return Colors.PASS.getColor();
    }

    private static String getResult(ITestResult iTestResult) {
        if (iTestResult.getStatus() == 1) {
            try {
                if (iTestResult.getAttribute("passedButFailed").equals("passedButFailed")) {
                    return "Failed";
                }
                return "Passed";
            }
            catch (Exception exception) {
                return "Passed";
            }
        }
        if (iTestResult.getStatus() == 2) {
            return "Failed";
        }
        if (iTestResult.getStatus() == 3) {
            return "Skipped";
        }
        return "Unknown";
    }

    public static String getTestCaseHTMLPath(ITestResult iTestResult) {
        String string = iTestResult.getAttribute("reportDir").toString();
        string = string.substring(string.indexOf(Directory.RESULTSDir) + (Directory.RESULTSDir.length() + 1));
        String[] stringArray = string.replace(Directory.SEP, "##@##@##").split("##@##@##");
        string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + "../";
        }
        return string;
    }

    public static void menuLink(PrintWriter printWriter, ITestResult iTestResult, int n) {
        TestCaseReportsPageWriter.getTestCaseHTMLPath(iTestResult);
        printWriter.println("\n            <tr id=\"container\">\n                <td id=\"menu\">\n                    <ul> \n");
        printWriter.println(" <li class=\"menuStyle\"><a href=\"../" + TestCaseReportsPageWriter.getTestCaseHTMLPath(iTestResult) + "index.html\" >Index</a></li>" + "<li style=\"padding-top: 4px;\"><a href=\"" + TestCaseReportsPageWriter.getTestCaseHTMLPath(iTestResult) + "ConsolidatedPage.html\" >Consolidated Page</a></li>\n");
        if (n == 1) {
            printWriter.println("\n <li class=\"menuStyle\"><a href=\"" + Directory.RUNName + n + Directory.SEP + "CurrentRun.html\" >" + "Run " + n + " </a></li>\n");
        } else {
            for (int i = 1; i <= n; ++i) {
                if (i == n) {
                    printWriter.println("\n <li style=\"padding-top: 4px;padding-bottom: 4px;\"><a href=\"" + Directory.RUNName + i + Directory.SEP + "CurrentRun.html\" >" + "Run " + i + " </a></li>\n");
                    break;
                }
                printWriter.println("\n <li class=\"menuStyle\"><a href=\"" + Directory.RUNName + i + Directory.SEP + "CurrentRun.html\" >" + "Run " + i + " </a></li>\n");
            }
        }
        printWriter.println("\n                    </ul>\n                </td>\n\n");
    }
}

