/*
 * Decompiled with CFR 0.152.
 */
package atu.testrecorder.media.avi;

import atu.testrecorder.media.Buffer;
import atu.testrecorder.media.MovieWriter;
import atu.testrecorder.media.VideoFormat;
import atu.testrecorder.media.avi.AbstractAVIStream;
import atu.testrecorder.media.avi.DIBCodec;
import atu.testrecorder.media.avi.DataChunkOutputStream;
import atu.testrecorder.media.avi.RunLengthCodec;
import atu.testrecorder.media.avi.TechSmithCodec;
import atu.testrecorder.media.jpeg.JPEGCodec;
import atu.testrecorder.media.png.PNGCodec;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;

public class AVIWriter
extends AbstractAVIStream
implements MovieWriter {
    public static final VideoFormat VIDEO_RAW = new VideoFormat("DIB ");
    public static final VideoFormat VIDEO_JPEG = new VideoFormat("MJPG");
    public static final VideoFormat VIDEO_PNG = new VideoFormat("png ");
    public static final VideoFormat VIDEO_SCREEN_CAPTURE = new VideoFormat("tscc");
    private States state = States.FINISHED;
    private AbstractAVIStream.CompositeChunk aviChunk;
    private AbstractAVIStream.CompositeChunk moviChunk;
    AbstractAVIStream.FixedSizeDataChunk avihChunk;

    public AVIWriter(File file) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        this.out = new FileImageOutputStream(file);
        this.streamOffset = 0L;
    }

    public AVIWriter(ImageOutputStream out) throws IOException {
        this.out = out;
        this.streamOffset = out.getStreamPosition();
    }

    public int addVideoTrack(VideoFormat format, long timeScale, long frameRate, int width, int height, int depth, int syncInterval) throws IOException {
        return this.addVideoTrack(format.getEncoding(), timeScale, frameRate, width, height, depth, syncInterval);
    }

    public int addVideoTrack(VideoFormat format, long timeScale, long frameRate, int syncInterval) throws IOException {
        return this.addVideoTrack(format.getEncoding(), timeScale, frameRate, format.getWidth(), format.getHeight(), format.getDepth(), syncInterval);
    }

    public int addVideoTrack(VideoFormat format, long timeScale, long frameRate, int width, int height) throws IOException {
        return this.addVideoTrack(format.getEncoding(), timeScale, frameRate, width, height, 24, 24);
    }

    public int addVideoTrack(String fourCC, long timeScale, long frameRate, int width, int height, int depth, int syncInterval) throws IOException {
        AbstractAVIStream.VideoTrack vt = new AbstractAVIStream.VideoTrack(this, this.tracks.size(), fourCC);
        vt.videoFormat = new VideoFormat(fourCC, byte[].class, width, height, depth);
        vt.timeScale = timeScale;
        vt.frameRate = frameRate;
        vt.syncInterval = syncInterval;
        vt.rcFrame = new Rectangle(0, 0, width, height);
        vt.samples = new LinkedList();
        if (vt.videoFormat.getDepth() == 4) {
            byte[] gray = new byte[16];
            int i = 0;
            while (i < gray.length) {
                gray[i] = (byte)(i << 4 | i);
                ++i;
            }
            vt.palette = new IndexColorModel(4, 16, gray, gray, gray);
        } else if (vt.videoFormat.getDepth() == 8) {
            byte[] gray = new byte[256];
            int i = 0;
            while (i < gray.length) {
                gray[i] = (byte)i;
                ++i;
            }
            vt.palette = new IndexColorModel(8, 256, gray, gray, gray);
        }
        this.createCodec(vt);
        this.tracks.add(vt);
        return this.tracks.size() - 1;
    }

    public void setPalette(int track, IndexColorModel palette) {
        ((AbstractAVIStream.VideoTrack)this.tracks.get((int)track)).palette = palette;
    }

    public void setCompressionQuality(int track, float newValue) {
        AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)this.tracks.get(track);
        vt.videoQuality = newValue;
        if (vt.codec != null) {
            vt.codec.setQuality(newValue);
        }
    }

    public float getVideoCompressionQuality(int track) {
        return ((AbstractAVIStream.VideoTrack)this.tracks.get((int)track)).videoQuality;
    }

    public void setVideoDimension(int track, int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("width and height must be greater zero.");
        }
        AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)this.tracks.get(track);
        vt.videoFormat = new VideoFormat(vt.videoFormat.getEncoding(), byte[].class, width, height, vt.videoFormat.getDepth());
    }

    public Dimension getVideoDimension(int track) {
        AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)this.tracks.get(track);
        VideoFormat fmt = vt.videoFormat;
        return new Dimension(fmt.getWidth(), fmt.getHeight());
    }

    private void ensureStarted() throws IOException {
        if (this.state != States.STARTED) {
            this.writeProlog();
            this.state = States.STARTED;
        }
    }

    @Override
    public void writeFrame(int track, BufferedImage image, long duration) throws IOException {
        this.ensureStarted();
        AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)this.tracks.get(track);
        if (vt.codec == null) {
            throw new UnsupportedOperationException("No codec for this video format.");
        }
        VideoFormat fmt = vt.videoFormat;
        if (fmt.getWidth() != image.getWidth() || fmt.getHeight() != image.getHeight()) {
            throw new IllegalArgumentException("Dimensions of image[" + vt.samples.size() + "] (width=" + image.getWidth() + ", height=" + image.getHeight() + ") differs from image[0] (width=" + fmt.getWidth() + ", height=" + fmt.getHeight());
        }
        long offset = this.getRelativeStreamPosition();
        switch (fmt.getDepth()) {
            case 4: {
                IndexColorModel imgPalette = (IndexColorModel)image.getColorModel();
                int[] imgRGBs = new int[16];
                imgPalette.getRGBs(imgRGBs);
                int[] previousRGBs = new int[16];
                if (vt.previousPalette == null) {
                    vt.previousPalette = vt.palette;
                }
                vt.previousPalette.getRGBs(previousRGBs);
                if (Arrays.equals(imgRGBs, previousRGBs)) break;
                vt.previousPalette = imgPalette;
                AbstractAVIStream.DataChunk paletteChangeChunk = new AbstractAVIStream.DataChunk(this, String.valueOf(vt.twoCC) + "pc");
                int first = 0;
                int last = imgPalette.getMapSize() - 1;
                DataChunkOutputStream pOut = paletteChangeChunk.getOutputStream();
                pOut.writeByte(first);
                pOut.writeByte(last - first + 1);
                pOut.writeShort(0);
                int i = first;
                while (i <= last) {
                    pOut.writeByte(imgRGBs[i] >>> 16 & 0xFF);
                    pOut.writeByte(imgRGBs[i] >>> 8 & 0xFF);
                    pOut.writeByte(imgRGBs[i] & 0xFF);
                    pOut.writeByte(0);
                    ++i;
                }
                this.moviChunk.add(paletteChangeChunk);
                paletteChangeChunk.finish();
                long length = this.getRelativeStreamPosition() - offset;
                vt.samples.add(new AbstractAVIStream.Sample(paletteChangeChunk.chunkType, 0, offset, length - 8L, false));
                offset = this.getRelativeStreamPosition();
                break;
            }
            case 8: {
                IndexColorModel imgPalette = (IndexColorModel)image.getColorModel();
                int[] imgRGBs = new int[256];
                imgPalette.getRGBs(imgRGBs);
                int[] previousRGBs = new int[256];
                if (vt.previousPalette == null) {
                    vt.previousPalette = vt.palette;
                }
                vt.previousPalette.getRGBs(previousRGBs);
                if (Arrays.equals(imgRGBs, previousRGBs)) break;
                vt.previousPalette = imgPalette;
                AbstractAVIStream.DataChunk paletteChangeChunk = new AbstractAVIStream.DataChunk(this, String.valueOf(vt.twoCC) + "pc");
                int first = 0;
                int last = imgPalette.getMapSize() - 1;
                DataChunkOutputStream pOut = paletteChangeChunk.getOutputStream();
                pOut.writeByte(first);
                pOut.writeByte(last - first + 1);
                pOut.writeShort(0);
                int i = first;
                while (i <= last) {
                    pOut.writeByte(imgRGBs[i] >>> 16 & 0xFF);
                    pOut.writeByte(imgRGBs[i] >>> 8 & 0xFF);
                    pOut.writeByte(imgRGBs[i] & 0xFF);
                    pOut.writeByte(0);
                    ++i;
                }
                this.moviChunk.add(paletteChangeChunk);
                paletteChangeChunk.finish();
                long length = this.getRelativeStreamPosition() - offset;
                vt.samples.add(new AbstractAVIStream.Sample(paletteChangeChunk.chunkType, 0, offset, length - 8L, false));
                offset = this.getRelativeStreamPosition();
            }
        }
        if (vt.outputBuffer == null) {
            vt.outputBuffer = new Buffer();
        }
        boolean isSync = vt.syncInterval == 0 ? false : vt.samples.size() % vt.syncInterval == 0;
        Buffer inputBuffer = new Buffer();
        inputBuffer.flags = isSync ? 16 : 0;
        inputBuffer.data = image;
        vt.codec.process(inputBuffer, vt.outputBuffer);
        if (vt.outputBuffer.flags == 2) {
            return;
        }
        isSync = (vt.outputBuffer.flags & 0x10) != 0;
        long offset2 = this.getRelativeStreamPosition();
        AbstractAVIStream.DataChunk videoFrameChunk = new AbstractAVIStream.DataChunk(this, isSync ? String.valueOf(vt.twoCC) + "db" : String.valueOf(vt.twoCC) + "dc");
        this.moviChunk.add(videoFrameChunk);
        videoFrameChunk.getOutputStream().write((byte[])vt.outputBuffer.data, vt.outputBuffer.offset, vt.outputBuffer.length);
        videoFrameChunk.finish();
        long length = this.getRelativeStreamPosition() - offset2;
        vt.samples.add(new AbstractAVIStream.Sample(videoFrameChunk.chunkType, (int)vt.frameRate, offset2, length - 8L, isSync));
        if (this.getRelativeStreamPosition() > 0x100000000L) {
            throw new IOException("AVI file is larger than 4 GB");
        }
    }

    private void createCodec(AbstractAVIStream.VideoTrack vt) {
        VideoFormat fmt = vt.videoFormat;
        String enc = fmt.getEncoding();
        if (enc.equals("MJPG")) {
            vt.codec = new JPEGCodec();
        } else if (enc.equals("png ")) {
            vt.codec = new PNGCodec();
        } else if (enc.equals("DIB ")) {
            vt.codec = new DIBCodec();
        } else if (enc.equals("RLE ")) {
            vt.codec = new RunLengthCodec();
        } else if (enc.equals("tscc")) {
            vt.codec = new TechSmithCodec();
        }
        vt.codec.setInputFormat(new VideoFormat(enc, BufferedImage.class, fmt.getWidth(), fmt.getHeight(), fmt.getDepth()));
        vt.codec.setOutputFormat(new VideoFormat(enc, byte[].class, fmt.getWidth(), fmt.getHeight(), fmt.getDepth()));
        vt.codec.setQuality(vt.videoQuality);
    }

    public void writeFrame(int track, File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.writeFrame(track, in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void writeFrame(int track, InputStream in) throws IOException {
        int len;
        this.ensureStarted();
        AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)this.tracks.get(track);
        AbstractAVIStream.DataChunk videoFrameChunk = new AbstractAVIStream.DataChunk(this, vt.videoFormat.getEncoding().equals("DIB ") ? String.valueOf(vt.twoCC) + "db" : String.valueOf(vt.twoCC) + "dc");
        this.moviChunk.add(videoFrameChunk);
        DataChunkOutputStream mdatOut = videoFrameChunk.getOutputStream();
        long offset = this.getRelativeStreamPosition();
        byte[] buf = new byte[512];
        while ((len = in.read(buf)) != -1) {
            ((OutputStream)mdatOut).write(buf, 0, len);
        }
        long length = this.getRelativeStreamPosition() - offset;
        videoFrameChunk.finish();
        vt.samples.add(new AbstractAVIStream.Sample(videoFrameChunk.chunkType, (int)vt.frameRate, offset, length - 8L, true));
        if (this.getRelativeStreamPosition() > 0x100000000L) {
            throw new IOException("AVI file is larger than 4 GB");
        }
    }

    @Override
    public void writeSample(int track, byte[] data, int off, int len, long duration, boolean isSync) throws IOException {
        this.ensureStarted();
        AbstractAVIStream.Track t = (AbstractAVIStream.Track)this.tracks.get(track);
        if (!(t instanceof AbstractAVIStream.VideoTrack)) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)t;
        AbstractAVIStream.DataChunk dc = new AbstractAVIStream.DataChunk(this, vt.videoFormat.getEncoding().equals("DIB ") ? String.valueOf(vt.twoCC) + "db" : String.valueOf(vt.twoCC) + "dc");
        this.moviChunk.add(dc);
        DataChunkOutputStream mdatOut = dc.getOutputStream();
        long offset = this.getRelativeStreamPosition();
        ((OutputStream)mdatOut).write(data, off, len);
        long length = this.getRelativeStreamPosition() - offset;
        dc.finish();
        t.samples.add(new AbstractAVIStream.Sample(dc.chunkType, (int)t.frameRate, offset, length - 8L, true));
        if (this.getRelativeStreamPosition() > 0x100000000L) {
            throw new IOException("AVI file is larger than 4 GB");
        }
    }

    @Override
    public void writeSamples(int track, int sampleCount, byte[] data, int off, int len, long sampleDuration, boolean isSync) throws IOException {
        int i = 0;
        while (i < sampleCount) {
            this.writeSample(track, data, off, len / sampleCount, sampleDuration, isSync);
            off += len / sampleCount;
            ++i;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.state == States.STARTED) {
            this.finish();
        }
        if (this.state != States.CLOSED) {
            this.out.close();
            this.state = States.CLOSED;
        }
    }

    public void finish() throws IOException {
        this.ensureOpen();
        if (this.state != States.FINISHED) {
            for (AbstractAVIStream.Track tr : this.tracks) {
                if (!(tr instanceof AbstractAVIStream.VideoTrack)) continue;
                AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)tr;
                VideoFormat fmt = vt.videoFormat;
                if (fmt.getWidth() != -1 && fmt.getHeight() != -1) continue;
                throw new IllegalStateException("image width and height must be specified");
            }
            this.moviChunk.finish();
            this.writeEpilog();
            this.state = States.FINISHED;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.state == States.CLOSED) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public boolean isVFRSupported() {
        return false;
    }

    @Override
    public boolean isDataLimitReached() {
        try {
            return this.getRelativeStreamPosition() > 0x73333333L;
        }
        catch (IOException ex) {
            return true;
        }
    }

    private void writeProlog() throws IOException {
        this.aviChunk = new AbstractAVIStream.CompositeChunk(this, "RIFF", "AVI ");
        AbstractAVIStream.CompositeChunk hdrlChunk = new AbstractAVIStream.CompositeChunk(this, "LIST", "hdrl");
        this.aviChunk.add(hdrlChunk);
        this.avihChunk = new AbstractAVIStream.FixedSizeDataChunk(this, "avih", 56L);
        this.avihChunk.seekToEndOfChunk();
        hdrlChunk.add(this.avihChunk);
        AbstractAVIStream.CompositeChunk strlChunk = new AbstractAVIStream.CompositeChunk(this, "LIST", "strl");
        hdrlChunk.add(strlChunk);
        for (AbstractAVIStream.Track tr : this.tracks) {
            if (tr instanceof AbstractAVIStream.VideoTrack) {
                AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)tr;
                vt.strhChunk = new AbstractAVIStream.FixedSizeDataChunk(this, "strh", 56L);
                vt.strhChunk.seekToEndOfChunk();
                strlChunk.add(vt.strhChunk);
                vt.strfChunk = new AbstractAVIStream.FixedSizeDataChunk(this, "strf", vt.palette == null ? 40 : 40 + vt.palette.getMapSize() * 4);
                vt.strfChunk.seekToEndOfChunk();
                strlChunk.add(vt.strfChunk);
                continue;
            }
            throw new UnsupportedOperationException("Track type not implemented yet.");
        }
        this.moviChunk = new AbstractAVIStream.CompositeChunk(this, "LIST", "movi");
        this.aviChunk.add(this.moviChunk);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeEpilog() throws IOException {
        long largestBufferSize = 0L;
        long duration = 0L;
        for (AbstractAVIStream.Track tr : this.tracks) {
            if (!(tr instanceof AbstractAVIStream.VideoTrack)) continue;
            AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)tr;
            long trackDuration = 0L;
            for (Object s : vt.samples) {
                trackDuration += (long)((AbstractAVIStream.Sample)s).duration;
            }
            duration = Math.max(duration, trackDuration);
            for (Object s : vt.samples) {
                if (((AbstractAVIStream.Sample)s).length <= largestBufferSize) continue;
                largestBufferSize = ((AbstractAVIStream.Sample)s).length;
            }
        }
        AbstractAVIStream.DataChunk idx1Chunk = new AbstractAVIStream.DataChunk(this, "idx1");
        this.aviChunk.add(idx1Chunk);
        DataChunkOutputStream d = idx1Chunk.getOutputStream();
        long moviListOffset = this.moviChunk.offset + 8L;
        for (AbstractAVIStream.Track tr : this.tracks) {
            if (!(tr instanceof AbstractAVIStream.VideoTrack)) throw new UnsupportedOperationException("Track type not yet implemented.");
            AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)tr;
            for (AbstractAVIStream.Sample f : vt.samples) {
                d.writeType(f.chunkType);
                d.writeUInt((f.chunkType.endsWith("pc") ? 256 : 0) | (f.isSync ? 16 : 0));
                d.writeUInt(f.offset - moviListOffset);
                d.writeUInt(f.length);
            }
        }
        idx1Chunk.finish();
        this.avihChunk.seekToStartOfData();
        d = this.avihChunk.getOutputStream();
        AbstractAVIStream.Track tt = (AbstractAVIStream.Track)this.tracks.get(0);
        d.writeUInt(1000000L * tt.timeScale / tt.frameRate);
        d.writeUInt(0L);
        d.writeUInt(0L);
        d.writeUInt(48L);
        long dwTotalFrames = 0L;
        for (AbstractAVIStream.Track t : this.tracks) {
            dwTotalFrames += (long)t.samples.size();
        }
        d.writeUInt(dwTotalFrames);
        d.writeUInt(0L);
        d.writeUInt(1L);
        d.writeUInt(largestBufferSize);
        AbstractAVIStream.VideoTrack vt = null;
        for (AbstractAVIStream.Track t : this.tracks) {
            if (!(t instanceof AbstractAVIStream.VideoTrack)) continue;
            vt = (AbstractAVIStream.VideoTrack)t;
            break;
        }
        VideoFormat fmt = vt.videoFormat;
        d.writeUInt(vt == null ? 0 : fmt.getWidth());
        d.writeUInt(vt == null ? 0 : fmt.getHeight());
        d.writeUInt(0L);
        d.writeUInt(0L);
        d.writeUInt(0L);
        d.writeUInt(0L);
        for (AbstractAVIStream.Track tr : this.tracks) {
            tr.strhChunk.seekToStartOfData();
            d = tr.strhChunk.getOutputStream();
            d.writeType(tr.mediaType.fccType);
            d.writeType(tr.fourCC);
            if (tr instanceof AbstractAVIStream.VideoTrack && ((AbstractAVIStream.VideoTrack)tr).videoFormat.getDepth() <= 8) {
                d.writeUInt(65536L);
            } else {
                d.writeUInt(0L);
            }
            d.writeUShort(0);
            d.writeUShort(0);
            d.writeUInt(0L);
            d.writeUInt(tr.timeScale);
            d.writeUInt(tr.frameRate);
            d.writeUInt(0L);
            d.writeUInt(tr.samples.size());
            long dwSuggestedBufferSize = 0L;
            for (AbstractAVIStream.Sample s : tr.samples) {
                if (s.length <= dwSuggestedBufferSize) continue;
                dwSuggestedBufferSize = s.length;
            }
            d.writeUInt(dwSuggestedBufferSize);
            d.writeInt(-1);
            d.writeUInt(0L);
            d.writeUShort(tr instanceof AbstractAVIStream.VideoTrack ? ((AbstractAVIStream.VideoTrack)tr).rcFrame.x : 0);
            d.writeUShort(tr instanceof AbstractAVIStream.VideoTrack ? ((AbstractAVIStream.VideoTrack)tr).rcFrame.y : 0);
            d.writeUShort(tr instanceof AbstractAVIStream.VideoTrack ? ((AbstractAVIStream.VideoTrack)tr).rcFrame.x + ((AbstractAVIStream.VideoTrack)tr).rcFrame.width : 0);
            d.writeUShort(tr instanceof AbstractAVIStream.VideoTrack ? ((AbstractAVIStream.VideoTrack)tr).rcFrame.y + ((AbstractAVIStream.VideoTrack)tr).rcFrame.height : 0);
            AbstractAVIStream.VideoTrack vt2 = (AbstractAVIStream.VideoTrack)tr;
            tr.strfChunk.seekToStartOfData();
            d = tr.strfChunk.getOutputStream();
            d.writeUInt(40L);
            d.writeInt(vt2.videoFormat.getWidth());
            d.writeInt(vt2.videoFormat.getHeight());
            d.writeShort(1);
            d.writeShort(vt2.videoFormat.getDepth());
            String enc = vt2.videoFormat.getEncoding();
            if (enc.equals("DIB ")) {
                d.writeInt(0);
            } else if (enc.equals("RLE ")) {
                if (vt2.videoFormat.getDepth() == 8) {
                    d.writeInt(1);
                } else {
                    if (vt2.videoFormat.getDepth() != 4) throw new UnsupportedOperationException("RLE only supports 4-bit and 8-bit images");
                    d.writeInt(2);
                }
            } else {
                d.writeType(vt2.videoFormat.getEncoding());
            }
            if (enc.equals("DIB ")) {
                d.writeInt(0);
            } else {
                VideoFormat fmt2 = vt2.videoFormat;
                if (fmt2.getDepth() == 4) {
                    d.writeInt(fmt2.getWidth() * fmt2.getHeight() / 2);
                } else {
                    int bytesPerPixel = Math.max(1, fmt2.getDepth() / 8);
                    d.writeInt(fmt2.getWidth() * fmt2.getHeight() * bytesPerPixel);
                }
            }
            d.writeInt(0);
            d.writeInt(0);
            d.writeInt(vt2.palette == null ? 0 : vt2.palette.getMapSize());
            d.writeInt(0);
            if (vt2.palette == null) continue;
            int i = 0;
            int n = vt2.palette.getMapSize();
            while (i < n) {
                d.write(vt2.palette.getBlue(i));
                d.write(vt2.palette.getGreen(i));
                d.write(vt2.palette.getRed(i));
                d.write(0);
                ++i;
            }
        }
        this.aviChunk.finish();
    }

    private static enum States {
        STARTED,
        FINISHED,
        CLOSED;

    }
}

