/*
 * Decompiled with CFR 0.152.
 */
package atu.testrecorder.media.quicktime;

import atu.testrecorder.media.AbstractVideoCodec;
import atu.testrecorder.media.Buffer;
import atu.testrecorder.media.Format;
import atu.testrecorder.media.VideoFormat;
import atu.testrecorder.media.io.ByteArrayImageOutputStream;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class AnimationCodec
extends AbstractVideoCodec {
    private Object previousPixels;
    private short[] test;

    @Override
    public Format setInputFormat(Format f) {
        if (f instanceof VideoFormat) {
            VideoFormat vf = (VideoFormat)f;
            int depth = vf.getDepth();
            depth = depth <= 8 ? 8 : (depth <= 16 ? 16 : (depth <= 24 ? 24 : 32));
            if (BufferedImage.class.isAssignableFrom(vf.getDataClass())) {
                return super.setInputFormat(new VideoFormat("rle ", "Animation", vf.getDataClass(), vf.getWidth(), vf.getHeight(), depth));
            }
        }
        return super.setInputFormat(null);
    }

    @Override
    public Format setOutputFormat(Format f) {
        if (f instanceof VideoFormat) {
            VideoFormat vf = (VideoFormat)f;
            int depth = vf.getDepth();
            depth = depth <= 8 ? 8 : (depth <= 16 ? 16 : (depth <= 24 ? 24 : 32));
            return super.setOutputFormat(new VideoFormat("rle ", "Animation", byte[].class, vf.getWidth(), vf.getHeight(), depth));
        }
        return super.setOutputFormat(null);
    }

    @Override
    public void process(Buffer in, Buffer out) {
        Rectangle r;
        int scanlineStride;
        if ((in.flags & 2) != 0) {
            out.flags = 2;
            return;
        }
        out.format = this.outputFormat;
        ByteArrayImageOutputStream tmp = out.data instanceof byte[] ? new ByteArrayImageOutputStream((byte[])out.data) : new ByteArrayImageOutputStream();
        VideoFormat vf = (VideoFormat)this.outputFormat;
        if (in.data instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)in.data;
            WritableRaster raster = image.getRaster();
            scanlineStride = raster.getSampleModel().getWidth();
            r = raster.getBounds();
            r.x -= raster.getSampleModelTranslateX();
            r.y -= raster.getSampleModelTranslateY();
        } else {
            r = new Rectangle(0, 0, vf.getWidth(), vf.getHeight());
            scanlineStride = vf.getWidth();
        }
        try {
            switch (vf.getDepth()) {
                case 8: {
                    Object[] pixels = this.getIndexed8(in);
                    if (pixels == null) {
                        throw new UnsupportedOperationException("Unable to process buffer " + in);
                    }
                    if ((in.flags & 0x10) != 0 || this.previousPixels == null) {
                        this.encodeKey8(tmp, (byte[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.flags = 16;
                    } else {
                        this.encodeDelta8(tmp, (byte[])pixels, (byte[])this.previousPixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.flags = 0;
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, this.previousPixels, 0, pixels.length);
                    break;
                }
                case 16: {
                    Object[] pixels = this.getRGB15(in);
                    if (pixels == null) {
                        throw new UnsupportedOperationException("Unable to process buffer " + in);
                    }
                    if ((in.flags & 0x10) != 0 || this.previousPixels == null) {
                        this.encodeKey16(tmp, (short[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.flags = 16;
                    } else {
                        this.encodeDelta16(tmp, (short[])pixels, (short[])this.previousPixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.flags = 0;
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, this.previousPixels, 0, pixels.length);
                    break;
                }
                case 24: {
                    Object[] pixels = this.getRGB24(in);
                    if (pixels == null) {
                        throw new UnsupportedOperationException("Unable to process buffer " + in);
                    }
                    if ((in.flags & 0x10) != 0 || this.previousPixels == null) {
                        this.encodeKey24(tmp, (int[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.flags = 16;
                    } else {
                        this.encodeDelta24(tmp, (int[])pixels, (int[])this.previousPixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.flags = 0;
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, this.previousPixels, 0, pixels.length);
                    break;
                }
                case 32: {
                    Object[] pixels = this.getARGB32(in);
                    if (pixels == null) {
                        out.flags = 2;
                        return;
                    }
                    if ((in.flags & 0x10) != 0 || this.previousPixels == null) {
                        this.encodeKey32(tmp, (int[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.flags = 16;
                    } else {
                        this.encodeDelta32(tmp, (int[])pixels, (int[])this.previousPixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.flags = 0;
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, this.previousPixels, 0, pixels.length);
                    break;
                }
                default: {
                    out.flags = 2;
                    return;
                }
            }
            out.data = tmp.getBuffer();
            out.offset = 0;
            out.length = (int)tmp.getStreamPosition();
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.flags = 2;
            return;
        }
    }

    public void encodeKey8(ImageOutputStream out, byte[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        if (width % 4 != 0 || offset % 4 != 0 || scanlineStride % 4 != 0) {
            throw new UnsupportedOperationException("Conversion is not fully implemented yet.");
        }
        int[] ints = new int[data.length / 4];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            ints[j] = (data[i] & 0xFF) << 24 | (data[i + 1] & 0xFF) << 16 | (data[i + 2] & 0xFF) << 8 | data[i + 3] & 0xFF;
            i += 4;
            ++j;
        }
        this.encodeKey32(out, ints, width / 4, height, offset / 4, scanlineStride / 4);
    }

    public void encodeDelta8(ImageOutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        if (width % 4 != 0 || offset % 4 != 0 || scanlineStride % 4 != 0) {
            throw new UnsupportedOperationException("Conversion is not fully implemented yet.");
        }
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        int[] ints = new int[data.length / 4];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            ints[j] = (data[i] & 0xFF) << 24 | (data[i + 1] & 0xFF) << 16 | (data[i + 2] & 0xFF) << 8 | data[i + 3] & 0xFF;
            i += 4;
            ++j;
        }
        int[] pints = new int[prev.length / 4];
        int i2 = 0;
        int j2 = 0;
        while (i2 < prev.length) {
            pints[j2] = (prev[i2] & 0xFF) << 24 | (prev[i2 + 1] & 0xFF) << 16 | (prev[i2 + 2] & 0xFF) << 8 | prev[i2 + 3] & 0xFF;
            i2 += 4;
            ++j2;
        }
        this.encodeDelta32(out, ints, pints, width / 4, height, offset / 4, scanlineStride / 4);
    }

    public void encodeKey16(ImageOutputStream out, short[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        long headerPos = out.getStreamPosition();
        out.writeInt(0);
        out.writeShort(0);
        int ymax = offset + height * scanlineStride;
        int y = offset;
        while (y < ymax) {
            int xy = y;
            int xymax = y + width;
            out.write(1);
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                short v = data[xy];
                repeatCount = 0;
                while (xy < xymax && repeatCount < 127) {
                    if (data[xy] != v) break;
                    ++xy;
                    ++repeatCount;
                }
                xy -= repeatCount;
                if (repeatCount < 2) {
                    if (++literalCount == 127) {
                        out.write(literalCount);
                        out.writeShorts(data, xy - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        out.write(literalCount);
                        out.writeShorts(data, xy - literalCount, literalCount);
                        literalCount = 0;
                    }
                    out.write(-repeatCount);
                    out.writeShort(v);
                    xy += repeatCount - 1;
                }
                ++xy;
            }
            if (literalCount > 0) {
                out.write(literalCount);
                out.writeShorts(data, xy - literalCount, literalCount);
                literalCount = 0;
            }
            out.write(-1);
            y += scanlineStride;
        }
        long pos = out.getStreamPosition();
        out.seek(headerPos);
        out.writeInt((int)(pos - headerPos));
        out.seek(pos);
    }

    /*
     * Unable to fully structure code
     */
    public void encodeDelta16(ImageOutputStream out, short[] data, short[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        ymax = offset + height * scanlineStride;
        ymin = offset;
        block0: while (ymin < ymax) {
            xy = ymin;
            xymax = ymin + width;
            while (xy < xymax) {
                if (data[xy] != prev[xy]) break block0;
                ++xy;
            }
            ymin += scanlineStride;
        }
        if (ymin != ymax) ** GOTO lbl23
        out.writeInt(4);
        return;
lbl-1000:
        // 1 sources

        {
            xy = ymax - scanlineStride;
            xymax = ymax - scanlineStride + width;
            while (xy < xymax) {
                if (data[xy] != prev[xy]) break block2;
                ++xy;
            }
            ymax -= scanlineStride;
lbl23:
            // 2 sources

            ** while (ymax > ymin)
        }
lbl24:
        // 2 sources

        headerPos = out.getStreamPosition();
        out.writeInt(0);
        if (ymin == offset && ymax == offset + height * scanlineStride) {
            out.writeShort(0);
        } else {
            out.writeShort(8);
            out.writeShort((ymin - offset) / scanlineStride);
            out.writeShort(0);
            out.writeShort((ymax - ymin + 1 - offset) / scanlineStride);
            out.writeShort(0);
        }
        y = ymin;
        while (y < ymax) {
            xy = y;
            xymax = y + width;
            skipCount = 0;
            while (xy < xymax) {
                if (data[xy] != prev[xy]) break;
                ++xy;
                ++skipCount;
            }
            if (skipCount == width) {
                out.write(1);
                out.write(-1);
            } else {
                out.write(Math.min(255, skipCount + 1));
                skipCount -= Math.min(254, skipCount);
                while (skipCount > 0) {
                    out.write(0);
                    out.write(Math.min(255, skipCount + 1));
                    skipCount -= Math.min(254, skipCount);
                }
                literalCount = 0;
                repeatCount = 0;
                while (xy < xymax) {
                    skipCount = 0;
                    while (xy < xymax) {
                        if (data[xy] != prev[xy]) break;
                        ++xy;
                        ++skipCount;
                    }
                    v = data[xy -= skipCount];
                    repeatCount = 0;
                    while (xy < xymax && repeatCount < 127) {
                        if (data[xy] != v) break;
                        ++xy;
                        ++repeatCount;
                    }
                    if (skipCount < 2 && (xy -= repeatCount) + skipCount < xymax && repeatCount < 2) {
                        if (++literalCount == 127) {
                            out.write(literalCount);
                            out.writeShorts(data, xy - literalCount + 1, literalCount);
                            literalCount = 0;
                        }
                    } else {
                        if (literalCount > 0) {
                            out.write(literalCount);
                            out.writeShorts(data, xy - literalCount, literalCount);
                            literalCount = 0;
                        }
                        if (xy + skipCount == xymax) {
                            xy += skipCount - 1;
                        } else if (skipCount >= repeatCount) {
                            xy += skipCount - 1;
                            while (skipCount > 0) {
                                out.write(0);
                                out.write(Math.min(255, skipCount + 1));
                                skipCount -= Math.min(254, skipCount);
                            }
                        } else {
                            out.write(-repeatCount);
                            out.writeShort(v);
                            xy += repeatCount - 1;
                        }
                    }
                    ++xy;
                }
                if (literalCount > 0) {
                    out.write(literalCount);
                    out.writeShorts(data, xy - literalCount, literalCount);
                    literalCount = 0;
                }
                out.write(-1);
            }
            y += scanlineStride;
        }
        pos = out.getStreamPosition();
        out.seek(headerPos);
        out.writeInt((int)(pos - headerPos));
        out.seek(pos);
    }

    public void encodeKey24(ImageOutputStream out, int[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        long headerPos = out.getStreamPosition();
        out.writeInt(0);
        out.writeShort(0);
        int ymax = offset + height * scanlineStride;
        int y = offset;
        while (y < ymax) {
            int xy = y;
            int xymax = y + width;
            out.write(1);
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                int v = data[xy];
                repeatCount = 0;
                while (xy < xymax && repeatCount < 127) {
                    if (data[xy] != v) break;
                    ++xy;
                    ++repeatCount;
                }
                xy -= repeatCount;
                if (repeatCount < 2) {
                    if (++literalCount > 126) {
                        out.write(literalCount);
                        this.writeInts24(out, data, xy - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        out.write(literalCount);
                        this.writeInts24(out, data, xy - literalCount, literalCount);
                        literalCount = 0;
                    }
                    out.write(-repeatCount);
                    this.writeInt24(out, v);
                    xy += repeatCount - 1;
                }
                ++xy;
            }
            if (literalCount > 0) {
                out.write(literalCount);
                this.writeInts24(out, data, xy - literalCount, literalCount);
                literalCount = 0;
            }
            out.write(-1);
            y += scanlineStride;
        }
        long pos = out.getStreamPosition();
        out.seek(headerPos);
        out.writeInt((int)(pos - headerPos));
        out.seek(pos);
    }

    /*
     * Unable to fully structure code
     */
    public void encodeDelta24(ImageOutputStream out, int[] data, int[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        ymax = offset + height * scanlineStride;
        ymin = offset;
        block0: while (ymin < ymax) {
            xy = ymin;
            xymax = ymin + width;
            while (xy < xymax) {
                if (data[xy] != prev[xy]) break block0;
                ++xy;
            }
            ymin += scanlineStride;
        }
        if (ymin != ymax) ** GOTO lbl23
        out.writeInt(4);
        return;
lbl-1000:
        // 1 sources

        {
            xy = ymax - scanlineStride;
            xymax = ymax - scanlineStride + width;
            while (xy < xymax) {
                if (data[xy] != prev[xy]) break block2;
                ++xy;
            }
            ymax -= scanlineStride;
lbl23:
            // 2 sources

            ** while (ymax > ymin)
        }
lbl24:
        // 2 sources

        headerPos = out.getStreamPosition();
        out.writeInt(0);
        if (ymin == offset && ymax == offset + height * scanlineStride) {
            out.writeShort(0);
        } else {
            out.writeShort(8);
            out.writeShort((ymin - offset) / scanlineStride);
            out.writeShort(0);
            out.writeShort((ymax - ymin + 1 - offset) / scanlineStride);
            out.writeShort(0);
        }
        y = ymin;
        while (y < ymax) {
            xy = y;
            xymax = y + width;
            skipCount = 0;
            while (xy < xymax) {
                if (data[xy] != prev[xy]) break;
                ++xy;
                ++skipCount;
            }
            if (skipCount == width) {
                out.write(1);
                out.write(-1);
            } else {
                out.write(Math.min(255, skipCount + 1));
                skipCount -= Math.min(254, skipCount);
                while (skipCount > 0) {
                    out.write(0);
                    out.write(Math.min(255, skipCount + 1));
                    skipCount -= Math.min(254, skipCount);
                }
                literalCount = 0;
                repeatCount = 0;
                while (xy < xymax) {
                    skipCount = 0;
                    while (xy < xymax) {
                        if (data[xy] != prev[xy]) break;
                        ++xy;
                        ++skipCount;
                    }
                    v = data[xy -= skipCount];
                    repeatCount = 0;
                    while (xy < xymax && repeatCount < 127) {
                        if (data[xy] != v) break;
                        ++xy;
                        ++repeatCount;
                    }
                    if (skipCount < 1 && (xy -= repeatCount) + skipCount < xymax && repeatCount < 2) {
                        if (++literalCount == 127) {
                            out.write(literalCount);
                            this.writeInts24(out, data, xy - literalCount + 1, literalCount);
                            literalCount = 0;
                        }
                    } else {
                        if (literalCount > 0) {
                            out.write(literalCount);
                            this.writeInts24(out, data, xy - literalCount, literalCount);
                            literalCount = 0;
                        }
                        if (xy + skipCount == xymax) {
                            xy += skipCount - 1;
                        } else if (skipCount >= repeatCount) {
                            xy += skipCount - 1;
                            while (skipCount > 0) {
                                out.write(0);
                                out.write(Math.min(255, skipCount + 1));
                                skipCount -= Math.min(254, skipCount);
                            }
                        } else {
                            out.write(-repeatCount);
                            this.writeInt24(out, v);
                            xy += repeatCount - 1;
                        }
                    }
                    ++xy;
                }
                if (literalCount > 0) {
                    out.write(literalCount);
                    this.writeInts24(out, data, xy - literalCount, literalCount);
                    literalCount = 0;
                }
                out.write(-1);
            }
            y += scanlineStride;
        }
        pos = out.getStreamPosition();
        out.seek(headerPos);
        out.writeInt((int)(pos - headerPos));
        out.seek(pos);
    }

    public void encodeKey32(ImageOutputStream out, int[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        long headerPos = out.getStreamPosition();
        out.writeInt(0);
        out.writeShort(0);
        int ymax = offset + height * scanlineStride;
        int y = offset;
        while (y < ymax) {
            int xy = y;
            int xymax = y + width;
            out.write(1);
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                int v = data[xy];
                repeatCount = 0;
                while (xy < xymax && repeatCount < 127) {
                    if (data[xy] != v) break;
                    ++xy;
                    ++repeatCount;
                }
                xy -= repeatCount;
                if (repeatCount < 2) {
                    if (++literalCount > 126) {
                        out.write(literalCount);
                        out.writeInts(data, xy - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        out.write(literalCount);
                        out.writeInts(data, xy - literalCount, literalCount);
                        literalCount = 0;
                    }
                    out.write(-repeatCount);
                    out.writeInt(v);
                    xy += repeatCount - 1;
                }
                ++xy;
            }
            if (literalCount > 0) {
                out.write(literalCount);
                out.writeInts(data, xy - literalCount, literalCount);
                literalCount = 0;
            }
            out.write(-1);
            y += scanlineStride;
        }
        long pos = out.getStreamPosition();
        out.seek(headerPos);
        out.writeInt((int)(pos - headerPos));
        out.seek(pos);
    }

    /*
     * Unable to fully structure code
     */
    public void encodeDelta32(ImageOutputStream out, int[] data, int[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        ymax = offset + height * scanlineStride;
        ymin = offset;
        block0: while (ymin < ymax) {
            xy = ymin;
            xymax = ymin + width;
            while (xy < xymax) {
                if (data[xy] != prev[xy]) break block0;
                ++xy;
            }
            ymin += scanlineStride;
        }
        if (ymin != ymax) ** GOTO lbl23
        out.writeInt(4);
        return;
lbl-1000:
        // 1 sources

        {
            xy = ymax - scanlineStride;
            xymax = ymax - scanlineStride + width;
            while (xy < xymax) {
                if (data[xy] != prev[xy]) break block2;
                ++xy;
            }
            ymax -= scanlineStride;
lbl23:
            // 2 sources

            ** while (ymax > ymin)
        }
lbl24:
        // 2 sources

        headerPos = out.getStreamPosition();
        out.writeInt(0);
        if (ymin == offset && ymax == offset + height * scanlineStride) {
            out.writeShort(0);
        } else {
            out.writeShort(8);
            out.writeShort((ymin - offset) / scanlineStride);
            out.writeShort(0);
            out.writeShort((ymax - ymin + 1 - offset) / scanlineStride);
            out.writeShort(0);
        }
        y = ymin;
        while (y < ymax) {
            xy = y;
            xymax = y + width;
            skipCount = 0;
            while (xy < xymax) {
                if (data[xy] != prev[xy]) break;
                ++xy;
                ++skipCount;
            }
            if (skipCount == width) {
                out.write(1);
                out.write(-1);
            } else {
                out.write(Math.min(255, skipCount + 1));
                if (skipCount > 254) {
                    skipCount -= 254;
                    while (skipCount > 254) {
                        out.write(0);
                        out.write(255);
                        skipCount -= 254;
                    }
                    out.write(0);
                    out.write(skipCount + 1);
                }
                literalCount = 0;
                repeatCount = 0;
                while (xy < xymax) {
                    skipCount = 0;
                    while (xy < xymax) {
                        if (data[xy] != prev[xy]) break;
                        ++xy;
                        ++skipCount;
                    }
                    v = data[xy -= skipCount];
                    repeatCount = 0;
                    while (xy < xymax && repeatCount < 127) {
                        if (data[xy] != v) break;
                        ++xy;
                        ++repeatCount;
                    }
                    if (skipCount < 1 && (xy -= repeatCount) + skipCount < xymax && repeatCount < 2) {
                        if (++literalCount == 127) {
                            out.write(literalCount);
                            out.writeInts(data, xy - literalCount + 1, literalCount);
                            literalCount = 0;
                        }
                    } else {
                        if (literalCount > 0) {
                            out.write(literalCount);
                            out.writeInts(data, xy - literalCount, literalCount);
                            literalCount = 0;
                        }
                        if (xy + skipCount == xymax) {
                            xy += skipCount - 1;
                        } else if (skipCount >= repeatCount) {
                            while (skipCount > 254) {
                                out.write(0);
                                out.write(255);
                                xy += 254;
                                skipCount -= 254;
                            }
                            out.write(0);
                            out.write(skipCount + 1);
                            xy += skipCount - 1;
                        } else {
                            out.write(-repeatCount);
                            out.writeInt(v);
                            xy += repeatCount - 1;
                        }
                    }
                    ++xy;
                }
                if (literalCount > 0) {
                    out.write(literalCount);
                    out.writeInts(data, xy - literalCount, literalCount);
                    literalCount = 0;
                }
                out.write(-1);
            }
            y += scanlineStride;
        }
        pos = out.getStreamPosition();
        out.seek(headerPos);
        out.writeInt((int)(pos - headerPos));
        out.seek(pos);
    }

    /*
     * Unable to fully structure code
     */
    public void decodeDelta16(ImageInputStream in, short[] data, short[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        in.setByteOrder(ByteOrder.BIG_ENDIAN);
        chunkSize = in.readUnsignedInt();
        if (chunkSize <= 8L) {
            return;
        }
        if (in.length() != chunkSize) {
            throw new IOException("Illegal chunk size:" + chunkSize + " expected:" + in.length());
        }
        header = in.readUnsignedShort();
        if (header == 0) {
            startingLine = 0;
            numberOfLines = height;
        } else if (header == 8) {
            startingLine = in.readUnsignedShort();
            reserved1 = in.readUnsignedShort();
            if (reserved1 != 0) {
                throw new IOException("Illegal value in reserved1 0x" + Integer.toHexString(reserved1));
            }
            numberOfLines = in.readUnsignedShort();
            reserved2 = in.readUnsignedShort();
            if (reserved2 != 0) {
                throw new IOException("Illegal value in reserved2 0x" + Integer.toHexString(reserved2));
            }
        } else {
            throw new IOException("Unknown header 0x" + Integer.toHexString(header));
        }
        if (startingLine > height || numberOfLines == 0) {
            return;
        }
        if (startingLine + numberOfLines - 1 > height) {
            throw new IOException("Illegal startingLine or numberOfLines, startingLine=" + startingLine + ", numberOfLines=" + numberOfLines);
        }
        l = 0;
        while (l < numberOfLines) {
            i = offset + (startingLine + l) * scanlineStride;
            skipCode = in.readUnsignedByte() - 1;
            if (skipCode == -1) break;
            if (skipCode > 0) {
                if (data == prev) {
                    i += skipCode;
                } else {
                    j = 0;
                    while (j < skipCode) {
                        data[i] = prev[i];
                        ++i;
                        ++j;
                    }
                }
            }
            block4: while (true) {
                if ((opCode = in.readByte()) == 0) {
                    skipCode = in.readUnsignedByte() - 1;
                    if (skipCode <= 0) continue;
                    if (prev != data) {
                        System.arraycopy(prev, i, data, i, skipCode);
                    }
                    i += skipCode;
                    continue;
                }
                if (opCode > 0) {
                    try {
                        in.readFully(data, i, (int)opCode);
                    }
                    catch (EOFException e) {
                        System.exit(5);
                        return;
                    }
                    i += opCode;
                    continue;
                }
                if (opCode == -1) break;
                if (opCode >= -1) continue;
                d = in.readShort();
                end = i - opCode;
                while (true) {
                    if (i < end) ** break;
                    continue block4;
                    data[i++] = d;
                }
                break;
            }
            if (!AnimationCodec.$assertionsDisabled && i > offset + (startingLine + l + 1) * scanlineStride) {
                throw new AssertionError();
            }
            ++l;
        }
        if (!AnimationCodec.$assertionsDisabled && in.getStreamPosition() != in.length()) {
            throw new AssertionError();
        }
    }
}

