/*
 * Decompiled with CFR 0.152.
 */
package atu.testrecorder.media.quicktime;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.imageio.stream.ImageOutputStreamImpl;

public class DataAtomOutputStream
extends FilterOutputStream {
    ImageOutputStreamImpl impl;
    protected static final long MAC_TIMESTAMP_EPOCH = new GregorianCalendar(1904, 0, 1).getTimeInMillis();
    protected long written;
    private byte[] byteBuf = new byte[3];

    public DataAtomOutputStream(OutputStream out) {
        super(out);
    }

    public void writeType(String s) throws IOException {
        if (s.length() != 4) {
            throw new IllegalArgumentException("type string must have 4 characters");
        }
        try {
            this.out.write(s.getBytes("ASCII"), 0, 4);
            this.incCount(4);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
    }

    public final void writeByte(int v) throws IOException {
        this.out.write(v);
        this.incCount(1);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.incCount(len);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.out.write(b);
        this.incCount(1);
    }

    public void writeInt(int v) throws IOException {
        this.out.write(v >>> 24 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
        this.incCount(4);
    }

    public void writeUInt(long v) throws IOException {
        this.out.write((int)(v >>> 24 & 0xFFL));
        this.out.write((int)(v >>> 16 & 0xFFL));
        this.out.write((int)(v >>> 8 & 0xFFL));
        this.out.write((int)(v >>> 0 & 0xFFL));
        this.incCount(4);
    }

    public void writeShort(int v) throws IOException {
        this.out.write(v >> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
        this.incCount(2);
    }

    public void writeBCD2(int v) throws IOException {
        this.out.write(v % 100 / 10 << 4 | v % 10);
        this.incCount(1);
    }

    public void writeBCD4(int v) throws IOException {
        this.out.write(v % 10000 / 1000 << 4 | v % 1000 / 100);
        this.out.write(v % 100 / 10 << 4 | v % 10);
        this.incCount(2);
    }

    public void writeMacTimestamp(Date date) throws IOException {
        long millis = date.getTime();
        long qtMillis = millis - MAC_TIMESTAMP_EPOCH;
        long qtSeconds = qtMillis / 1000L;
        this.writeUInt(qtSeconds);
    }

    public void writeFixed16D16(double f) throws IOException {
        double v = f >= 0.0 ? f : -f;
        int wholePart = (int)Math.floor(v);
        int fractionPart = (int)((v - (double)wholePart) * 65536.0);
        int t = (wholePart << 16) + fractionPart;
        if (f < 0.0) {
            --t;
        }
        this.writeInt(t);
    }

    public void writeFixed2D30(double f) throws IOException {
        double v = f >= 0.0 ? f : -f;
        int wholePart = (int)v;
        int fractionPart = (int)((v - (double)wholePart) * 1.073741824E9);
        int t = (wholePart << 30) + fractionPart;
        if (f < 0.0) {
            --t;
        }
        this.writeInt(t);
    }

    public void writeFixed8D8(float f) throws IOException {
        float v = f >= 0.0f ? f : -f;
        int wholePart = (int)v;
        int fractionPart = (int)((v - (float)wholePart) * 256.0f);
        int t = (wholePart << 8) + fractionPart;
        if (f < 0.0f) {
            --t;
        }
        this.writeUShort(t);
    }

    public void writePString(String s) throws IOException {
        if (s.length() > 65535) {
            throw new IllegalArgumentException("String too long for PString");
        }
        if (s.length() != 0 && s.length() < 256) {
            this.out.write(s.length());
        } else {
            this.out.write(0);
            this.writeShort(s.length());
        }
        int i = 0;
        while (i < s.length()) {
            this.out.write(s.charAt(i));
            ++i;
        }
        this.incCount(1 + s.length());
    }

    public void writePString(String s, int length) throws IOException {
        if (s.length() > length) {
            throw new IllegalArgumentException("String too long for PString of length " + length);
        }
        if (s.length() != 0 && s.length() < 256) {
            this.out.write(s.length());
        } else {
            this.out.write(0);
            this.writeShort(s.length());
        }
        int i = 0;
        while (i < s.length()) {
            this.out.write(s.charAt(i));
            ++i;
        }
        i = 1 + s.length();
        while (i < length) {
            this.out.write(0);
            ++i;
        }
        this.incCount(length);
    }

    public void writeLong(long v) throws IOException {
        this.out.write((int)(v >>> 56) & 0xFF);
        this.out.write((int)(v >>> 48) & 0xFF);
        this.out.write((int)(v >>> 40) & 0xFF);
        this.out.write((int)(v >>> 32) & 0xFF);
        this.out.write((int)(v >>> 24) & 0xFF);
        this.out.write((int)(v >>> 16) & 0xFF);
        this.out.write((int)(v >>> 8) & 0xFF);
        this.out.write((int)(v >>> 0) & 0xFF);
        this.incCount(8);
    }

    public void writeUShort(int v) throws IOException {
        this.out.write(v >> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
        this.incCount(2);
    }

    protected void incCount(int value) {
        long temp = this.written + (long)value;
        if (temp < 0L) {
            temp = Long.MAX_VALUE;
        }
        this.written = temp;
    }

    public void writeShorts(short[] s, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > s.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length!");
        }
        byte[] b = new byte[len * 2];
        int boff = 0;
        int i = 0;
        while (i < len) {
            short v = s[off + i];
            b[boff++] = (byte)(v >>> 8);
            b[boff++] = (byte)(v >>> 0);
            ++i;
        }
        this.write(b, 0, len * 2);
    }

    public void writeInts(int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        byte[] b = new byte[len * 4];
        int boff = 0;
        int j = 0;
        while (j < len) {
            int v = i[off + j];
            b[boff++] = (byte)(v >>> 24);
            b[boff++] = (byte)(v >>> 16);
            b[boff++] = (byte)(v >>> 8);
            b[boff++] = (byte)(v >>> 0);
            ++j;
        }
        this.write(b, 0, len * 4);
    }

    public void writeInt24(int v) throws IOException {
        this.byteBuf[0] = (byte)(v >>> 16);
        this.byteBuf[1] = (byte)(v >>> 8);
        this.byteBuf[2] = (byte)(v >>> 0);
        this.write(this.byteBuf, 0, 3);
    }

    public void writeInts24(int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        byte[] b = new byte[len * 3];
        int boff = 0;
        int j = 0;
        while (j < len) {
            int v = i[off + j];
            b[boff++] = (byte)(v >>> 16);
            b[boff++] = (byte)(v >>> 8);
            b[boff++] = (byte)(v >>> 0);
            ++j;
        }
        this.write(b, 0, len * 3);
    }

    public final long size() {
        return this.written;
    }
}

