/*
 * Decompiled with CFR 0.152.
 */
package atu.testrecorder.media.quicktime;

import atu.testrecorder.media.Buffer;
import atu.testrecorder.media.Codec;
import atu.testrecorder.media.MovieWriter;
import atu.testrecorder.media.VideoFormat;
import atu.testrecorder.media.io.ImageOutputStreamAdapter;
import atu.testrecorder.media.jpeg.JPEGCodec;
import atu.testrecorder.media.png.PNGCodec;
import atu.testrecorder.media.quicktime.AbstractQuickTimeStream;
import atu.testrecorder.media.quicktime.AnimationCodec;
import atu.testrecorder.media.quicktime.DataAtomOutputStream;
import atu.testrecorder.media.quicktime.RawCodec;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.sound.sampled.AudioFormat;

public class QuickTimeWriter
extends AbstractQuickTimeStream
implements MovieWriter {
    public static final VideoFormat VIDEO_RAW = new VideoFormat("raw ", "NONE");
    public static final VideoFormat VIDEO_ANIMATION = new VideoFormat("rle ", "Animation");
    public static final VideoFormat VIDEO_JPEG = new VideoFormat("jpeg", "Photo - JPEG");
    public static final VideoFormat VIDEO_PNG = new VideoFormat("png ", "PNG");

    public QuickTimeWriter(File file) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        this.out = new FileImageOutputStream(file);
        this.streamOffset = 0L;
    }

    public QuickTimeWriter(ImageOutputStream out) throws IOException {
        this.out = out;
        this.streamOffset = out.getStreamPosition();
    }

    public void setMovieTimeScale(long timeScale) {
        if (timeScale < 1L || timeScale > 0x200000000L) {
            throw new IllegalArgumentException("timeScale must be between 1 and 2^32:" + timeScale);
        }
        this.movieTimeScale = timeScale;
    }

    public long getMovieTimeScale() {
        return this.movieTimeScale;
    }

    public long getMediaTimeScale(int track) {
        return ((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).mediaTimeScale;
    }

    public long getMediaDuration(int track) {
        return ((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).mediaDuration;
    }

    public long getUneditedTrackDuration(int track) {
        AbstractQuickTimeStream.Track t = (AbstractQuickTimeStream.Track)this.tracks.get(track);
        return t.mediaDuration * t.mediaTimeScale / this.movieTimeScale;
    }

    public long getTrackDuration(int track) {
        return ((AbstractQuickTimeStream.Track)this.tracks.get(track)).getTrackDuration(this.movieTimeScale);
    }

    public long getMovieDuration() {
        long duration = 0L;
        for (AbstractQuickTimeStream.Track t : this.tracks) {
            duration = Math.max(duration, t.getTrackDuration(this.movieTimeScale));
        }
        return duration;
    }

    public void setVideoColorTable(int track, IndexColorModel icm) {
        AbstractQuickTimeStream.VideoTrack t = (AbstractQuickTimeStream.VideoTrack)this.tracks.get(track);
        t.videoColorTable = icm;
    }

    public IndexColorModel getVideoColorTable(int track) {
        AbstractQuickTimeStream.VideoTrack t = (AbstractQuickTimeStream.VideoTrack)this.tracks.get(track);
        return t.videoColorTable;
    }

    public void setEditList(int track, AbstractQuickTimeStream.Edit[] editList) {
        if (editList != null && editList.length > 0 && editList[editList.length - 1].mediaTime == -1) {
            throw new IllegalArgumentException("Edit list must not end with empty edit.");
        }
        ((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).editList = editList;
    }

    public int addVideoTrack(VideoFormat format, long timeScale, int width, int height) throws IOException {
        return this.addVideoTrack(format.getEncoding(), format.getCompressorName(), timeScale, width, height, 24, 30);
    }

    public int addVideoTrack(VideoFormat format, long timeScale, int width, int height, int depth, int syncInterval) throws IOException {
        return this.addVideoTrack(format.getEncoding(), format.getCompressorName(), timeScale, width, height, depth, syncInterval);
    }

    public int addVideoTrack(String compressionType, String compressorName, long timeScale, int width, int height, int depth, int syncInterval) throws IOException {
        this.ensureStarted();
        if (compressionType == null || compressionType.length() != 4) {
            throw new IllegalArgumentException("compressionType must be 4 characters long:" + compressionType);
        }
        if (compressorName == null || compressorName.length() < 1 || compressorName.length() > 32) {
            throw new IllegalArgumentException("compressorName must be between 1 and 32 characters long:" + compressionType);
        }
        if (timeScale < 1L || timeScale > 0x200000000L) {
            throw new IllegalArgumentException("timeScale must be between 1 and 2^32:" + timeScale);
        }
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Width and height must be greater than 0, width:" + width + " height:" + height);
        }
        AbstractQuickTimeStream.VideoTrack t = new AbstractQuickTimeStream.VideoTrack(this);
        t.mediaCompressionType = compressionType;
        t.mediaCompressorName = compressorName;
        t.mediaTimeScale = timeScale;
        t.videoWidth = width;
        t.videoHeight = height;
        t.videoDepth = depth;
        t.syncInterval = syncInterval;
        t.videoFormat = new VideoFormat(compressionType, compressorName, byte[].class, width, height, depth);
        this.createCodec(t);
        this.tracks.add(t);
        return this.tracks.size() - 1;
    }

    private void createCodec(AbstractQuickTimeStream.VideoTrack vt) {
        String enc = vt.videoFormat.getEncoding();
        if (enc.equals("jpeg")) {
            vt.codec = new JPEGCodec();
        } else if (enc.equals("png ")) {
            vt.codec = new PNGCodec();
        } else if (enc.equals("raw ")) {
            vt.codec = new RawCodec();
        } else if (enc.equals("rle ")) {
            vt.codec = new AnimationCodec();
        }
        vt.codec.setInputFormat(new VideoFormat("image", BufferedImage.class, vt.videoWidth, vt.videoHeight, vt.videoDepth));
        vt.codec.setOutputFormat(new VideoFormat(vt.videoFormat.getEncoding(), vt.videoFormat.getCompressorName(), byte[].class, vt.videoWidth, vt.videoHeight, vt.videoDepth));
        vt.codec.setQuality(vt.videoQuality);
    }

    public Codec getCodec(int track) {
        return ((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).codec;
    }

    public void setCodec(int track, Codec codec) {
        ((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).codec = codec;
    }

    public int addAudioTrack(AudioFormat format) throws IOException {
        String qtAudioFormat;
        boolean isCompressed;
        int frameSize;
        int frameDuration;
        int numberOfChannels;
        int sampleSizeInBits;
        long timeScale;
        double sampleRate;
        block16: {
            block17: {
                boolean bigEndian;
                block15: {
                    this.ensureStarted();
                    sampleRate = format.getSampleRate();
                    timeScale = (int)Math.floor(sampleRate);
                    sampleSizeInBits = format.getSampleSizeInBits();
                    numberOfChannels = format.getChannels();
                    bigEndian = format.isBigEndian();
                    frameDuration = (int)(format.getSampleRate() / format.getFrameRate());
                    frameSize = format.getFrameSize();
                    boolean bl = isCompressed = format.getProperty("vbr") != null && (Boolean)format.getProperty("vbr") != false;
                    if (!format.getEncoding().equals(AudioFormat.Encoding.ALAW)) break block15;
                    qtAudioFormat = "alaw";
                    if (sampleSizeInBits != 8) {
                        throw new IllegalArgumentException("Sample size of 8 for ALAW required:" + sampleSizeInBits);
                    }
                    break block16;
                }
                if (!format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) break block17;
                switch (sampleSizeInBits) {
                    case 16: {
                        qtAudioFormat = bigEndian ? "twos" : "sowt";
                        break block16;
                    }
                    case 24: {
                        qtAudioFormat = "in24";
                        break block16;
                    }
                    case 32: {
                        qtAudioFormat = "in32";
                        break block16;
                    }
                    default: {
                        throw new IllegalArgumentException("Sample size of 16, 24 or 32 for PCM_SIGNED required:" + sampleSizeInBits);
                    }
                }
            }
            if (format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
                if (sampleSizeInBits != 8) {
                    throw new IllegalArgumentException("Sample size of 8 PCM_UNSIGNED required:" + sampleSizeInBits);
                }
                qtAudioFormat = "raw ";
            } else if (format.getEncoding().equals(AudioFormat.Encoding.ULAW)) {
                if (sampleSizeInBits != 8) {
                    throw new IllegalArgumentException("Sample size of 8 for ULAW required:" + sampleSizeInBits);
                }
                qtAudioFormat = "ulaw";
            } else if (format.getEncoding().toString().equals("MP3")) {
                qtAudioFormat = ".mp3";
            } else {
                qtAudioFormat = format.getEncoding().toString();
                if (qtAudioFormat.length() != 4) {
                    throw new IllegalArgumentException("Unsupported encoding:" + format.getEncoding());
                }
            }
        }
        return this.addAudioTrack(qtAudioFormat, timeScale, sampleRate, numberOfChannels, sampleSizeInBits, isCompressed, frameDuration, frameSize);
    }

    public int addAudioTrack(String compressionType, long timeScale, double sampleRate, int numberOfChannels, int sampleSizeInBits, boolean isCompressed, int frameDuration, int frameSize) throws IOException {
        this.ensureStarted();
        if (compressionType == null || compressionType.length() != 4) {
            throw new IllegalArgumentException("audioFormat must be 4 characters long:" + compressionType);
        }
        if (timeScale < 1L || timeScale > 0x200000000L) {
            throw new IllegalArgumentException("timeScale must be between 1 and 2^32:" + timeScale);
        }
        if (timeScale != (long)((int)Math.floor(sampleRate))) {
            throw new IllegalArgumentException("timeScale: " + timeScale + " must match integer portion of sampleRate: " + sampleRate);
        }
        if (numberOfChannels != 1 && numberOfChannels != 2) {
            throw new IllegalArgumentException("numberOfChannels must be 1 or 2: " + numberOfChannels);
        }
        if (sampleSizeInBits != 8 && sampleSizeInBits != 16) {
            throw new IllegalArgumentException("sampleSize must be 8 or 16: " + numberOfChannels);
        }
        AbstractQuickTimeStream.AudioTrack t = new AbstractQuickTimeStream.AudioTrack(this);
        t.mediaCompressionType = compressionType;
        t.mediaTimeScale = timeScale;
        t.soundSampleRate = sampleRate;
        t.soundCompressionId = isCompressed ? -2 : -1;
        t.soundNumberOfChannels = numberOfChannels;
        t.soundSampleSize = sampleSizeInBits;
        t.soundSamplesPerPacket = frameDuration;
        if (isCompressed) {
            t.soundBytesPerPacket = frameSize;
            t.soundBytesPerFrame = frameSize * numberOfChannels;
        } else {
            t.soundBytesPerPacket = frameSize / numberOfChannels;
            t.soundBytesPerFrame = frameSize;
        }
        t.soundBytesPerSample = sampleSizeInBits / 8;
        this.tracks.add(t);
        return this.tracks.size() - 1;
    }

    public void setCompressionQuality(int track, float newValue) {
        AbstractQuickTimeStream.VideoTrack vt = (AbstractQuickTimeStream.VideoTrack)this.tracks.get(track);
        vt.videoQuality = newValue;
        if (vt.codec != null) {
            vt.codec.setQuality(newValue);
        }
    }

    public float getCompressionQuality(int track) {
        return ((AbstractQuickTimeStream.VideoTrack)this.tracks.get((int)track)).videoQuality;
    }

    public void setSyncInterval(int track, int i) {
        ((AbstractQuickTimeStream.VideoTrack)this.tracks.get((int)track)).syncInterval = i;
    }

    public int getSyncInterval(int track) {
        return ((AbstractQuickTimeStream.VideoTrack)this.tracks.get((int)track)).syncInterval;
    }

    protected void ensureStarted() throws IOException {
        this.ensureOpen();
        if (this.state == AbstractQuickTimeStream.States.FINISHED) {
            throw new IOException("Can not write into finished movie.");
        }
        if (this.state != AbstractQuickTimeStream.States.STARTED) {
            this.creationTime = new Date();
            this.writeProlog();
            this.mdatAtom = new AbstractQuickTimeStream.WideDataAtom(this, "mdat");
            this.state = AbstractQuickTimeStream.States.STARTED;
        }
    }

    @Override
    public void writeFrame(int track, BufferedImage image, long duration) throws IOException {
        if (duration <= 0L) {
            throw new IllegalArgumentException("Duration must be greater 0.");
        }
        AbstractQuickTimeStream.VideoTrack vt = (AbstractQuickTimeStream.VideoTrack)this.tracks.get(track);
        if (vt.mediaType != AbstractQuickTimeStream.MediaType.VIDEO) {
            throw new IllegalArgumentException("Track " + track + " is not a video track");
        }
        if (vt.codec == null) {
            throw new UnsupportedOperationException("No codec for this video format.");
        }
        this.ensureStarted();
        if (vt.videoWidth == -1) {
            vt.videoWidth = image.getWidth();
            vt.videoHeight = image.getHeight();
        } else if (vt.videoWidth != image.getWidth() || vt.videoHeight != image.getHeight()) {
            throw new IllegalArgumentException("Dimensions of frame[" + ((AbstractQuickTimeStream.Track)this.tracks.get(track)).getSampleCount() + "] (width=" + image.getWidth() + ", height=" + image.getHeight() + ") differs from video dimension (width=" + vt.videoWidth + ", height=" + vt.videoHeight + ") in track " + track + ".");
        }
        if (vt.outputBuffer == null) {
            vt.outputBuffer = new Buffer();
        }
        boolean isSync = vt.syncInterval == 0 ? false : vt.sampleCount % (long)vt.syncInterval == 0L;
        Buffer inputBuffer = new Buffer();
        inputBuffer.flags = isSync ? 16 : 0;
        inputBuffer.data = image;
        vt.codec.process(inputBuffer, vt.outputBuffer);
        if (vt.outputBuffer.flags == 2) {
            return;
        }
        isSync = (vt.outputBuffer.flags & 0x10) != 0;
        long offset = this.getRelativeStreamPosition();
        DataAtomOutputStream mdatOut = this.mdatAtom.getOutputStream();
        ((OutputStream)mdatOut).write((byte[])vt.outputBuffer.data, vt.outputBuffer.offset, vt.outputBuffer.length);
        long length = this.getRelativeStreamPosition() - offset;
        vt.addSample(new AbstractQuickTimeStream.Sample(duration, offset, length), 1, isSync);
    }

    public void writeSample(int track, File file, long duration) throws IOException {
        this.writeSample(track, file, duration, true);
    }

    public void writeSample(int track, File file, long duration, boolean isSync) throws IOException {
        this.ensureStarted();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.writeSample(track, in, duration, isSync);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void writeSample(int track, InputStream in, long duration) throws IOException {
        this.writeSample(track, in, duration, true);
    }

    public void writeSample(int track, InputStream in, long duration, boolean isSync) throws IOException {
        int len;
        this.ensureStarted();
        if (duration <= 0L) {
            throw new IllegalArgumentException("duration must be greater 0");
        }
        AbstractQuickTimeStream.Track t = (AbstractQuickTimeStream.Track)this.tracks.get(track);
        this.ensureOpen();
        this.ensureStarted();
        long offset = this.getRelativeStreamPosition();
        DataAtomOutputStream mdatOut = this.mdatAtom.getOutputStream();
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) != -1) {
            ((OutputStream)mdatOut).write(buf, 0, len);
        }
        long length = this.getRelativeStreamPosition() - offset;
        t.addSample(new AbstractQuickTimeStream.Sample(duration, offset, length), 1, isSync);
    }

    public void writeSample(int track, byte[] data, long duration) throws IOException {
        this.writeSample(track, data, 0, data.length, duration, true);
    }

    public void writeSample(int track, byte[] data, long duration, boolean isSync) throws IOException {
        this.ensureStarted();
        this.writeSample(track, data, 0, data.length, duration, isSync);
    }

    public void writeSample(int track, byte[] data, int off, int len, long duration) throws IOException {
        this.ensureStarted();
        this.writeSample(track, data, off, len, duration, true);
    }

    @Override
    public void writeSample(int track, byte[] data, int off, int len, long duration, boolean isSync) throws IOException {
        this.ensureStarted();
        if (duration <= 0L) {
            throw new IllegalArgumentException("duration must be greater 0");
        }
        AbstractQuickTimeStream.Track t = (AbstractQuickTimeStream.Track)this.tracks.get(track);
        this.ensureOpen();
        this.ensureStarted();
        long offset = this.getRelativeStreamPosition();
        DataAtomOutputStream mdatOut = this.mdatAtom.getOutputStream();
        ((OutputStream)mdatOut).write(data, off, len);
        t.addSample(new AbstractQuickTimeStream.Sample(duration, offset, len), 1, isSync);
    }

    public void writeSamples(int track, int sampleCount, byte[] data, long sampleDuration) throws IOException {
        this.writeSamples(track, sampleCount, data, 0, data.length, sampleDuration, true);
    }

    public void writeSamples(int track, int sampleCount, byte[] data, int off, int len, long sampleDuration) throws IOException {
        this.writeSamples(track, sampleCount, data, off, len, sampleDuration, true);
    }

    @Override
    public void writeSamples(int track, int sampleCount, byte[] data, int off, int len, long sampleDuration, boolean isSync) throws IOException {
        this.ensureStarted();
        if (sampleDuration <= 0L) {
            throw new IllegalArgumentException("sampleDuration must be greater 0, sampleDuration=" + sampleDuration);
        }
        if (sampleCount <= 0) {
            throw new IllegalArgumentException("sampleCount must be greater 0, sampleCount=" + sampleCount);
        }
        if (len % sampleCount != 0) {
            throw new IllegalArgumentException("len must be divisable by sampleCount len=" + len + " sampleCount=" + sampleCount);
        }
        AbstractQuickTimeStream.Track t = (AbstractQuickTimeStream.Track)this.tracks.get(track);
        this.ensureOpen();
        this.ensureStarted();
        long offset = this.getRelativeStreamPosition();
        DataAtomOutputStream mdatOut = this.mdatAtom.getOutputStream();
        ((OutputStream)mdatOut).write(data, off, len);
        int sampleLength = len / sampleCount;
        AbstractQuickTimeStream.Sample first = new AbstractQuickTimeStream.Sample(sampleDuration, offset, sampleLength);
        AbstractQuickTimeStream.Sample last = new AbstractQuickTimeStream.Sample(sampleDuration, offset + (long)(sampleLength * (sampleCount - 1)), sampleLength);
        t.addChunk(new AbstractQuickTimeStream.Chunk(first, last, sampleCount, 1), isSync);
    }

    @Override
    public boolean isVFRSupported() {
        return true;
    }

    @Override
    public boolean isDataLimitReached() {
        try {
            long maxMediaDuration = 0L;
            for (AbstractQuickTimeStream.Track t : this.tracks) {
                maxMediaDuration = Math.max(t.mediaDuration, maxMediaDuration);
            }
            return this.getRelativeStreamPosition() > 0x2000000000000000L || maxMediaDuration > 0x2000000000000000L;
        }
        catch (IOException ex) {
            return true;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.state == AbstractQuickTimeStream.States.STARTED) {
                this.finish();
            }
        }
        finally {
            if (this.state != AbstractQuickTimeStream.States.CLOSED) {
                this.out.close();
                this.state = AbstractQuickTimeStream.States.CLOSED;
            }
        }
    }

    public void finish() throws IOException {
        this.ensureOpen();
        if (this.state != AbstractQuickTimeStream.States.FINISHED) {
            int i = 0;
            int n = this.tracks.size();
            while (i < n) {
                ++i;
            }
            this.mdatAtom.finish();
            this.writeEpilog();
            this.state = AbstractQuickTimeStream.States.FINISHED;
        }
    }

    protected void ensureOpen() throws IOException {
        if (this.state == AbstractQuickTimeStream.States.CLOSED) {
            throw new IOException("Stream closed");
        }
    }

    private void writeProlog() throws IOException {
        AbstractQuickTimeStream.DataAtom ftypAtom = new AbstractQuickTimeStream.DataAtom(this, "ftyp");
        DataAtomOutputStream d = ftypAtom.getOutputStream();
        d.writeType("qt  ");
        d.writeBCD4(2005);
        d.writeBCD2(3);
        d.writeBCD2(0);
        d.writeType("qt  ");
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        ftypAtom.finish();
    }

    private void writeEpilog() throws IOException {
        Date modificationTime = new Date();
        long duration = this.getMovieDuration();
        this.moovAtom = new AbstractQuickTimeStream.CompositeAtom(this, "moov");
        AbstractQuickTimeStream.DataAtom leaf = new AbstractQuickTimeStream.DataAtom(this, "mvhd");
        this.moovAtom.add(leaf);
        DataAtomOutputStream d = leaf.getOutputStream();
        d.writeByte(0);
        d.writeByte(0);
        d.writeByte(0);
        d.writeByte(0);
        d.writeMacTimestamp(this.creationTime);
        d.writeMacTimestamp(modificationTime);
        d.writeUInt(this.movieTimeScale);
        d.writeUInt(duration);
        d.writeFixed16D16(1.0);
        d.writeShort(256);
        d.write(new byte[10]);
        d.writeFixed16D16(1.0);
        d.writeFixed16D16(0.0);
        d.writeFixed2D30(0.0);
        d.writeFixed16D16(0.0);
        d.writeFixed16D16(1.0);
        d.writeFixed2D30(0.0);
        d.writeFixed16D16(0.0);
        d.writeFixed16D16(0.0);
        d.writeFixed2D30(1.0);
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        d.writeUInt(this.tracks.size() + 1);
        int i = 0;
        int n = this.tracks.size();
        while (i < n) {
            AbstractQuickTimeStream.Track t = (AbstractQuickTimeStream.Track)this.tracks.get(i);
            t.writeTrackAtoms(i, this.moovAtom, modificationTime);
            ++i;
        }
        this.moovAtom.finish();
    }

    public void toWebOptimizedMovie(File outputFile, boolean compressHeader) throws IOException {
        this.finish();
        long originalMdatOffset = this.mdatAtom.getOffset();
        AbstractQuickTimeStream.CompositeAtom originalMoovAtom = this.moovAtom;
        this.mdatOffset = 0L;
        ImageOutputStream originalOut = this.out;
        try {
            Object buf;
            this.out = null;
            if (compressHeader) {
                buf = new ByteArrayOutputStream();
                int maxIteration = 5;
                long compressionHeadersSize = 48L;
                long headerSize = 0L;
                long freeSize = 0L;
                while (true) {
                    this.mdatOffset = compressionHeadersSize + headerSize + freeSize;
                    ((ByteArrayOutputStream)buf).reset();
                    DeflaterOutputStream deflater = new DeflaterOutputStream((OutputStream)buf);
                    this.out = new MemoryCacheImageOutputStream(deflater);
                    this.writeEpilog();
                    this.out.close();
                    deflater.close();
                    if ((long)((ByteArrayOutputStream)buf).size() <= headerSize + freeSize || --maxIteration <= 0) break;
                    if (headerSize != 0L) {
                        freeSize = Math.max(freeSize, (long)((ByteArrayOutputStream)buf).size() - headerSize - freeSize);
                    }
                    headerSize = ((ByteArrayOutputStream)buf).size();
                }
                freeSize = headerSize + freeSize - (long)((ByteArrayOutputStream)buf).size();
                headerSize = ((ByteArrayOutputStream)buf).size();
                if (maxIteration < 0 || ((ByteArrayOutputStream)buf).size() == 0) {
                    compressHeader = false;
                    System.err.println("WARNING QuickTimeWriter failed to compress header.");
                } else {
                    this.out = new FileImageOutputStream(outputFile);
                    this.writeProlog();
                    DataAtomOutputStream daos = new DataAtomOutputStream(new ImageOutputStreamAdapter(this.out));
                    daos.writeUInt(headerSize + 40L);
                    daos.writeType("moov");
                    daos.writeUInt(headerSize + 32L);
                    daos.writeType("cmov");
                    daos.writeUInt(12L);
                    daos.writeType("dcom");
                    daos.writeType("zlib");
                    daos.writeUInt(headerSize + 12L);
                    daos.writeType("cmvd");
                    daos.writeUInt(originalMoovAtom.size());
                    daos.write(((ByteArrayOutputStream)buf).toByteArray());
                    daos.writeUInt(freeSize + 8L);
                    daos.writeType("free");
                    int i = 0;
                    while ((long)i < freeSize) {
                        daos.write(0);
                        ++i;
                    }
                }
            }
            if (!compressHeader) {
                this.out = new FileImageOutputStream(outputFile);
                this.mdatOffset = this.moovAtom.size();
                this.writeProlog();
                this.writeEpilog();
            }
            buf = new byte[4096];
            originalOut.seek(originalMdatOffset);
            long count = 0L;
            long n = this.mdatAtom.size();
            while (count < n) {
                int read = originalOut.read((byte[])buf, 0, (int)Math.min((long)((Object)buf).length, n - count));
                this.out.write((byte[])buf, 0, read);
                count += (long)read;
            }
            this.out.close();
        }
        finally {
            this.mdatOffset = 0L;
            this.moovAtom = originalMoovAtom;
            this.out = originalOut;
        }
    }
}

