/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.domain.asset.request;

import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AssetDepositRequest {
    private String coin;
    private String chainType;
    private String subMemberId;

    AssetDepositRequest(String coin, String chainType, String subMemberId) {
        this.coin = coin;
        this.chainType = chainType;
        this.subMemberId = subMemberId;
    }

    public static AssetDepositRequestBuilder builder() {
        return new AssetDepositRequestBuilder();
    }

    public String getCoin() {
        return this.coin;
    }

    public String getChainType() {
        return this.chainType;
    }

    public String getSubMemberId() {
        return this.subMemberId;
    }

    public String toString() {
        return "AssetDepositRequest(coin=" + this.getCoin() + ", chainType=" + this.getChainType() + ", subMemberId=" + this.getSubMemberId() + ")";
    }

    public static class AssetDepositRequestBuilder {
        private String coin;
        private String chainType;
        private String subMemberId;

        AssetDepositRequestBuilder() {
        }

        public AssetDepositRequestBuilder coin(String coin) {
            this.coin = coin;
            return this;
        }

        public AssetDepositRequestBuilder chainType(String chainType) {
            this.chainType = chainType;
            return this;
        }

        public AssetDepositRequestBuilder subMemberId(String subMemberId) {
            this.subMemberId = subMemberId;
            return this;
        }

        public AssetDepositRequest build() {
            return new AssetDepositRequest(this.coin, this.chainType, this.subMemberId);
        }

        public String toString() {
            return "AssetDepositRequest.AssetDepositRequestBuilder(coin=" + this.coin + ", chainType=" + this.chainType + ", subMemberId=" + this.subMemberId + ")";
        }
    }
}

