/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.domain.broker;

import com.bybit.api.client.domain.broker.BusinessType;

public class BrokerDataRequest {
    private final BusinessType bizType;
    private final String subMemberId;
    private final String coin;
    private final Long startTime;
    private final Long endTime;
    private final Integer limit;
    private final String cursor;

    BrokerDataRequest(BusinessType bizType, String subMemberId, String coin, Long startTime, Long endTime, Integer limit, String cursor) {
        this.bizType = bizType;
        this.subMemberId = subMemberId;
        this.coin = coin;
        this.startTime = startTime;
        this.endTime = endTime;
        this.limit = limit;
        this.cursor = cursor;
    }

    public static BrokerDataRequestBuilder builder() {
        return new BrokerDataRequestBuilder();
    }

    public BusinessType getBizType() {
        return this.bizType;
    }

    public String getSubMemberId() {
        return this.subMemberId;
    }

    public String getCoin() {
        return this.coin;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getCursor() {
        return this.cursor;
    }

    public String toString() {
        return "BrokerDataRequest(bizType=" + this.getBizType() + ", subMemberId=" + this.getSubMemberId() + ", coin=" + this.getCoin() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", limit=" + this.getLimit() + ", cursor=" + this.getCursor() + ")";
    }

    public static class BrokerDataRequestBuilder {
        private BusinessType bizType;
        private String subMemberId;
        private String coin;
        private Long startTime;
        private Long endTime;
        private Integer limit;
        private String cursor;

        BrokerDataRequestBuilder() {
        }

        public BrokerDataRequestBuilder bizType(BusinessType bizType) {
            this.bizType = bizType;
            return this;
        }

        public BrokerDataRequestBuilder subMemberId(String subMemberId) {
            this.subMemberId = subMemberId;
            return this;
        }

        public BrokerDataRequestBuilder coin(String coin) {
            this.coin = coin;
            return this;
        }

        public BrokerDataRequestBuilder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public BrokerDataRequestBuilder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public BrokerDataRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public BrokerDataRequestBuilder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public BrokerDataRequest build() {
            return new BrokerDataRequest(this.bizType, this.subMemberId, this.coin, this.startTime, this.endTime, this.limit, this.cursor);
        }

        public String toString() {
            return "BrokerDataRequest.BrokerDataRequestBuilder(bizType=" + this.bizType + ", subMemberId=" + this.subMemberId + ", coin=" + this.coin + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", limit=" + this.limit + ", cursor=" + this.cursor + ")";
        }
    }
}

