/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.domain.trade.request;

import com.bybit.api.client.domain.CategoryType;
import com.bybit.api.client.domain.trade.request.CancelOrderRequest;
import com.bybit.api.client.service.CategoryTypeSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;

public class CancelBatchOrderRequest {
    @JsonSerialize(using=CategoryTypeSerializer.class)
    private CategoryType category;
    private List<CancelOrderRequest> request;

    CancelBatchOrderRequest(CategoryType category, List<CancelOrderRequest> request) {
        this.category = category;
        this.request = request;
    }

    public static CancelBatchOrderRequestBuilder builder() {
        return new CancelBatchOrderRequestBuilder();
    }

    public CategoryType getCategory() {
        return this.category;
    }

    public List<CancelOrderRequest> getRequest() {
        return this.request;
    }

    public void setCategory(CategoryType category) {
        this.category = category;
    }

    public void setRequest(List<CancelOrderRequest> request) {
        this.request = request;
    }

    public String toString() {
        return "CancelBatchOrderRequest(category=" + this.getCategory() + ", request=" + this.getRequest() + ")";
    }

    public static class CancelBatchOrderRequestBuilder {
        private CategoryType category;
        private List<CancelOrderRequest> request;

        CancelBatchOrderRequestBuilder() {
        }

        public CancelBatchOrderRequestBuilder category(CategoryType category) {
            this.category = category;
            return this;
        }

        public CancelBatchOrderRequestBuilder request(List<CancelOrderRequest> request) {
            this.request = request;
            return this;
        }

        public CancelBatchOrderRequest build() {
            return new CancelBatchOrderRequest(this.category, this.request);
        }

        public String toString() {
            return "CancelBatchOrderRequest.CancelBatchOrderRequestBuilder(category=" + this.category + ", request=" + this.request + ")";
        }
    }
}

