/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jetty12.server;

import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.jetty12.server.DefaultJettyCoreRequestTagsProvider;
import io.micrometer.jetty12.server.JettyCoreRequestTagsProvider;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.EventsHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.Graceful;

public class TimedHandler
extends EventsHandler
implements Graceful {
    private static final String SAMPLE_TIMER_ATTRIBUTE = "__micrometer_timer_sample";
    private static final String SAMPLE_REQUEST_LONG_TASK_TIMER_ATTRIBUTE = "__micrometer_request_ltt_sample";
    private static final String SAMPLE_HANDLER_LONG_TASK_TIMER_ATTRIBUTE = "__micrometer_handler_ltt_sample";
    protected static final String RESPONSE_STATUS_ATTRIBUTE = "__micrometer_jetty_core_response_status";
    private final MeterRegistry registry;
    private final Iterable<Tag> tags;
    private final JettyCoreRequestTagsProvider tagsProvider;
    private final Graceful.Shutdown shutdown = new Graceful.Shutdown((Object)this){

        public boolean isShutdownDone() {
            return TimedHandler.this.timerRequest.activeTasks() == 0;
        }
    };
    private final LongTaskTimer timerRequest;
    private final LongTaskTimer timerHandle;

    public TimedHandler(MeterRegistry registry, Iterable<Tag> tags) {
        this(registry, tags, new DefaultJettyCoreRequestTagsProvider());
    }

    public TimedHandler(MeterRegistry registry, Iterable<Tag> tags, JettyCoreRequestTagsProvider tagsProvider) {
        this.registry = registry;
        this.tags = tags;
        this.tagsProvider = tagsProvider;
        this.timerRequest = LongTaskTimer.builder((String)"jetty.server.requests.open").description("Jetty requests that are currently in progress").tags(tags).register(registry);
        this.timerHandle = LongTaskTimer.builder((String)"jetty.server.handling.open").description("Jetty requests inside handle() calls").tags(tags).register(registry);
    }

    protected void onBeforeHandling(Request request) {
        this.beginRequestTiming(request);
        this.beginHandlerTiming(request);
        super.onBeforeHandling(request);
    }

    protected void onAfterHandling(Request request, boolean handled, Throwable failure) {
        this.stopHandlerTiming(request);
        super.onAfterHandling(request, handled, failure);
    }

    protected void onResponseBegin(Request request, int status, HttpFields headers) {
        request.setAttribute(RESPONSE_STATUS_ATTRIBUTE, (Object)status);
        super.onResponseBegin(request, status, headers);
    }

    protected void onComplete(Request request, Throwable failure) {
        this.stopRequestTiming(request);
        super.onComplete(request, failure);
    }

    private void beginRequestTiming(Request request) {
        LongTaskTimer.Sample requestSample = this.timerRequest.start();
        request.setAttribute(SAMPLE_REQUEST_LONG_TASK_TIMER_ATTRIBUTE, (Object)requestSample);
    }

    private void stopRequestTiming(Request request) {
        Timer.Sample sample = this.getTimerSample(request);
        LongTaskTimer.Sample requestSample = (LongTaskTimer.Sample)request.getAttribute(SAMPLE_REQUEST_LONG_TASK_TIMER_ATTRIBUTE);
        if (requestSample == null) {
            return;
        }
        sample.stop(Timer.builder((String)"jetty.server.requests").description("HTTP requests to the Jetty server").tags(this.tagsProvider.getTags(request)).tags(this.tags).register(this.registry));
        request.removeAttribute(SAMPLE_REQUEST_LONG_TASK_TIMER_ATTRIBUTE);
        requestSample.stop();
    }

    private void beginHandlerTiming(Request request) {
        LongTaskTimer.Sample handlerSample = this.timerHandle.start();
        request.setAttribute(SAMPLE_HANDLER_LONG_TASK_TIMER_ATTRIBUTE, (Object)handlerSample);
    }

    private void stopHandlerTiming(Request request) {
        Timer.Sample sample = this.getTimerSample(request);
        LongTaskTimer.Sample handlerSample = (LongTaskTimer.Sample)request.getAttribute(SAMPLE_HANDLER_LONG_TASK_TIMER_ATTRIBUTE);
        if (handlerSample == null) {
            return;
        }
        sample.stop(Timer.builder((String)"jetty.server.handling").description("Requests being processed by Jetty handlers").tags(this.tagsProvider.getTags(request)).tags(this.tags).register(this.registry));
        request.removeAttribute(SAMPLE_HANDLER_LONG_TASK_TIMER_ATTRIBUTE);
        handlerSample.stop();
    }

    private Timer.Sample getTimerSample(Request request) {
        return (Timer.Sample)request.getAttribute(SAMPLE_TIMER_ATTRIBUTE);
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Timer.Sample sample = Timer.start((MeterRegistry)this.registry);
        request.setAttribute(SAMPLE_TIMER_ATTRIBUTE, (Object)sample);
        return super.handle(request, response, callback);
    }

    protected void doStart() throws Exception {
        this.shutdown.cancel();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.shutdown.cancel();
        super.doStop();
    }

    public CompletableFuture<Void> shutdown() {
        return this.shutdown.shutdown();
    }

    public boolean isShutdown() {
        return this.shutdown.isShutdown();
    }

    protected Graceful.Shutdown getShutdown() {
        return this.shutdown;
    }
}

