/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.aot;

import io.micronaut.maven.aot.AbstractMicronautAotCliMojo;
import io.micronaut.maven.services.CompilerService;
import io.micronaut.maven.services.DependencyResolutionService;
import io.micronaut.maven.services.ExecutorService;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;

@Mojo(name="aot-sample-config", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class AotSampleMojo
extends AbstractMicronautAotCliMojo {
    public static final String SAMPLE_AOT_PROPERTIES_FILE_NAME = "aot.properties";
    public static final String NAME = "aot-sample-config";

    @Inject
    public AotSampleMojo(CompilerService compilerService, ExecutorService executorService, MavenProject mavenProject, DependencyResolutionService dependencyResolutionService, MavenSession mavenSession, ToolchainManager toolchainManager) {
        super(compilerService, executorService, mavenProject, dependencyResolutionService, mavenSession, toolchainManager);
    }

    @Override
    protected List<String> getExtraArgs() {
        return Arrays.asList("--config", this.outputFile(SAMPLE_AOT_PROPERTIES_FILE_NAME).getAbsolutePath());
    }

    @Override
    protected void onSuccess(File outputDir) {
        File sampleFile = new File(outputDir, SAMPLE_AOT_PROPERTIES_FILE_NAME);
        if (sampleFile.exists()) {
            this.getLog().info((CharSequence)("Sample configuration file written to " + String.valueOf(sampleFile)));
        }
    }

    @Override
    String getName() {
        return NAME;
    }
}

