/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.services;

import io.micronaut.maven.services.ExecutorService;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

@Singleton
public class CompilerService {
    public static final String MAVEN_JAR_PLUGIN = "org.apache.maven.plugins:maven-jar-plugin";
    private static final String COMPILE_GOAL = "compile";
    private final Log log;
    private final MavenSession mavenSession;
    private final ExecutorService executorService;
    private final ProjectDependenciesResolver resolver;

    @Inject
    public CompilerService(MavenSession mavenSession, ExecutorService executorService, ProjectDependenciesResolver resolver) {
        this.mavenSession = mavenSession;
        this.resolver = resolver;
        this.log = new SystemStreamLog();
        this.executorService = executorService;
    }

    public Optional<Long> compileProject() {
        Long lastCompilation;
        block3: {
            lastCompilation = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)"Compiling the project");
            }
            try {
                this.executorService.invokeGoals(COMPILE_GOAL);
                lastCompilation = System.currentTimeMillis();
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block3;
                this.log.error((CharSequence)"Error while compiling the project: ", (Throwable)e);
            }
        }
        return Optional.ofNullable(lastCompilation);
    }

    public List<Dependency> resolveDependencies(MavenProject runnableProject, String ... scopes) {
        try {
            DependencyFilter filter = DependencyFilterUtils.classpathFilter((String[])scopes);
            RepositorySystemSession session = this.mavenSession.getRepositorySession();
            DefaultDependencyResolutionRequest dependencyResolutionRequest = new DefaultDependencyResolutionRequest(runnableProject, session);
            dependencyResolutionRequest.setResolutionFilter(filter);
            DependencyResolutionResult result = this.resolver.resolve((DependencyResolutionRequest)dependencyResolutionRequest);
            return result.getDependencies();
        }
        catch (DependencyResolutionException e) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((CharSequence)"Error while trying to resolve dependencies for the current project", (Throwable)e);
            }
            return Collections.emptyList();
        }
    }

    public String buildClasspath(List<Dependency> dependencies) {
        Comparator<Dependency> byGroupId = Comparator.comparing(d -> d.getArtifact().getGroupId());
        Comparator<Dependency> byArtifactId = Comparator.comparing(d -> d.getArtifact().getArtifactId());
        return dependencies.stream().sorted(byGroupId.thenComparing(byArtifactId)).map(dependency -> dependency.getArtifact().getFile().getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
    }

    public InvocationResult packageProject() throws MavenInvocationException {
        return this.executorService.invokeGoal(MAVEN_JAR_PLUGIN, "jar");
    }
}

