/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.service;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.service.DefaultServiceDefinition;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.ServiceScanner;
import io.micronaut.core.optim.StaticOptimizations;
import io.micronaut.core.reflect.ClassUtils;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SoftServiceLoader<S>
implements Iterable<ServiceDefinition<S>> {
    public static final String META_INF_SERVICES = "META-INF/services";
    static final Map<String, StaticServiceLoader<?>> STATIC_SERVICES = StaticOptimizations.get(Optimizations.class).map(Optimizations::getServiceLoaders).orElse(Collections.emptyMap());
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private static final MethodType VOID_TYPE = MethodType.methodType(Void.TYPE);
    private final Class<S> serviceType;
    private final ClassLoader classLoader;
    private Collection<ServiceDefinition<S>> servicesForIterator;
    private final Predicate<String> condition;
    private boolean allowFork = true;

    private SoftServiceLoader(Class<S> serviceType, @Nullable ClassLoader classLoader) {
        this(serviceType, classLoader, name -> true);
    }

    private SoftServiceLoader(Class<S> serviceType, @Nullable ClassLoader classLoader, Predicate<String> condition) {
        this.serviceType = serviceType;
        this.classLoader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        this.condition = condition == null ? name -> true : condition;
    }

    public static <S> SoftServiceLoader<S> load(Class<S> service) {
        return SoftServiceLoader.load(service, SoftServiceLoader.class.getClassLoader());
    }

    public static <S> SoftServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return new SoftServiceLoader<S>(service, loader);
    }

    public static <S> SoftServiceLoader<S> load(Class<S> service, ClassLoader loader, Predicate<String> condition) {
        return new SoftServiceLoader<S>(service, loader, condition);
    }

    public SoftServiceLoader<S> disableFork() {
        this.allowFork = false;
        return this;
    }

    public Optional<ServiceDefinition<S>> first() {
        Iterator<ServiceDefinition<S>> i = this.iterator();
        if (i.hasNext()) {
            return Optional.of(i.next());
        }
        return Optional.empty();
    }

    public Optional<S> firstAvailable() {
        for (ServiceDefinition<S> def : this) {
            if (!def.isPresent()) continue;
            return Optional.of(def.load());
        }
        return Optional.empty();
    }

    public Optional<ServiceDefinition<S>> firstOr(String alternative, ClassLoader classLoader) {
        Iterator<ServiceDefinition<S>> i = this.iterator();
        if (i.hasNext()) {
            return Optional.of(i.next());
        }
        Class alternativeClass = ClassUtils.forName(alternative, classLoader).orElse(null);
        if (alternativeClass != null) {
            return Optional.of(this.createService(alternative, alternativeClass));
        }
        return Optional.empty();
    }

    public void collectAll(@NonNull Collection<S> values, @Nullable Predicate<S> predicate) {
        String name = this.serviceType.getName();
        StaticServiceLoader<?> serviceLoader = STATIC_SERVICES.get(name);
        if (serviceLoader != null) {
            this.collectStaticServices(values, predicate, serviceLoader);
        } else {
            this.collectDynamicServices(values, predicate, name);
        }
    }

    private void collectDynamicServices(Collection<S> values, Predicate<S> predicate, String name) {
        ServiceCollector<Object> collector = SoftServiceLoader.newCollector(name, this.condition, this.classLoader, className -> {
            try {
                Class<?> loadedClass = Class.forName(className, false, this.classLoader);
                Object result = LOOKUP.findConstructor(loadedClass, VOID_TYPE).invoke();
                if (predicate != null && !predicate.test(result)) {
                    return null;
                }
                return result;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoClassDefFoundError | NoSuchMethodException loadedClass) {
            }
            catch (Throwable e) {
                throw new ServiceLoadingException(e);
            }
            return null;
        });
        collector.collect(values, this.allowFork);
    }

    private void collectStaticServices(Collection<S> values, Predicate<S> predicate, StaticServiceLoader<S> loader) {
        values.addAll(loader.load(predicate));
    }

    public void collectAll(@NonNull Collection<S> values) {
        this.collectAll(values, null);
    }

    public List<S> collectAll() {
        return this.collectAll((Predicate)null);
    }

    public List<S> collectAll(Predicate<S> predicate) {
        ArrayList values = new ArrayList();
        this.collectAll(values, predicate);
        return values;
    }

    @Override
    @NonNull
    public Iterator<ServiceDefinition<S>> iterator() {
        if (this.servicesForIterator == null) {
            if (STATIC_SERVICES.containsKey(this.serviceType.getName())) {
                StaticServiceLoader<?> staticServiceLoader = STATIC_SERVICES.get(this.serviceType.getName());
                this.servicesForIterator = staticServiceLoader.findAll(s -> this.condition == null || this.condition.test(s.getClass().getName())).collect(Collectors.toList());
            } else {
                ArrayList<ServiceDefinition<S>> serviceDefinitions = new ArrayList<ServiceDefinition<S>>();
                SoftServiceLoader.newCollector(this.serviceType.getName(), this.condition, this.classLoader, name -> {
                    try {
                        Class<?> loadedClass = Class.forName(name, false, this.classLoader);
                        return this.createService((String)name, (Class<S>)loadedClass);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        return this.createService((String)name, null);
                    }
                }).collect(serviceDefinitions, false);
                this.servicesForIterator = serviceDefinitions;
            }
        }
        return this.servicesForIterator.iterator();
    }

    private ServiceDefinition<S> createService(String name, Class<S> loadedClass) {
        return new DefaultServiceDefinition<S>(name, loadedClass);
    }

    public static <S> ServiceCollector<S> newCollector(String serviceName, Predicate<String> lineCondition, ClassLoader classLoader, Function<String, S> transformer) {
        return new ServiceScanner<S>(classLoader, serviceName, lineCondition, transformer).new ServiceScanner.DefaultServiceCollector();
    }

    public static interface StaticServiceLoader<S> {
        public Stream<StaticDefinition<S>> findAll(Predicate<String> var1);

        default public List<S> load(Predicate<S> predicate) {
            return this.load(n -> true, predicate);
        }

        default public List<S> load(Predicate<String> condition, Predicate<S> predicate) {
            return this.findAll(condition).map(ServiceDefinition::load).filter(s -> predicate == null || predicate.test(s)).toList();
        }
    }

    public static interface ServiceCollector<S> {
        public void collect(Collection<S> var1);

        default public void collect(Collection<S> values, boolean allowFork) {
            this.collect(values);
        }

        default public void collect(Consumer<? super S> consumer) {
            ArrayList values = new ArrayList();
            this.collect(values);
            values.forEach(e -> {
                if (e != null) {
                    consumer.accept((Object)e);
                }
            });
        }
    }

    static final class ServiceLoadingException
    extends RuntimeException {
        public ServiceLoadingException(String message, Throwable cause) {
            super(message, cause);
        }

        public ServiceLoadingException(Throwable cause) {
            super(cause);
        }
    }

    public static final class Optimizations {
        private final Map<String, StaticServiceLoader<?>> serviceLoaders;

        public Optimizations(Map<String, StaticServiceLoader<?>> serviceLoaders) {
            this.serviceLoaders = serviceLoaders;
        }

        public Map<String, StaticServiceLoader<?>> getServiceLoaders() {
            return this.serviceLoaders;
        }
    }

    public static final class StaticDefinition<S>
    implements ServiceDefinition<S> {
        private final String name;
        private final Supplier<S> value;

        private StaticDefinition(String name, Supplier<S> value) {
            this.name = name;
            this.value = value;
        }

        public static <S> StaticDefinition<S> of(String name, Class<S> value) {
            return new StaticDefinition<Object>(name, () -> StaticDefinition.doCreate(value));
        }

        public static <S> StaticDefinition<S> of(String name, Supplier<S> value) {
            return new StaticDefinition<S>(name, value);
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public S load() {
            return this.value.get();
        }

        private static <S> S doCreate(Class<S> clazz) {
            try {
                return (S)LOOKUP.findConstructor(clazz, VOID_TYPE).invoke();
            }
            catch (Throwable e) {
                throw new ServiceLoadingException(e);
            }
        }
    }
}

