/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Configuration;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Provided;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.context.annotation.Type;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.annotation.AnnotationMetadataException;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public final class AnnotationMetadataSupport {
    private static final Map<String, Map<String, Object>> ANNOTATION_DEFAULTS = new ConcurrentHashMap<String, Map<String, Object>>(20);
    private static final Map<Class<? extends Annotation>, Optional<Constructor<InvocationHandler>>> ANNOTATION_PROXY_CACHE = new ConcurrentHashMap<Class<? extends Annotation>, Optional<Constructor<InvocationHandler>>>(20);
    private static final Map<String, Class<? extends Annotation>> ANNOTATION_TYPES = new ConcurrentHashMap<String, Class<? extends Annotation>>(20);

    public static Map<String, Object> getDefaultValues(String annotation) {
        return ANNOTATION_DEFAULTS.getOrDefault(annotation, Collections.emptyMap());
    }

    static Optional<Class<? extends Annotation>> getAnnotationType(String name) {
        return AnnotationMetadataSupport.getAnnotationType(name, AnnotationMetadataSupport.class.getClassLoader());
    }

    static Optional<Class<? extends Annotation>> getAnnotationType(String name, ClassLoader classLoader) {
        Class<? extends Annotation> type = ANNOTATION_TYPES.get(name);
        if (type != null) {
            return Optional.of(type);
        }
        Optional aClass = ClassUtils.forName((String)name, (ClassLoader)classLoader);
        return aClass.flatMap(aClass1 -> {
            if (Annotation.class.isAssignableFrom((Class<?>)aClass1)) {
                ANNOTATION_TYPES.put(name, (Class<? extends Annotation>)aClass1);
                return Optional.of(aClass1);
            }
            return Optional.empty();
        });
    }

    static Optional<Class<? extends Annotation>> getRegisteredAnnotationType(String name) {
        Class<? extends Annotation> type = ANNOTATION_TYPES.get(name);
        if (type != null) {
            return Optional.of(type);
        }
        return Optional.empty();
    }

    static Map<String, Object> getDefaultValues(Class<? extends Annotation> annotation) {
        return AnnotationMetadataSupport.getDefaultValues(annotation.getName());
    }

    static boolean hasDefaultValues(String annotation) {
        return ANNOTATION_DEFAULTS.containsKey(annotation);
    }

    static void registerDefaultValues(String annotation, Map<String, Object> defaultValues) {
        if (StringUtils.isNotEmpty((CharSequence)annotation)) {
            ANNOTATION_DEFAULTS.put(annotation, defaultValues);
        }
    }

    static void registerDefaultValues(AnnotationClassValue<?> annotation, Map<String, Object> defaultValues) {
        if (defaultValues != null) {
            AnnotationMetadataSupport.registerDefaultValues(annotation.getName(), defaultValues);
        }
        AnnotationMetadataSupport.registerAnnotationType(annotation);
    }

    static void registerAnnotationType(AnnotationClassValue<?> annotationClassValue) {
        String name = annotationClassValue.getName();
        if (!ANNOTATION_TYPES.containsKey(name)) {
            annotationClassValue.getType().ifPresent(aClass -> {
                if (Annotation.class.isAssignableFrom((Class<?>)aClass)) {
                    ANNOTATION_TYPES.put(name, (Class<? extends Annotation>)aClass);
                }
            });
        }
    }

    static Optional<Constructor<InvocationHandler>> getProxyClass(Class<? extends Annotation> annotation) {
        return ANNOTATION_PROXY_CACHE.computeIfAbsent(annotation, aClass -> {
            Class<?> proxyClass = Proxy.getProxyClass(annotation.getClassLoader(), annotation, AnnotationValueProvider.class);
            return ReflectionUtils.findConstructor(proxyClass, (Class[])new Class[]{InvocationHandler.class});
        });
    }

    static <T extends Annotation> T buildAnnotation(Class<T> annotationClass, @Nullable AnnotationValue<T> annotationValue) {
        Optional<Constructor<InvocationHandler>> proxyClass = AnnotationMetadataSupport.getProxyClass(annotationClass);
        if (proxyClass.isPresent()) {
            HashMap<String, Object> values = new HashMap<String, Object>(AnnotationMetadataSupport.getDefaultValues(annotationClass));
            if (annotationValue != null) {
                Map annotationValues = annotationValue.getValues();
                annotationValues.forEach((key, o) -> values.put(key.toString(), o));
            }
            int hashCode = AnnotationUtil.calculateHashCode(values);
            Optional instantiated = InstantiationUtils.tryInstantiate(proxyClass.get(), (Object[])new Object[]{new AnnotationProxyHandler<T>(hashCode, annotationClass, annotationValue)});
            if (instantiated.isPresent()) {
                return (T)((Annotation)instantiated.get());
            }
        }
        throw new AnnotationMetadataException("Failed to build annotation for type: " + annotationClass.getName());
    }

    static {
        Arrays.asList(Nullable.class, NonNull.class, PreDestroy.class, PostConstruct.class, Named.class, Singleton.class, Inject.class, Qualifier.class, Scope.class, Prototype.class, Executable.class, Bean.class, Primary.class, Value.class, Property.class, Provided.class, Requires.class, Secondary.class, Type.class, Context.class, EachBean.class, EachProperty.class, Configuration.class, ConfigurationProperties.class, ConfigurationBuilder.class, Introspected.class, Parameter.class, Replaces.class, Requirements.class, Factory.class).forEach(ann -> ANNOTATION_TYPES.put(ann.getName(), (Class<? extends Annotation>)ann));
    }

    private static class AnnotationProxyHandler<A extends Annotation>
    implements InvocationHandler,
    AnnotationValueProvider<A> {
        private final int hashCode;
        private final Class<A> annotationClass;
        private final AnnotationValue<A> annotationValue;

        AnnotationProxyHandler(int hashCode, Class<A> annotationClass, @Nullable AnnotationValue<A> annotationValue) {
            this.hashCode = hashCode;
            this.annotationClass = annotationClass;
            this.annotationValue = annotationValue;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.annotationClass.isInstance(obj)) {
                return false;
            }
            Annotation other = (Annotation)this.annotationClass.cast(obj);
            AnnotationValue<?> otherValues = this.getAnnotationValues(other);
            if (this.annotationValue == null && otherValues == null) {
                return true;
            }
            if (this.annotationValue == null || otherValues == null) {
                return false;
            }
            return this.annotationValue.equals(otherValues);
        }

        private AnnotationValue<?> getAnnotationValues(Annotation other) {
            if (other instanceof AnnotationProxyHandler) {
                return ((AnnotationProxyHandler)((Object)other)).annotationValue;
            }
            return null;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String name = method.getName();
            if ((args == null || args.length == 0) && "hashCode".equals(name)) {
                return this.hashCode;
            }
            if (args != null && args.length == 1 && "equals".equals(name)) {
                return this.equals(args[0]);
            }
            if ("annotationType".equals(name)) {
                return this.annotationClass;
            }
            if (method.getReturnType() == AnnotationValue.class) {
                return this.annotationValue;
            }
            if (this.annotationValue != null && this.annotationValue.contains(name)) {
                return this.annotationValue.getRequiredValue(name, method.getReturnType());
            }
            return method.getDefaultValue();
        }

        @NonNull
        public AnnotationValue<A> annotationValue() {
            if (this.annotationValue != null) {
                return this.annotationValue;
            }
            return new AnnotationValue(this.annotationClass.getName());
        }
    }
}

