/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanContextConditional;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanContextConfigurable;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultApplicationContext;
import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import java.util.Collections;
import java.util.Set;

@Internal
public abstract class AbstractInitializableBeanDefinitionReference<T>
extends AbstractBeanContextConditional
implements BeanDefinitionReference<T> {
    private final String beanTypeName;
    private final String beanDefinitionTypeName;
    private final AnnotationMetadata annotationMetadata;
    private final boolean isPrimary;
    private final boolean isContextScope;
    private final boolean isConditional;
    private final boolean isContainerType;
    private final boolean isSingleton;
    private final boolean isConfigurationProperties;
    private final boolean hasExposedTypes;
    private final boolean requiresMethodProcessing;
    private final boolean isProxiedBean;
    private final boolean isProxyTarget;
    private Boolean present;
    private Set<Class<?>> exposedTypes;

    public AbstractInitializableBeanDefinitionReference(String beanTypeName, String beanDefinitionTypeName, AnnotationMetadata annotationMetadata, boolean isPrimary, boolean isContextScope, boolean isConditional, boolean isContainerType, boolean isSingleton, boolean isConfigurationProperties, boolean hasExposedTypes, boolean requiresMethodProcessing) {
        this(beanTypeName, beanDefinitionTypeName, annotationMetadata, isPrimary, isContextScope, isConditional, isContainerType, isSingleton, isConfigurationProperties, hasExposedTypes, requiresMethodProcessing, false, false);
    }

    protected AbstractInitializableBeanDefinitionReference(String beanTypeName, String beanDefinitionTypeName, AnnotationMetadata annotationMetadata, boolean isPrimary, boolean isContextScope, boolean isConditional, boolean isContainerType, boolean isSingleton, boolean isConfigurationProperties, boolean hasExposedTypes, boolean requiresMethodProcessing, boolean isProxiedBean, boolean isProxyTarget) {
        this.beanTypeName = beanTypeName;
        this.beanDefinitionTypeName = beanDefinitionTypeName;
        this.annotationMetadata = annotationMetadata;
        this.isPrimary = isPrimary;
        this.isContextScope = isContextScope;
        this.isConditional = isConditional;
        this.isContainerType = isContainerType;
        this.isSingleton = isSingleton;
        this.isConfigurationProperties = isConfigurationProperties;
        this.hasExposedTypes = hasExposedTypes;
        this.requiresMethodProcessing = requiresMethodProcessing;
        this.isProxiedBean = isProxiedBean;
        this.isProxyTarget = isProxyTarget;
    }

    @Override
    public boolean isProxyTarget() {
        return this.isProxyTarget;
    }

    @Override
    public boolean isProxiedBean() {
        return this.isProxiedBean;
    }

    @Override
    public String getName() {
        return this.beanTypeName;
    }

    @Override
    public String getBeanDefinitionName() {
        return this.beanDefinitionTypeName;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    public boolean isSingleton() {
        return this.isSingleton;
    }

    @Override
    public boolean isConfigurationProperties() {
        return this.isConfigurationProperties;
    }

    @Override
    public boolean isContainerType() {
        return this.isContainerType;
    }

    @Override
    public boolean isContextScope() {
        return this.isContextScope;
    }

    @Override
    public boolean requiresMethodProcessing() {
        return this.requiresMethodProcessing;
    }

    @Override
    @NonNull
    public final Set<Class<?>> getExposedTypes() {
        if (!this.hasExposedTypes) {
            return Collections.EMPTY_SET;
        }
        if (this.exposedTypes == null) {
            this.exposedTypes = BeanDefinitionReference.super.getExposedTypes();
        }
        return this.exposedTypes;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public BeanDefinition load(BeanContext context) {
        definition = this.load();
        if (!(context instanceof DefaultApplicationContext)) ** GOTO lbl-1000
        applicationContext = (DefaultApplicationContext)context;
        if (definition instanceof EnvironmentConfigurable) {
            environmentConfigurable = (EnvironmentConfigurable)definition;
            environmentConfigurable.configure(applicationContext.getEnvironment());
        } else if (context instanceof ApplicationContext) {
            applicationContext = (ApplicationContext)context;
            if (definition instanceof EnvironmentConfigurable) {
                environmentConfigurable = (EnvironmentConfigurable)definition;
                environmentConfigurable.configure(applicationContext.getEnvironment());
            }
        }
        if (definition instanceof BeanContextConfigurable) {
            ctxConfigurable = (BeanContextConfigurable)definition;
            ctxConfigurable.configure(context);
        }
        return definition;
    }

    @Override
    public boolean isPresent() {
        if (this.present == null) {
            try {
                this.getBeanDefinitionType();
                this.getBeanType();
                this.present = true;
            }
            catch (Throwable e) {
                if (e instanceof TypeNotPresentException || e instanceof ClassNotFoundException || e instanceof NoClassDefFoundError) {
                    if (AbstractBeanContextConditional.ConditionLog.LOG.isTraceEnabled()) {
                        AbstractBeanContextConditional.ConditionLog.LOG.trace("Bean definition for type [" + this.beanTypeName + "] not loaded since it is not on the classpath", e);
                    }
                } else {
                    throw new BeanContextException("Unexpected error loading bean definition [" + this.beanDefinitionTypeName + "]: " + e.getMessage(), e);
                }
                this.present = false;
            }
        }
        return this.present;
    }

    @Override
    public boolean isEnabled(BeanContext context) {
        return this.isPresent() && (!this.isConditional || super.isEnabled(context, null));
    }

    @Override
    public boolean isEnabled(BeanContext context, BeanResolutionContext resolutionContext) {
        return this.isPresent() && (!this.isConditional || super.isEnabled(context, resolutionContext));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractInitializableBeanDefinitionReference that = (AbstractInitializableBeanDefinitionReference)o;
        return this.beanDefinitionTypeName.equals(that.beanDefinitionTypeName);
    }

    public String toString() {
        return this.beanDefinitionTypeName;
    }

    public int hashCode() {
        return this.beanDefinitionTypeName.hashCode();
    }

    protected abstract Class<? extends BeanDefinition<?>> getBeanDefinitionType();
}

