/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.env.DefaultPropertyPlaceholderResolver;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.optim.StaticOptimizations;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.EnvironmentProperties;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.MapPropertyResolver;
import io.micronaut.core.value.PropertyResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class PropertySourcePropertyResolver
implements PropertyResolver,
AutoCloseable {
    private static final EnvironmentProperties CURRENT_ENV = StaticOptimizations.get(EnvironmentProperties.class).orElseGet(EnvironmentProperties::empty);
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private static final Object NO_VALUE = new Object();
    private static final PropertyCatalog[] CONVENTIONS = new PropertyCatalog[]{PropertyCatalog.GENERATED, PropertyCatalog.RAW};
    private static final String WILD_CARD_SUFFIX = ".*";
    protected final ConversionService conversionService;
    protected final PropertyPlaceholderResolver propertyPlaceholderResolver;
    protected final Map<String, PropertySource> propertySources = new ConcurrentHashMap<String, PropertySource>(10);
    protected final Map<String, Object>[] catalog = new Map[58];
    protected final Map<String, Object>[] rawCatalog = new Map[58];
    protected final Map<String, Object>[] nonGenerated = new Map[58];
    protected Logger log;
    private final Map<String, Boolean> containsCache = new ConcurrentHashMap<String, Boolean>(20);
    private final Map<String, Object> placeholderResolutionCache = new ConcurrentHashMap<String, Object>(20);
    private final Map<ConversionCacheKey, Object> resolvedValueCache = new ConcurrentHashMap<ConversionCacheKey, Object>(20);
    private final EnvironmentProperties environmentProperties = EnvironmentProperties.fork((EnvironmentProperties)CURRENT_ENV);

    public PropertySourcePropertyResolver(ConversionService conversionService, boolean logEnabled) {
        this.log = logEnabled ? LoggerFactory.getLogger(this.getClass()) : NOPLogger.NOP_LOGGER;
        this.conversionService = conversionService;
        this.propertyPlaceholderResolver = new DefaultPropertyPlaceholderResolver(this, conversionService);
    }

    public PropertySourcePropertyResolver(ConversionService conversionService) {
        this(conversionService, true);
    }

    public PropertySourcePropertyResolver() {
        this(ConversionService.SHARED);
    }

    public PropertySourcePropertyResolver(PropertySource ... propertySources) {
        this(ConversionService.SHARED);
        if (propertySources != null) {
            for (PropertySource propertySource : propertySources) {
                this.addPropertySource(propertySource);
            }
        }
    }

    public PropertySourcePropertyResolver addPropertySource(@Nullable PropertySource propertySource) {
        if (propertySource != null) {
            this.processPropertySource(propertySource, propertySource.getConvention());
        }
        return this;
    }

    public PropertySourcePropertyResolver addPropertySource(String name, @Nullable Map<String, ? super Object> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            return this.addPropertySource(PropertySource.of(name, values));
        }
        return this;
    }

    public boolean containsProperty(@Nullable String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        Boolean result = this.containsCache.get(name);
        if (result == null) {
            for (PropertyCatalog convention : CONVENTIONS) {
                Map<String, Object> entries = this.resolveEntriesForKey(name, false, convention);
                if (entries == null || !entries.containsKey(name)) continue;
                result = true;
                break;
            }
            if (result == null) {
                result = false;
            }
            this.containsCache.put(name, result);
        }
        return result;
    }

    public boolean containsProperties(@Nullable String name) {
        if (!StringUtils.isEmpty((CharSequence)name)) {
            for (PropertyCatalog propertyCatalog : CONVENTIONS) {
                Map<String, Object> entries = this.resolveEntriesForKey(name, false, propertyCatalog);
                if (entries == null) continue;
                if (entries.containsKey(name)) {
                    return true;
                }
                String finalName = name + ".";
                for (String key : entries.keySet()) {
                    if (!key.startsWith(finalName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @NonNull
    public Collection<String> getPropertyEntries(@NonNull String name) {
        Map<String, Object> entries;
        if (!StringUtils.isEmpty((CharSequence)name) && (entries = this.resolveEntriesForKey(name, false, PropertyCatalog.NORMALIZED)) != null) {
            String prefix = name + ".";
            HashSet<String> result = new HashSet<String>();
            Set<String> strings = entries.keySet();
            for (String k : strings) {
                if (!k.startsWith(prefix)) continue;
                String withoutPrefix = k.substring(prefix.length());
                int i = withoutPrefix.indexOf(46);
                String s = i > -1 ? withoutPrefix.substring(0, i) : withoutPrefix;
                result.add(s);
            }
            return result;
        }
        return Collections.emptySet();
    }

    public Set<List<String>> getPropertyPathMatches(String pathPattern) {
        Map<String, Object> entries;
        if (StringUtils.isNotEmpty((CharSequence)pathPattern) && (entries = this.resolveEntriesForKey(pathPattern, false, null)) != null) {
            boolean endsWithWildCard = pathPattern.endsWith(WILD_CARD_SUFFIX);
            Object resolvedPattern = pathPattern.replace("[*]", "\\[([\\w\\d-]+?)\\]").replace(".*.", "\\.([\\w\\d-]+?)\\.");
            resolvedPattern = endsWithWildCard ? ((String)resolvedPattern).replace(WILD_CARD_SUFFIX, "\\S*") : (String)resolvedPattern + "\\S*";
            Pattern pattern = Pattern.compile((String)resolvedPattern);
            Set<String> keys = entries.keySet();
            HashSet<List> results = new HashSet<List>(keys.size());
            for (String key : keys) {
                int i;
                Matcher matcher = pattern.matcher(key);
                if (!matcher.matches() || (i = matcher.groupCount()) <= 0) continue;
                if (i == 1) {
                    results.add(Collections.singletonList(matcher.group(1)));
                    continue;
                }
                ArrayList<String> resolved = new ArrayList<String>(i);
                for (int j = 0; j < i; ++j) {
                    resolved.add(matcher.group(j + 1));
                }
                results.add(CollectionUtils.unmodifiableList(resolved));
            }
            return Collections.unmodifiableSet(results);
        }
        return Collections.emptySet();
    }

    @NonNull
    public Map<String, Object> getProperties(String name, StringConvention keyFormat) {
        if (!StringUtils.isEmpty((CharSequence)name)) {
            Map<String, Object> entries = this.resolveEntriesForKey(name, false, keyFormat == StringConvention.RAW ? PropertyCatalog.RAW : PropertyCatalog.GENERATED);
            if (entries != null) {
                if (keyFormat == null) {
                    keyFormat = StringConvention.RAW;
                }
                return this.resolveSubMap(name, entries, ConversionContext.MAP, keyFormat, MapFormat.MapTransformation.FLAT);
            }
            entries = this.resolveEntriesForKey(name, false, PropertyCatalog.GENERATED);
            if (keyFormat == null) {
                keyFormat = StringConvention.RAW;
            }
            if (entries == null) {
                return Collections.emptyMap();
            }
            return this.resolveSubMap(name, entries, ConversionContext.MAP, keyFormat, MapFormat.MapTransformation.FLAT);
        }
        return Collections.emptyMap();
    }

    public <T> Optional<T> getProperty(@NonNull String name, @NonNull ArgumentConversionContext<T> conversionContext) {
        Object cached;
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Optional.empty();
        }
        Objects.requireNonNull(conversionContext, "Conversion context should not be null");
        Class requiredType = conversionContext.getArgument().getType();
        boolean cacheableType = ClassUtils.isJavaLangType((Class)requiredType);
        Object object = cached = cacheableType ? this.resolvedValueCache.get(new ConversionCacheKey(name, requiredType)) : null;
        if (cached != null) {
            return cached == NO_VALUE ? Optional.empty() : Optional.of(cached);
        }
        Object value = this.placeholderResolutionCache.get(name);
        Map<String, Object> entries = null;
        if (value == null && (entries = this.resolveEntriesForKey(name, false, PropertyCatalog.GENERATED)) == null) {
            entries = this.resolveEntriesForKey(name, false, PropertyCatalog.RAW);
        }
        if (entries != null || value != null) {
            Map<String, Object> subMap;
            int i;
            if (value == null) {
                value = entries.get(name);
            }
            if (value == null && (value = entries.get(this.normalizeName(name))) == null && name.indexOf(91) == -1) {
                Map<String, Object> rawEntries = this.resolveEntriesForKey(name, false, PropertyCatalog.RAW);
                Object object2 = value = rawEntries != null ? rawEntries.get(name) : null;
                if (value != null) {
                    entries = rawEntries;
                }
            }
            if (value == null && (i = name.indexOf(91)) > -1 && name.endsWith("]")) {
                String newKey = name.substring(0, i);
                value = entries.get(newKey);
                String index = name.substring(i + 1, name.length() - 1);
                if (value != null) {
                    if (StringUtils.isNotEmpty((CharSequence)index)) {
                        if (value instanceof List) {
                            try {
                                value = ((List)value).get(Integer.valueOf(index));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if (value instanceof Map) {
                            try {
                                value = ((Map)value).get(index);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)index)) {
                    String subKey = newKey + "." + index;
                    value = entries.get(subKey);
                }
            }
            if (value != null) {
                if (entries != null) {
                    value = this.resolvePlaceHoldersIfNecessary(value);
                    this.placeholderResolutionCache.put(name, value);
                }
                Optional converted = requiredType.isInstance(value) && !CollectionUtils.isIterableOrMap((Class)requiredType) ? Optional.of(value) : this.conversionService.convert(value, conversionContext);
                if (this.log.isTraceEnabled()) {
                    if (converted.isPresent()) {
                        this.log.trace("Resolved value [{}] for property: {}", converted.get(), (Object)name);
                    } else {
                        this.log.trace("Resolved value [{}] cannot be converted to type [{}] for property: {}", new Object[]{value, conversionContext.getArgument(), name});
                    }
                }
                if (cacheableType) {
                    this.resolvedValueCache.put(new ConversionCacheKey(name, requiredType), converted.orElse(NO_VALUE));
                }
                return converted;
            }
            if (cacheableType) {
                this.resolvedValueCache.put(new ConversionCacheKey(name, requiredType), NO_VALUE);
                return Optional.empty();
            }
            if (Properties.class.isAssignableFrom(requiredType)) {
                Properties properties = this.resolveSubProperties(name, entries, conversionContext);
                return Optional.of(properties);
            }
            if (Map.class.isAssignableFrom(requiredType)) {
                subMap = this.resolveSubMap(name, entries, conversionContext);
                if (!subMap.isEmpty()) {
                    return this.conversionService.convert(subMap, requiredType, conversionContext);
                }
                return Optional.of(subMap);
            }
            if (PropertyResolver.class.isAssignableFrom(requiredType)) {
                subMap = this.resolveSubMap(name, entries, conversionContext);
                return Optional.of(new MapPropertyResolver(subMap, this.conversionService));
            }
        }
        this.log.trace("No value found for property: {}", (Object)name);
        requiredType = conversionContext.getArgument().getType();
        if (Properties.class.isAssignableFrom(requiredType)) {
            return Optional.of(new Properties());
        }
        if (Map.class.isAssignableFrom(requiredType)) {
            return Optional.of(Collections.emptyMap());
        }
        return Optional.empty();
    }

    public Map<String, Object> getAllProperties(StringConvention keyConvention, MapFormat.MapTransformation transformation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isNested = transformation == MapFormat.MapTransformation.NESTED;
        Arrays.stream(this.getCatalog(keyConvention == StringConvention.RAW ? PropertyCatalog.RAW : PropertyCatalog.GENERATED)).filter(Objects::nonNull).map(Map::entrySet).flatMap(Collection::stream).forEach(entry -> {
            String k = keyConvention.format((String)entry.getKey());
            Object value = this.resolvePlaceHoldersIfNecessary(entry.getValue());
            Map finalMap = map;
            int index = k.indexOf(46);
            if (index != -1 && isNested) {
                String[] keys = DOT_PATTERN.split(k);
                for (int i = 0; i < keys.length - 1; ++i) {
                    Object next;
                    if (!finalMap.containsKey(keys[i])) {
                        finalMap.put(keys[i], new HashMap());
                    }
                    if (!((next = finalMap.get(keys[i])) instanceof Map)) continue;
                    finalMap = (Map)next;
                }
                finalMap.put(keys[keys.length - 1], value);
            } else {
                finalMap.put(k, value);
            }
        });
        return map;
    }

    protected Properties resolveSubProperties(String name, Map<String, Object> entries, ArgumentConversionContext<?> conversionContext) {
        Properties properties = new Properties();
        AnnotationMetadata annotationMetadata = conversionContext.getAnnotationMetadata();
        StringConvention keyConvention = annotationMetadata.enumValue(MapFormat.class, "keyFormat", StringConvention.class).orElse(null);
        if (keyConvention == StringConvention.RAW) {
            entries = this.resolveEntriesForKey(name, false, PropertyCatalog.RAW);
        }
        String prefix = name + ".";
        entries.entrySet().stream().filter(map -> ((String)map.getKey()).startsWith(prefix)).forEach(entry -> {
            Object value = entry.getValue();
            if (value != null) {
                String key = ((String)entry.getKey()).substring(prefix.length());
                key = keyConvention != null ? keyConvention.format(key) : key;
                properties.put(key, this.resolvePlaceHoldersIfNecessary(value.toString()));
            }
        });
        return properties;
    }

    protected Map<String, Object> resolveSubMap(String name, Map<String, Object> entries, ArgumentConversionContext<?> conversionContext) {
        AnnotationMetadata annotationMetadata = conversionContext.getAnnotationMetadata();
        StringConvention keyConvention = annotationMetadata.enumValue(MapFormat.class, "keyFormat", StringConvention.class).orElse(null);
        if (keyConvention == StringConvention.RAW) {
            entries = this.resolveEntriesForKey(name, false, PropertyCatalog.RAW);
        }
        MapFormat.MapTransformation transformation = annotationMetadata.enumValue(MapFormat.class, "transformation", MapFormat.MapTransformation.class).orElse(MapFormat.MapTransformation.NESTED);
        return this.resolveSubMap(name, entries, conversionContext, keyConvention, transformation);
    }

    @NonNull
    protected Map<String, Object> resolveSubMap(String name, Map<String, Object> entries, ArgumentConversionContext<?> conversionContext, @Nullable StringConvention keyConvention, MapFormat.MapTransformation transformation) {
        Argument valueType = conversionContext.getTypeVariable("V").orElse(Argument.OBJECT_ARGUMENT);
        boolean valueTypeIsList = List.class.isAssignableFrom(valueType.getType());
        LinkedHashMap<String, Object> subMap = new LinkedHashMap<String, Object>(entries.size());
        String prefix = name + ".";
        for (Map.Entry<String, Object> entry : entries.entrySet()) {
            String key = entry.getKey();
            if (valueTypeIsList && key.contains("[") && key.endsWith("]") || !key.startsWith(prefix)) continue;
            String subMapKey = key.substring(prefix.length());
            Object value = this.resolvePlaceHoldersIfNecessary(entry.getValue());
            if (transformation == MapFormat.MapTransformation.FLAT) {
                subMapKey = keyConvention != null ? keyConvention.format(subMapKey) : subMapKey;
                value = this.conversionService.convert(value, valueType).orElse(null);
                subMap.put(subMapKey, value);
                continue;
            }
            this.processSubmapKey(subMap, subMapKey, value, keyConvention);
        }
        return subMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPropertySource(PropertySource properties, PropertySource.PropertyConvention convention) {
        this.propertySources.put(properties.getName(), properties);
        Map<String, Object>[] mapArray = this.catalog;
        synchronized (this.catalog) {
            for (String property : properties) {
                this.log.trace("Processing property key {}", (Object)property);
                Object value = properties.get(property);
                List<String> resolvedProperties = this.resolvePropertiesForConvention(property, convention);
                boolean first = true;
                for (String resolvedProperty : resolvedProperties) {
                    int i = resolvedProperty.indexOf(91);
                    if (i > -1) {
                        String propertyName = resolvedProperty.substring(0, i);
                        Map<String, Object> entries = this.resolveEntriesForKey(propertyName, true, PropertyCatalog.GENERATED);
                        if (entries != null) {
                            entries.put(resolvedProperty, value);
                            this.expandProperty(resolvedProperty.substring(i), val -> entries.put(propertyName, val), () -> entries.get(propertyName), value);
                        }
                        if (!first) continue;
                        Map<String, Object> normalized = this.resolveEntriesForKey(resolvedProperty, true, PropertyCatalog.NORMALIZED);
                        if (normalized != null) {
                            normalized.put(propertyName, value);
                        }
                        first = false;
                        continue;
                    }
                    Map<String, Object> entries = this.resolveEntriesForKey(resolvedProperty, true, PropertyCatalog.GENERATED);
                    if (entries != null) {
                        if (value instanceof List || value instanceof Map) {
                            this.collapseProperty(resolvedProperty, entries, value);
                        }
                        entries.put(resolvedProperty, value);
                    }
                    if (!first) continue;
                    Map<String, Object> normalized = this.resolveEntriesForKey(resolvedProperty, true, PropertyCatalog.NORMALIZED);
                    if (normalized != null) {
                        normalized.put(resolvedProperty, value);
                    }
                    first = false;
                }
                Map<String, Object> rawEntries = this.resolveEntriesForKey(property, true, PropertyCatalog.RAW);
                if (rawEntries == null) continue;
                rawEntries.put(property, value);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void expandProperty(String property, Consumer<Object> containerSet, Supplier<Object> containerGet, Object actualValue) {
        if (StringUtils.isEmpty((CharSequence)property)) {
            containerSet.accept(actualValue);
            return;
        }
        int i = property.indexOf(91);
        int li = property.indexOf(93);
        if (i == 0 && li > -1) {
            String propertyIndex = property.substring(1, li);
            String propertyRest = property.substring(li + 1);
            Object container = containerGet.get();
            if (StringUtils.isDigits((String)propertyIndex)) {
                ArrayList list;
                Integer number = Integer.valueOf(propertyIndex);
                if (container instanceof List) {
                    list = (ArrayList)container;
                } else {
                    list = new ArrayList(10);
                    containerSet.accept(list);
                }
                this.fill(list, number, null);
                this.expandProperty(propertyRest, val -> list.set(number, val), () -> list.get(number), actualValue);
            } else {
                LinkedHashMap map;
                if (container instanceof Map) {
                    map = (LinkedHashMap)container;
                } else {
                    map = new LinkedHashMap(10);
                    containerSet.accept(map);
                }
                this.expandProperty(propertyRest, val -> map.put(propertyIndex, val), () -> map.get(propertyIndex), actualValue);
            }
        } else if (property.startsWith(".")) {
            LinkedHashMap map;
            String propertyRest;
            String propertyName;
            if (i > -1) {
                propertyName = property.substring(1, i);
                propertyRest = property.substring(i);
            } else {
                propertyName = property.substring(1);
                propertyRest = "";
            }
            Object v = containerGet.get();
            if (v instanceof Map) {
                map = (LinkedHashMap)v;
            } else {
                map = new LinkedHashMap(10);
                containerSet.accept(map);
            }
            this.expandProperty(propertyRest, val -> map.put(propertyName, val), () -> map.get(propertyName), actualValue);
        }
    }

    private void collapseProperty(String prefix, Map<String, Object> entries, Object value) {
        if (value instanceof List) {
            for (int i = 0; i < ((List)value).size(); ++i) {
                Object item = ((List)value).get(i);
                if (item == null) continue;
                this.collapseProperty(prefix + "[" + i + "]", entries, item);
            }
            entries.put(prefix, value);
        } else if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Object key = entry.getKey();
                if (!(key instanceof CharSequence)) continue;
                this.collapseProperty(prefix + "." + ((CharSequence)key).toString(), entries, entry.getValue());
            }
        } else {
            entries.put(prefix, value);
        }
    }

    protected Map<String, Object> resolveEntriesForKey(String name, boolean allowCreate, @Nullable PropertyCatalog propertyCatalog) {
        int index;
        if (name.length() == 0) {
            return null;
        }
        Map<String, Object>[] catalog = this.getCatalog(propertyCatalog);
        Map<String, Object> entries = null;
        char firstChar = name.charAt(0);
        if (Character.isLetter(firstChar) && (index = firstChar - 65) < catalog.length && index >= 0) {
            entries = catalog[index];
            if (allowCreate && entries == null) {
                catalog[index] = entries = new LinkedHashMap<String, Object>(5);
            }
        }
        return entries;
    }

    private Map<String, Object>[] getCatalog(@Nullable PropertyCatalog propertyCatalog) {
        propertyCatalog = propertyCatalog != null ? propertyCatalog : PropertyCatalog.GENERATED;
        return switch (propertyCatalog) {
            case PropertyCatalog.RAW -> this.rawCatalog;
            case PropertyCatalog.NORMALIZED -> this.nonGenerated;
            default -> this.catalog;
        };
    }

    protected void resetCaches() {
        this.containsCache.clear();
        this.resolvedValueCache.clear();
        this.placeholderResolutionCache.clear();
    }

    private void processSubmapKey(Map<String, Object> map, String key, Object value, @Nullable StringConvention keyConvention) {
        boolean hasKeyConvention;
        int index = key.indexOf(46);
        boolean bl = hasKeyConvention = keyConvention != null;
        if (index == -1) {
            key = hasKeyConvention ? keyConvention.format(key) : key;
            map.put(key, value);
        } else {
            Object v;
            String mapKey = key.substring(0, index);
            String string = mapKey = hasKeyConvention ? keyConvention.format(mapKey) : mapKey;
            if (!map.containsKey(mapKey)) {
                map.put(mapKey, new LinkedHashMap());
            }
            if ((v = map.get(mapKey)) instanceof Map) {
                Map nestedMap = (Map)v;
                String nestedKey = key.substring(index + 1);
                this.processSubmapKey(nestedMap, nestedKey, value, keyConvention);
            } else {
                map.put(mapKey, v);
            }
        }
    }

    private String normalizeName(String name) {
        return name.replace('-', '.');
    }

    private Object resolvePlaceHoldersIfNecessary(Object value) {
        if (value instanceof CharSequence) {
            return this.propertyPlaceholderResolver.resolveRequiredPlaceholdersObject(((Object)value).toString());
        }
        if (value instanceof List) {
            List list = value;
            ArrayList newList = new ArrayList(list);
            ListIterator<Object> i = newList.listIterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (o instanceof CharSequence) {
                    i.set(this.resolvePlaceHoldersIfNecessary(o));
                    continue;
                }
                if (!(o instanceof Map)) continue;
                Map submap = (Map)o;
                LinkedHashMap newMap = new LinkedHashMap(submap.size());
                for (Map.Entry entry : submap.entrySet()) {
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    newMap.put(k, this.resolvePlaceHoldersIfNecessary(v));
                }
                i.set(newMap);
            }
            value = newList;
        }
        return value;
    }

    private List<String> resolvePropertiesForConvention(String property, PropertySource.PropertyConvention convention) {
        if (convention == PropertySource.PropertyConvention.ENVIRONMENT_VARIABLE) {
            return this.environmentProperties.findPropertyNamesForEnvironmentVariable(property);
        }
        return Collections.singletonList(NameUtils.hyphenate((String)property, (boolean)true));
    }

    private void fill(List list, Integer toIndex, Object value) {
        if (toIndex >= list.size()) {
            for (int i = list.size(); i <= toIndex; ++i) {
                list.add(i, value);
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (this.propertyPlaceholderResolver instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.propertyPlaceholderResolver)).close();
        }
    }

    protected static enum PropertyCatalog {
        RAW,
        NORMALIZED,
        GENERATED;

    }

    private record ConversionCacheKey(@NonNull String name, Class<?> requiredType) {
    }
}

