/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanContextConfigurable;
import io.micronaut.context.BeanDefinitionAware;
import io.micronaut.context.EnvironmentAwareArgument;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.DefaultArgument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.annotation.EvaluatedAnnotationMetadata;

@Internal
final class ExpressionsAwareArgument<T>
extends DefaultArgument<T>
implements BeanContextConfigurable,
BeanDefinitionAware {
    private final EvaluatedAnnotationMetadata annotationMetadata;

    private ExpressionsAwareArgument(Argument<T> argument, EvaluatedAnnotationMetadata annotationMetadata) {
        super(argument.getType(), argument.getName(), argument.getAnnotationMetadata(), argument.getTypeVariables(), argument.getTypeParameters(), argument.isTypeVariable());
        this.annotationMetadata = annotationMetadata;
    }

    public static <T> Argument<T> wrapIfNecessary(Argument<T> argument) {
        return ExpressionsAwareArgument.wrapIfNecessary(argument, null, null);
    }

    public static <T> Argument<T> wrapIfNecessary(Argument<T> argument, @Nullable BeanContext beanContext, @Nullable BeanDefinition<?> owningBean) {
        AnnotationMetadata annotationMetadata;
        if (!(argument instanceof DefaultArgument)) {
            return null;
        }
        AnnotationMetadata argumentAnnotationMetadata = argument.getAnnotationMetadata();
        if (argumentAnnotationMetadata.hasPropertyExpressions()) {
            if (!(argument instanceof EnvironmentAwareArgument) && beanContext instanceof ApplicationContext) {
                ApplicationContext ac = (ApplicationContext)beanContext;
                EnvironmentAwareArgument environmentAwareArgument = new EnvironmentAwareArgument((DefaultArgument)argument);
                environmentAwareArgument.configure(ac.getEnvironment());
                return environmentAwareArgument;
            }
            return argument;
        }
        if (argumentAnnotationMetadata.hasEvaluatedExpressions() && (annotationMetadata = EvaluatedAnnotationMetadata.wrapIfNecessary(argumentAnnotationMetadata)) instanceof EvaluatedAnnotationMetadata) {
            EvaluatedAnnotationMetadata evaluatedAnnotationMetadata = (EvaluatedAnnotationMetadata)annotationMetadata;
            if (beanContext != null) {
                evaluatedAnnotationMetadata.configure(beanContext);
            }
            if (owningBean != null) {
                evaluatedAnnotationMetadata.setBeanDefinition(owningBean);
            }
            return new ExpressionsAwareArgument<T>(argument, evaluatedAnnotationMetadata);
        }
        return argument;
    }

    @Override
    public void setBeanDefinition(BeanDefinition<?> beanDefinition) {
        this.annotationMetadata.setBeanDefinition(beanDefinition);
    }

    @Override
    public void configure(BeanContext context) {
        this.annotationMetadata.configure(context);
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }
}

