/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.dao;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.config.NFlow;
import io.nflow.engine.internal.dao.ExecutorDao;
import io.nflow.engine.workflow.definition.WorkflowDefinitionStatistics;
import io.nflow.engine.workflow.statistics.Statistics;
import jakarta.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Component;

@Component
@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON", "UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="common jdbctemplate practice, jdbc and executorInfo are injected")
public class StatisticsDao {
    private final JdbcTemplate jdbc;
    private final ExecutorDao executorInfo;

    @Inject
    public StatisticsDao(@NFlow JdbcTemplate jdbcTemplate, ExecutorDao executorDao) {
        this.executorInfo = executorDao;
        this.jdbc = jdbcTemplate;
    }

    public Statistics getQueueStatistics() {
        return new Statistics(this.queuedStatistics(), this.executionStatistics());
    }

    private Statistics.QueueStatistics executionStatistics() {
        String sql = "select count(1) items, current_timestamp oldest, current_timestamp newest, current_timestamp dbtime from nflow_workflow where executor_id is not null and " + this.executorInfo.getExecutorGroupCondition();
        return (Statistics.QueueStatistics)this.jdbc.query(sql, (ResultSetExtractor)new StatisticsExtractor(true));
    }

    private Statistics.QueueStatistics queuedStatistics() {
        String sql = "select count(1) items, min(next_activation) oldest, max(next_activation) newest, current_timestamp dbtime from nflow_workflow where next_activation < current_timestamp and executor_id is null and " + this.executorInfo.getExecutorGroupCondition();
        return (Statistics.QueueStatistics)this.jdbc.query(sql, (ResultSetExtractor)new StatisticsExtractor(false));
    }

    public Map<String, Map<String, WorkflowDefinitionStatistics>> getWorkflowDefinitionStatistics(String type, DateTime createdAfter, DateTime createdBefore, DateTime modifiedAfter, DateTime modifiedBefore) {
        String executorGroup = this.executorInfo.getExecutorGroup();
        ArrayList<Object> argsList = new ArrayList<Object>();
        argsList.add(executorGroup);
        argsList.add(type);
        StringBuilder whereBuilder = new StringBuilder();
        if (createdAfter != null) {
            whereBuilder.append(" and created >= ?");
            argsList.add(createdAfter.toDate());
        }
        if (createdBefore != null) {
            whereBuilder.append(" and created < ?");
            argsList.add(createdBefore.toDate());
        }
        if (modifiedAfter != null) {
            whereBuilder.append(" and modified >= ?");
            argsList.add(modifiedAfter.toDate());
        }
        if (modifiedBefore != null) {
            whereBuilder.append(" and modified < ?");
            argsList.add(modifiedBefore.toDate());
        }
        String where = whereBuilder.toString();
        String query = "select state, status, count(*) all_instances, count(case when next_activation < current_timestamp then 1 else null end) queued_instances from nflow_workflow where executor_group = ? and type = ?" + where + " group by state, status";
        Object[] argsArray = argsList.toArray(new Object[argsList.size()]);
        final LinkedHashMap<String, Map<String, WorkflowDefinitionStatistics>> stats = new LinkedHashMap<String, Map<String, WorkflowDefinitionStatistics>>();
        this.jdbc.query(query, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String state = rs.getString("state");
                Map stateStats = stats.computeIfAbsent(state, k -> new LinkedHashMap());
                String status = rs.getString("status");
                WorkflowDefinitionStatistics statusStats = new WorkflowDefinitionStatistics();
                statusStats.allInstances = rs.getLong("all_instances");
                statusStats.queuedInstances = rs.getLong("queued_instances");
                stateStats.put(status, statusStats);
            }
        }, argsArray);
        return stats;
    }

    static class StatisticsExtractor
    implements ResultSetExtractor<Statistics.QueueStatistics> {
        private final boolean itemsOnly;

        public StatisticsExtractor(boolean itemsOnly) {
            this.itemsOnly = itemsOnly;
        }

        public Statistics.QueueStatistics extractData(ResultSet rs) throws SQLException {
            rs.next();
            int items = rs.getInt("items");
            if (this.itemsOnly) {
                return new Statistics.QueueStatistics(items, null, null);
            }
            Timestamp oldest = rs.getTimestamp("oldest");
            Timestamp newest = rs.getTimestamp("newest");
            Timestamp now = rs.getTimestamp("dbtime");
            return new Statistics.QueueStatistics(items, StatisticsExtractor.toMillis(oldest, now), StatisticsExtractor.toMillis(newest, now));
        }

        private static long toMillis(Timestamp ts, Timestamp now) {
            if (ts == null) {
                return 0L;
            }
            return now.getTime() - ts.getTime();
        }
    }
}

