/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.dao;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.config.NFlow;
import io.nflow.engine.model.ModelObject;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;

@Named
public class TableMetadataChecker {
    private final JdbcTemplate jdbc;

    @Inject
    public TableMetadataChecker(@NFlow JdbcTemplate jdbcTemplate) {
        this.jdbc = jdbcTemplate;
    }

    public void ensureCopyingPossible(String sourceTable, String destinationTable) {
        Map<String, ColumnMetadata> sourceMetadataMap = this.getMetadata(sourceTable);
        Map<String, ColumnMetadata> destMetadataMap = this.getMetadata(destinationTable);
        if (destMetadataMap.size() < sourceMetadataMap.size()) {
            throw new IllegalArgumentException(String.format("Source table %s has more columns than destination table %s", sourceTable, destinationTable));
        }
        Set<String> sourceKeySet = sourceMetadataMap.keySet();
        Set<String> destKeySet = destMetadataMap.keySet();
        if (!destKeySet.containsAll(sourceKeySet)) {
            LinkedHashSet<String> missingColumns = new LinkedHashSet<String>(sourceKeySet);
            missingColumns.removeAll(destKeySet);
            throw new IllegalArgumentException(String.format("Destination table %s is missing columns %s that are present in source table %s", destinationTable, missingColumns, sourceTable));
        }
        for (Map.Entry<String, ColumnMetadata> entry : sourceMetadataMap.entrySet()) {
            ColumnMetadata sourceMetadata = entry.getValue();
            ColumnMetadata destMetadata = destMetadataMap.get(entry.getKey());
            if (!sourceMetadata.typeName.equals(destMetadata.typeName)) {
                throw new IllegalArgumentException(String.format("Source column %s.%s has type %s and destination column %s.%s has mismatching type %s", sourceTable, sourceMetadata.columnName, sourceMetadata.typeName, destinationTable, destMetadata.columnName, destMetadata.typeName));
            }
            if (sourceMetadata.size <= destMetadata.size) continue;
            throw new IllegalArgumentException(String.format("Source column %s.%s has size %s and destination column %s.%s smaller size %s", sourceTable, sourceMetadata.columnName, sourceMetadata.size, destinationTable, destMetadata.columnName, destMetadata.size));
        }
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="jdbc is injected")
    private Map<String, ColumnMetadata> getMetadata(String tableName) {
        return (Map)this.jdbc.query("select * from " + tableName + " where 1 = 0", (ResultSetExtractor)new MetadataExtractor());
    }

    private static class ColumnMetadata
    extends ModelObject {
        public final String columnName;
        public final String typeName;
        public final int size;

        public ColumnMetadata(String columnName, String typeName, int size) {
            this.columnName = columnName;
            this.typeName = typeName;
            this.size = size;
        }
    }

    static class MetadataExtractor
    implements ResultSetExtractor<Map<String, ColumnMetadata>> {
        private final Map<String, String> typeAliases = Map.of("serial", "int4", "bigserial", "int8");

        MetadataExtractor() {
        }

        public Map<String, ColumnMetadata> extractData(ResultSet rs) throws SQLException {
            ResultSetMetaData metadata = rs.getMetaData();
            LinkedHashMap<String, ColumnMetadata> metadataMap = new LinkedHashMap<String, ColumnMetadata>(metadata.getColumnCount() * 2);
            for (int col = 1; col <= metadata.getColumnCount(); ++col) {
                String columnName = metadata.getColumnName(col);
                String typeName = metadata.getColumnTypeName(col);
                int size = metadata.getColumnDisplaySize(col);
                metadataMap.put(columnName, new ColumnMetadata(columnName, this.resolveTypeAlias(typeName), size));
            }
            return metadataMap;
        }

        private String resolveTypeAlias(String type) {
            return this.typeAliases.getOrDefault(type, type);
        }
    }
}

