/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.executor;

import io.nflow.engine.config.NFlow;
import io.nflow.engine.internal.executor.WorkflowDispatcher;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Singleton
public class WorkflowLifecycle
implements SmartLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowLifecycle.class);
    private final WorkflowDispatcher dispatcher;
    private final boolean autoStart;
    private final Thread dispatcherThread;

    @Inject
    public WorkflowLifecycle(WorkflowDispatcher dispatcher, @NFlow ThreadFactory nflowThreadFactory, Environment env) {
        this.dispatcher = dispatcher;
        this.autoStart = (Boolean)env.getRequiredProperty("nflow.autostart", Boolean.class);
        this.dispatcherThread = nflowThreadFactory.newThread(dispatcher);
        this.dispatcherThread.setName("nflow-dispatcher");
        if (!this.autoStart) {
            logger.info("nFlow engine autostart disabled (system property nflow.autostart=false)");
        }
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isAutoStartup() {
        return this.autoStart;
    }

    public void start() {
        this.dispatcherThread.start();
    }

    public void pause() {
        this.dispatcher.pause();
    }

    public void resume() {
        this.dispatcher.resume();
    }

    public boolean isPaused() {
        return this.dispatcher.isPaused();
    }

    public boolean isRunning() {
        return this.dispatcherThread.isAlive();
    }

    public void stop() {
        this.dispatcher.shutdown();
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }
}

