/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.storage.db;

import io.nflow.engine.internal.dao.DaoUtil;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.joda.time.DateTime;
import org.joda.time.base.BaseDateTime;

public interface SQLVariants {
    public String currentTimePlusSeconds(int var1);

    default public boolean hasUpdateReturning() {
        return false;
    }

    public String workflowStatus(WorkflowInstance.WorkflowInstanceStatus var1);

    public String workflowStatus();

    public String actionType();

    public boolean hasUpdateableCTE();

    public String nextActivationUpdate();

    public String castToText();

    public String limit(String var1, long var2);

    public int longTextType();

    public boolean useBatchUpdate();

    default public String forUpdateSkipLocked() {
        return " for update";
    }

    default public String dateLtEqDiff(String date1, String date2) {
        return date1 + " <= " + date2;
    }

    default public Object getTimestamp(ResultSet rs, String columnName) throws SQLException {
        return rs.getTimestamp(columnName);
    }

    default public DateTime getDateTime(ResultSet rs, String columnName) throws SQLException {
        return DaoUtil.toDateTime(rs.getTimestamp(columnName));
    }

    default public void setDateTime(PreparedStatement ps, int columnNumber, DateTime timestamp) throws SQLException {
        ps.setTimestamp(columnNumber, DaoUtil.toTimestamp((BaseDateTime)timestamp));
    }

    default public Object toTimestampObject(DateTime timestamp) {
        return DaoUtil.toTimestamp((BaseDateTime)timestamp);
    }

    default public Object tuneTimestampForDb(Object timestamp) {
        return timestamp;
    }

    default public String withUpdateSkipLocked() {
        return "";
    }

    default public String caseSensitiveLike() {
        return "like";
    }

    default public String clobToComparable(String column) {
        return column;
    }
}

