/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.workflow;

import io.nflow.engine.internal.dao.WorkflowInstanceDao;
import io.nflow.engine.internal.workflow.ObjectStringMapper;
import io.nflow.engine.internal.workflow.WorkflowInstancePreProcessor;
import io.nflow.engine.model.ModelObject;
import io.nflow.engine.service.WorkflowInstanceService;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.instance.QueryWorkflowInstances;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import io.nflow.engine.workflow.instance.WorkflowInstanceAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class StateExecutionImpl
extends ModelObject
implements StateExecution {
    private static final Logger LOG = LoggerFactory.getLogger(StateExecutionImpl.class);
    private final WorkflowInstance instance;
    private final ObjectStringMapper objectMapper;
    private final WorkflowInstanceDao workflowDao;
    private final WorkflowInstancePreProcessor workflowInstancePreProcessor;
    private final WorkflowInstanceService workflowInstanceService;
    private DateTime nextActivation;
    private WorkflowState nextState;
    private String nextStateReason;
    private boolean isRetry;
    private Throwable thrown;
    private boolean isFailed;
    private boolean isRetryCountExceeded;
    private boolean isStateProcessInvoked = false;
    private final List<WorkflowInstance> newChildWorkflows = new LinkedList<WorkflowInstance>();
    private final List<WorkflowInstance> newWorkflows = new LinkedList<WorkflowInstance>();
    private boolean createAction = true;
    private String[] wakeUpParentStates;
    private boolean historyCleaningForced = false;
    private String businessKey;

    public StateExecutionImpl(WorkflowInstance instance, ObjectStringMapper objectMapper, WorkflowInstanceDao workflowDao, WorkflowInstancePreProcessor workflowInstancePreProcessor, WorkflowInstanceService workflowInstanceService) {
        this.instance = instance;
        this.objectMapper = objectMapper;
        this.workflowDao = workflowDao;
        this.workflowInstancePreProcessor = workflowInstancePreProcessor;
        this.workflowInstanceService = workflowInstanceService;
    }

    public DateTime getNextActivation() {
        return this.nextActivation;
    }

    public WorkflowState getNextState() {
        return this.nextState;
    }

    public String getNextStateReason() {
        return this.nextStateReason;
    }

    public String getCurrentStateName() {
        return this.instance.state;
    }

    @Override
    public long getWorkflowInstanceId() {
        return this.instance.id;
    }

    @Override
    public String getWorkflowInstanceExternalId() {
        return this.instance.externalId;
    }

    @Override
    public String getBusinessKey() {
        return this.instance.businessKey;
    }

    @Override
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public String getNewBusinessKey() {
        return this.businessKey;
    }

    @Override
    public int getRetries() {
        return this.instance.retries;
    }

    @Override
    public String getVariable(String name) {
        return this.getVariable(name, (String)null);
    }

    @Override
    public <T> T getVariable(String name, Class<T> type) {
        return this.getVariable(name, type, null);
    }

    @Override
    public <T> T getVariable(String name, Class<T> type, T defaultValue) {
        String value = this.instance.stateVariables.get(name);
        if (value != null) {
            return (T)this.objectMapper.convertToObject(type, name, value);
        }
        return defaultValue;
    }

    @Override
    public String getVariable(String name, String defaultValue) {
        return this.instance.stateVariables.getOrDefault(name, defaultValue);
    }

    @Override
    public void setVariable(String name, String value) {
        this.workflowDao.checkStateVariableValueLength(name, value);
        this.instance.stateVariables.put(name, value);
    }

    @Override
    public void setVariable(String name, Object value) {
        this.setVariable(name, this.objectMapper.convertFromObject(name, value));
    }

    public void setNextActivation(DateTime activation) {
        this.nextActivation = activation;
    }

    public void setNextState(WorkflowState state) {
        Assert.notNull((Object)state, (String)"Next state can not be null");
        this.nextState = state;
    }

    public void setNextStateReason(String reason) {
        this.nextStateReason = reason;
    }

    public boolean isRetry() {
        return this.isRetry;
    }

    public void setRetry(boolean isRetry) {
        this.isRetry = isRetry;
    }

    public boolean isFailed() {
        return this.isFailed;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public void setFailed() {
        this.isFailed = true;
    }

    public void setFailed(Throwable t) {
        this.isFailed = true;
        this.thrown = t;
    }

    public boolean isRetryCountExceeded() {
        return this.isRetryCountExceeded;
    }

    @Override
    public void addChildWorkflows(WorkflowInstance ... childWorkflows) {
        Assert.notNull((Object)childWorkflows, (String)"childWorkflows can not be null");
        for (WorkflowInstance child : childWorkflows) {
            Assert.notNull((Object)child, (String)"childWorkflow can not be null");
            WorkflowInstance processedChild = this.workflowInstancePreProcessor.process(child);
            this.newChildWorkflows.add(processedChild);
        }
    }

    @Override
    public void addWorkflows(WorkflowInstance ... workflows) {
        Assert.notNull((Object)workflows, (String)"workflows can not be null");
        for (WorkflowInstance workflow : workflows) {
            Assert.notNull((Object)workflow, (String)"workflow can not be null");
            WorkflowInstance processedInstance = this.workflowInstancePreProcessor.process(workflow);
            this.newWorkflows.add(processedInstance);
        }
    }

    public List<WorkflowInstance> getNewChildWorkflows() {
        return Collections.unmodifiableList(this.newChildWorkflows);
    }

    public List<WorkflowInstance> getNewWorkflows() {
        return Collections.unmodifiableList(this.newWorkflows);
    }

    @Override
    public List<WorkflowInstance> queryChildWorkflows(QueryWorkflowInstances query) {
        QueryWorkflowInstances restrictedQuery = new QueryWorkflowInstances.Builder(query).setParentWorkflowId(this.instance.id).build();
        return this.workflowDao.queryWorkflowInstances(restrictedQuery);
    }

    @Override
    public List<WorkflowInstance> getAllChildWorkflows() {
        return this.queryChildWorkflows(new QueryWorkflowInstances.Builder().build());
    }

    @Override
    public void wakeUpParentWorkflow(String ... expectedStates) {
        if (this.instance.parentWorkflowId == null) {
            LOG.warn("wakeUpParentWorkflow called on non-child workflow");
            return;
        }
        this.wakeUpParentStates = expectedStates;
    }

    public Optional<List<String>> getWakeUpParentWorkflowStates() {
        return Optional.ofNullable(this.wakeUpParentStates).map(Arrays::asList);
    }

    @Override
    public WorkflowInstance.Builder workflowInstanceBuilder() {
        return new WorkflowInstance.Builder(this.objectMapper).setNextActivation(DateTime.now());
    }

    public void setStateProcessInvoked(boolean isStateProcessInvoked) {
        this.isStateProcessInvoked = isStateProcessInvoked;
    }

    public boolean isStateProcessInvoked() {
        return this.isStateProcessInvoked;
    }

    @Override
    public void setCreateAction(boolean createAction) {
        this.createAction = createAction;
    }

    public boolean createAction() {
        return this.createAction;
    }

    @Override
    public Optional<Integer> getSignal() {
        return this.workflowDao.getSignal(this.instance.id);
    }

    @Override
    public void setSignal(Optional<Integer> signal, String reason) {
        Assert.notNull(signal, (String)"signal can not be null, use Optional.empty() to clear the signal value");
        this.workflowInstanceService.setSignal(this.instance.id, signal, reason, WorkflowInstanceAction.WorkflowActionType.stateExecution);
    }

    @Override
    public Optional<Long> getParentId() {
        return Optional.ofNullable(this.instance.parentWorkflowId);
    }

    @Override
    public void setHistoryCleaningForced(boolean historyCleaningForced) {
        this.historyCleaningForced = historyCleaningForced;
    }

    public boolean isHistoryCleaningForced() {
        return this.historyCleaningForced;
    }

    public void handleRetryAfter(DateTime activation, WorkflowDefinition definition) {
        if (this.getRetries() >= definition.getSettings().maxRetries) {
            this.isRetryCountExceeded = true;
            this.handleFailure(definition, "Max retry count exceeded");
        } else {
            this.setNextActivation(activation);
        }
    }

    public void handleFailure(WorkflowDefinition definition, String failureReason) {
        this.setRetry(false);
        String currentStateName = this.getCurrentStateName();
        WorkflowState failureState = definition.getFailureTransitions().get(currentStateName);
        WorkflowState currentState = definition.getState(currentStateName);
        if (failureState != null) {
            this.setNextState(failureState);
            this.setNextStateReason(failureReason + ", going to failure state");
            this.setNextActivation(DateTime.now());
        } else {
            WorkflowState errorState = definition.getErrorState();
            this.setNextState(errorState);
            if (errorState.equals(currentState)) {
                this.setNextStateReason(failureReason + " when handling error state, processing stopped");
                this.setNextActivation(null);
            } else {
                this.setNextStateReason(failureReason + ", no failure state defined, going to error state");
                this.setNextActivation(DateTime.now());
            }
        }
    }

    @Override
    public boolean hasUnfinishedChildWorkflows() {
        return this.workflowInstanceService.hasUnfinishedChildWorkflows(this.instance.id);
    }
}

