/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.service;

import io.nflow.engine.config.NFlow;
import io.nflow.engine.service.WorkflowDefinitionService;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.stereotype.Component;

@Component
public class WorkflowDefinitionClassNameScanner {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowDefinitionClassNameScanner.class);

    @Inject
    public WorkflowDefinitionClassNameScanner(WorkflowDefinitionService workflowDefinitionService, @Nullable @NFlow AbstractResource classNameListing) throws IOException, ReflectiveOperationException {
        if (classNameListing == null) {
            logger.info("No non-Spring workflow definitions");
        } else {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(classNameListing.getInputStream(), StandardCharsets.UTF_8));){
                String row;
                while ((row = br.readLine()) != null) {
                    logger.info("Preparing workflow {}", (Object)row);
                    Class<?> clazz = Class.forName(row);
                    workflowDefinitionService.addWorkflowDefinition((WorkflowDefinition)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
            }
        }
    }
}

