/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.workflow.curated;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.workflow.curated.State;
import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.StateVar;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.support.CronExpression;

public abstract class CronWorkflow
extends WorkflowDefinition {
    private static final Logger logger = LoggerFactory.getLogger(CronWorkflow.class);
    public static final String VAR_SCHEDULE = "cron";
    public static final WorkflowState SCHEDULE = new State("schedule", WorkflowStateType.start, "Schedule work to be done according to the cron state variable");
    public static final WorkflowState DO_WORK = new State("doWork", "Execute the actual work");
    public static final WorkflowState WAIT_FOR_WORK_TO_FINISH = new State("waitForWorkToFinish", "Wait for work to finish");
    public static final WorkflowState HANDLE_FAILURE = new State("handleFailure", "Handle failure and decide if workflow should be re-scheduled or stopped");
    public static final WorkflowState DISABLED = new State("disabled", WorkflowStateType.manual, "Workflow is disabled");
    public static final WorkflowState FAILED = new State("failed", WorkflowStateType.manual, "Processing failed, waiting for manual actions");

    protected CronWorkflow(String type, WorkflowSettings settings) {
        super(type, SCHEDULE, HANDLE_FAILURE, settings);
        this.permit(SCHEDULE, DO_WORK);
        this.permit(DO_WORK, SCHEDULE);
        this.permit(DO_WORK, WAIT_FOR_WORK_TO_FINISH);
        this.permit(WAIT_FOR_WORK_TO_FINISH, SCHEDULE);
        this.permit(HANDLE_FAILURE, SCHEDULE, FAILED);
    }

    protected CronWorkflow(String type) {
        this(type, new WorkflowSettings.Builder().setHistoryDeletableAfter((ReadablePeriod)Days.days((int)45)).setDeleteHistoryCondition(WorkflowSettings.Builder.oncePerDay()).build());
    }

    public NextAction schedule(StateExecution execution, @StateVar(value="cron", readOnly=true) String cron) {
        return NextAction.moveToStateAfter(DO_WORK, this.getNextActivationTime(execution, cron), "Scheduled");
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="npe is unlikely")
    protected DateTime getNextActivationTime(StateExecution execution, String cron) {
        return new DateTime(((ZonedDateTime)CronExpression.parse((String)cron).next((Temporal)ZonedDateTime.now())).toInstant().toEpochMilli());
    }

    public NextAction handleFailure(StateExecution execution) {
        if (this.handleFailureImpl(execution)) {
            return NextAction.moveToState(SCHEDULE, "Failure handled, rescheduling");
        }
        return NextAction.moveToState(FAILED, "Failure handling failed, stopping");
    }

    protected boolean handleFailureImpl(StateExecution execution) {
        logger.error("Cron workflow {} / {} work failed", (Object)this.getType(), (Object)execution.getWorkflowInstanceId());
        return true;
    }

    public NextAction waitForWorkToFinish(StateExecution execution) {
        DateTime waitUntil = this.waitForWorkToFinishImpl(execution);
        if (waitUntil == null) {
            return NextAction.moveToState(SCHEDULE, "Work finished, rescheduling");
        }
        return NextAction.retryAfter(waitUntil, "Waiting for work to finish");
    }

    protected DateTime waitForWorkToFinishImpl(StateExecution execution) {
        if (execution.hasUnfinishedChildWorkflows()) {
            logger.info("Unfinished child workflow found, waiting before scheduling next work.");
            return DateTime.now().plusHours(1);
        }
        logger.info("No unfinished child workflows found, scheduling next work.");
        return null;
    }
}

