/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.workflow.definition;

import io.nflow.engine.internal.executor.InvalidNextActionException;
import io.nflow.engine.model.ModelObject;
import io.nflow.engine.workflow.definition.WorkflowState;
import org.joda.time.DateTime;

public class NextAction
extends ModelObject {
    private final DateTime activation;
    private final WorkflowState nextState;
    private final String reason;

    private NextAction(DateTime activation, WorkflowState nextState, String reason) {
        this.reason = reason;
        this.nextState = nextState;
        this.activation = activation;
    }

    public DateTime getActivation() {
        return this.activation;
    }

    public WorkflowState getNextState() {
        return this.nextState;
    }

    public String getReason() {
        return this.reason;
    }

    public static NextAction retryAfter(DateTime activation, String reason) {
        NextAction.assertNotNull(activation, "Activation can not be null");
        return new NextAction(activation, null, reason);
    }

    public static NextAction moveToStateAfter(WorkflowState nextState, DateTime activation, String reason) {
        NextAction.assertNotNull(nextState, "Next state can not be null");
        NextAction.assertNotNull(activation, "Activation can not be null");
        return new NextAction(activation, nextState, reason);
    }

    public static NextAction moveToState(WorkflowState nextState, String reason) {
        NextAction.assertNotNull(nextState, "Next state can not be null");
        return new NextAction(DateTime.now(), nextState, reason);
    }

    public static NextAction stopInState(WorkflowState finalState, String reason) {
        NextAction.assertNotNull(finalState, "State can not be null");
        NextAction.assertFinalState(finalState);
        return new NextAction(null, finalState, reason);
    }

    private static void assertFinalState(WorkflowState state) {
        if (!state.getType().isFinal()) {
            throw new InvalidNextActionException("Cannot stop in state " + state.name() + " because it is not final");
        }
    }

    private static void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new InvalidNextActionException(message);
        }
    }

    public boolean isRetry() {
        return this.nextState == null;
    }
}

