/*
 * Decompiled with CFR 0.152.
 */
package com.internetitem.logback.elasticsearch.config;

import com.amazonaws.ReadLimitInfo;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.regions.Regions;
import com.amazonaws.util.StringInputStream;
import com.internetitem.logback.elasticsearch.config.Authentication;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AWSAuthentication
implements Authentication {
    private final AWS4Signer signer = new AWS4Signer(false);
    private final AWSCredentials credentials;

    public AWSAuthentication() {
        this.signer.setServiceName("es");
        this.signer.setRegionName(System.getenv("AWS_REGION"));
        DefaultAWSCredentialsProviderChain credsProvider = new DefaultAWSCredentialsProviderChain();
        this.credentials = credsProvider.getCredentials();
    }

    @Override
    public void addAuth(HttpURLConnection urlConnection, String body) {
        this.signer.sign((SignableRequest)new URLConnectionSignableRequest(urlConnection, body), this.credentials);
    }

    private String getCurrentRegion() {
        if (Regions.getCurrentRegion() != null) {
            return Regions.getCurrentRegion().getName();
        }
        return null;
    }

    private static class URLConnectionSignableRequest
    implements SignableRequest<HttpURLConnection> {
        private final HttpURLConnection urlConnection;
        private final String body;
        private final Map<String, String> headers = new HashMap<String, String>();

        public URLConnectionSignableRequest(HttpURLConnection urlConnection, String body) {
            this.urlConnection = urlConnection;
            this.body = body;
            this.addHeader("User-Agent", "ElasticSearchWriter/1.0");
            this.addHeader("Accept", "*/*");
            this.addHeader("Content-Type", "application/json");
            this.addHeader("Content-Length", String.valueOf(body.length()));
        }

        public void addHeader(String name, String value) {
            this.urlConnection.addRequestProperty(name, value);
            this.headers.put(name, value);
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getResourcePath() {
            return this.urlConnection.getURL().getPath();
        }

        public void addParameter(String name, String value) {
        }

        public Map<String, List<String>> getParameters() {
            return Collections.emptyMap();
        }

        public URI getEndpoint() {
            try {
                URL u = this.urlConnection.getURL();
                return new URI(u.getProtocol(), null, u.getHost(), u.getPort(), null, null, null);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public HttpMethodName getHttpMethod() {
            return HttpMethodName.fromValue((String)this.urlConnection.getRequestMethod());
        }

        public int getTimeOffset() {
            return 0;
        }

        public InputStream getContent() {
            try {
                return new StringInputStream(this.body);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public void setContent(InputStream content) {
        }

        public InputStream getContentUnwrapped() {
            return this.getContent();
        }

        public ReadLimitInfo getReadLimitInfo() {
            return null;
        }

        public Object getOriginalRequestObject() {
            return null;
        }
    }
}

