/*
 * Decompiled with CFR 0.152.
 */
package com.internetitem.logback.elasticsearch.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import com.internetitem.logback.elasticsearch.config.Property;

public abstract class AbstractPropertyAndEncoder<T> {
    private Property property;
    private PatternLayoutBase<T> layout;

    public AbstractPropertyAndEncoder(Property property, Context context) {
        this.property = property;
        this.layout = this.getLayout();
        this.layout.setContext(context);
        this.layout.setPattern(property.getValue());
        this.layout.setPostCompileProcessor(null);
        this.layout.start();
    }

    protected abstract PatternLayoutBase<T> getLayout();

    public String encode(T event) {
        return this.layout.doLayout(event);
    }

    public String getName() {
        return this.property.getName();
    }

    public boolean allowEmpty() {
        return this.property.isAllowEmpty();
    }

    public Property.Type getType() {
        return this.property.getType();
    }
}

