/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.htmx;

import io.quarkiverse.renarde.Controller;
import io.quarkus.qute.Qute;
import io.quarkus.qute.TemplateInstance;
import io.vertx.core.http.HttpServerResponse;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Objects;

public abstract class HxController
extends Controller {
    public static final String HX_REQUEST_HEADER = "HX-Request";
    @Inject
    protected HttpHeaders httpHeaders;
    @Inject
    protected HttpServerResponse response;

    public static TemplateInstance concatTemplates(TemplateInstance ... templates) {
        return Qute.fmt((String)"{#each elements}{it.raw}{/each}").cache().data("elements", Arrays.stream(templates).map(TemplateInstance::createUni)).instance();
    }

    protected boolean isHxRequest() {
        boolean hxRequest = Objects.equals(this.flash.get(HX_REQUEST_HEADER), true);
        if (hxRequest) {
            return true;
        }
        return Objects.equals(this.httpHeaders.getHeaderString(HX_REQUEST_HEADER), "true");
    }

    protected void hx(HxResponseHeader hxHeader, String value) {
        this.response.headers().set(hxHeader.key(), value);
    }

    protected String hx(HxRequestHeader header) {
        return this.httpHeaders.getHeaderString(header.key);
    }

    protected void onlyHxRequest() {
        if (!this.isHxRequest()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Only Hx request are allowed on this method").build());
        }
    }

    protected void flashHxRequest() {
        this.flash(HX_REQUEST_HEADER, this.isHxRequest());
    }

    @Override
    protected void beforeRedirect() {
        this.flashHxRequest();
        super.beforeRedirect();
    }

    public static enum HxResponseHeader {
        TRIGGER("HX-Trigger"),
        REDIRECT("HX-Redirect"),
        LOCATION("HX-Location"),
        REFRESH("HX-Refresh"),
        PUSH_URL("HX-Push-Url"),
        HX_RESWAP("HX-Reswap"),
        HX_RETARGET("HX-Retarget"),
        TRIGGER_AFTER_SWAP("HX-Trigger-After-Swap"),
        TRIGGER_AFTER_SETTLE("HX-Trigger-After-Settle"),
        REPLACE_URL("HX-Replace-Url"),
        RESELECT("HX-Reselect");

        private final String key;

        private HxResponseHeader(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }

    public static enum HxRequestHeader {
        BOOSTED("HX-Boosted"),
        CURRENT_URL("HX-Current-URL"),
        HISTORY_RESTORE_REQUEST("HX-History-Restore-Request"),
        PROMPT("HX-Prompt"),
        REQUEST("HX-Request"),
        TARGET("HX-Target"),
        TRIGGER_NAME("HX-Trigger-Name"),
        TRIGGER("HX-Trigger");

        private final String key;

        private HxRequestHeader(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }
}

