/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.util;

import io.quarkiverse.renarde.Controller;
import io.quarkiverse.renarde.util.Validation;
import io.quarkus.hibernate.validator.runtime.interceptor.AbstractMethodValidationInterceptor;
import io.quarkus.hibernate.validator.runtime.jaxrs.JaxrsEndPointValidated;
import io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyReactiveViolationException;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.validation.Validator;
import jakarta.validation.executable.ExecutableValidator;
import java.util.Set;

@JaxrsEndPointValidated
@Interceptor
@Priority(value=4700)
public class MyValidationInterceptor
extends AbstractMethodValidationInterceptor {
    @Inject
    Validator validator;
    @Inject
    Validation validation;

    @AroundInvoke
    public Object validateMethodInvocation(InvocationContext ctx) throws Exception {
        ExecutableValidator executableValidator = this.validator.forExecutables();
        Set violations = executableValidator.validateParameters(ctx.getTarget(), ctx.getMethod(), ctx.getParameters(), new Class[0]);
        if (!violations.isEmpty()) {
            if (ctx.getTarget() instanceof Controller) {
                this.validation.addErrors(violations);
            } else {
                throw new ResteasyReactiveViolationException(violations);
            }
        }
        Object result = ctx.proceed();
        violations = executableValidator.validateReturnValue(ctx.getTarget(), ctx.getMethod(), result, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ResteasyReactiveViolationException(violations);
        }
        return result;
    }

    @AroundConstruct
    public void validateConstructorInvocation(InvocationContext ctx) throws Exception {
        super.validateConstructorInvocation(ctx);
    }
}

