/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.analytics.dto.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkus.analytics.dto.config.AnalyticsRemoteConfig;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Objects;

public class RemoteConfig
implements AnalyticsRemoteConfig,
Serializable {
    private boolean active;
    private List<String> denyAnonymousIds;
    private List<String> denyQuarkusVersions;
    private Duration refreshInterval;

    public RemoteConfig() {
    }

    RemoteConfig(boolean active, List<String> denyUserIds, List<String> denyQuarkusVersions, Duration refreshInterval) {
        this.active = active;
        this.denyAnonymousIds = denyUserIds;
        this.denyQuarkusVersions = denyQuarkusVersions;
        this.refreshInterval = refreshInterval;
    }

    public static RemoteConfigBuilder builder() {
        return new RemoteConfigBuilder();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    @JsonProperty(value="deny_anonymous_ids")
    public List<String> getDenyAnonymousIds() {
        return this.denyAnonymousIds;
    }

    public void setDenyAnonymousIds(List<String> denyAnonymousIds) {
        this.denyAnonymousIds = denyAnonymousIds;
    }

    @Override
    @JsonProperty(value="deny_quarkus_versions")
    public List<String> getDenyQuarkusVersions() {
        return this.denyQuarkusVersions;
    }

    public void setDenyQuarkusVersions(List<String> denyQuarkusVersions) {
        this.denyQuarkusVersions = denyQuarkusVersions;
    }

    @Override
    @JsonProperty(value="refresh_interval")
    public Duration getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(Duration refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteConfig that = (RemoteConfig)o;
        return this.active == that.active && Objects.equals(this.denyAnonymousIds, that.denyAnonymousIds) && Objects.equals(this.denyQuarkusVersions, that.denyQuarkusVersions) && Objects.equals(this.refreshInterval, that.refreshInterval);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.denyAnonymousIds, this.denyQuarkusVersions, this.refreshInterval);
    }

    public static class RemoteConfigBuilder {
        private boolean active;
        private List<String> denyUserIds;
        private List<String> denyQuarkusVersions;
        private Duration refreshInterval;

        RemoteConfigBuilder() {
        }

        public RemoteConfigBuilder active(boolean active) {
            this.active = active;
            return this;
        }

        public RemoteConfigBuilder denyUserIds(List<String> denyUserIds) {
            this.denyUserIds = denyUserIds;
            return this;
        }

        public RemoteConfigBuilder denyQuarkusVersions(List<String> denyQuarkusVersions) {
            this.denyQuarkusVersions = denyQuarkusVersions;
            return this;
        }

        public RemoteConfigBuilder refreshInterval(Duration refreshInterval) {
            this.refreshInterval = refreshInterval;
            return this;
        }

        public RemoteConfig build() {
            return new RemoteConfig(this.active, this.denyUserIds, this.denyQuarkusVersions, this.refreshInterval);
        }

        public String toString() {
            return "RemoteConfig.RemoteConfigBuilder(active=" + this.active + ", denyUserIds=" + String.valueOf(this.denyUserIds) + ", denyQuarkusVersions=" + String.valueOf(this.denyQuarkusVersions) + ", refreshInterval=" + String.valueOf(this.refreshInterval) + ")";
        }
    }
}

