/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.app;

import io.quarkus.bootstrap.app.BootstrapProfile;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.paths.PathCollection;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ConfiguredClassLoading
implements Serializable {
    private static final long serialVersionUID = 8458420778153976864L;
    private final Set<ArtifactKey> parentFirstArtifacts = new HashSet<ArtifactKey>();
    private final Set<ArtifactKey> reloadableArtifacts = new HashSet<ArtifactKey>();
    private final Set<ArtifactKey> removedArtifacts = new HashSet<ArtifactKey>();
    private final Map<ArtifactKey, Collection<String>> removedResources = new HashMap<ArtifactKey, Collection<String>>();
    private boolean flatTestClassPath;
    private Collection<Path> additionalPaths = List.of();

    public static Builder builder() {
        return new ConfiguredClassLoading().new Builder();
    }

    private ConfiguredClassLoading() {
    }

    public Collection<ArtifactKey> getParentFirstArtifacts() {
        return this.parentFirstArtifacts;
    }

    public boolean isParentFirstArtifact(ArtifactKey key) {
        return this.parentFirstArtifacts.contains(key);
    }

    public boolean isReloadableArtifact(ArtifactKey key) {
        return this.reloadableArtifacts.contains(key);
    }

    public boolean isRemovedArtifact(ArtifactKey key) {
        return this.removedArtifacts.contains(key);
    }

    public Map<ArtifactKey, Collection<String>> getRemovedResources() {
        return this.removedResources;
    }

    public boolean isFlatTestClassPath() {
        return this.flatTestClassPath;
    }

    public Collection<Path> getAdditionalClasspathElements() {
        return this.additionalPaths;
    }

    public class Builder {
        private PathCollection applicationRoot;
        private QuarkusBootstrap.Mode mode;
        private ApplicationModel appModel;

        private Builder() {
        }

        public Builder setApplicationRoot(PathCollection applicationRoot) {
            this.applicationRoot = applicationRoot;
            return this;
        }

        public Builder setMode(QuarkusBootstrap.Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder setDefaultFlatTestClassPath(boolean flatClassPath) {
            ConfiguredClassLoading.this.flatTestClassPath = flatClassPath;
            return this;
        }

        public Builder addParentFirstArtifacts(Collection<ArtifactKey> parentFirst) {
            ConfiguredClassLoading.this.parentFirstArtifacts.addAll(parentFirst);
            return this;
        }

        public Builder setApplicationModel(ApplicationModel model) {
            this.appModel = model;
            return this;
        }

        public ConfiguredClassLoading build() {
            Object p;
            for (Object path : this.applicationRoot) {
                String s;
                Path props = path.resolve("application.properties");
                if (!Files.exists(props, new LinkOption[0])) continue;
                p = new Properties();
                try (InputStream in = Files.newInputStream(props, new OpenOption[0]);){
                    ((Properties)p).load(in);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load bootstrap classloading config from application.properties", e);
                }
                this.collectArtifactKeys(((Properties)p).getProperty(this.selectKey("quarkus.class-loading.parent-first-artifacts", (Properties)p, this.mode)), ConfiguredClassLoading.this.parentFirstArtifacts);
                this.collectArtifactKeys(((Properties)p).getProperty(this.selectKey("quarkus.class-loading.reloadable-artifacts", (Properties)p, this.mode)), ConfiguredClassLoading.this.reloadableArtifacts);
                this.collectArtifactKeys(((Properties)p).getProperty(this.selectKey("quarkus.class-loading.removed-artifacts", (Properties)p, this.mode)), ConfiguredClassLoading.this.removedArtifacts);
                this.collectRemovedResources("quarkus.class-loading.removed-resources.", (Properties)p);
                if (ConfiguredClassLoading.this.flatTestClassPath || this.mode != QuarkusBootstrap.Mode.TEST || (s = ((Properties)p).getProperty(this.selectKey("quarkus.test.flat-class-path", (Properties)p, this.mode))) == null) continue;
                ConfiguredClassLoading.this.flatTestClassPath = Boolean.parseBoolean(s);
            }
            if (this.appModel != null) {
                WorkspaceModule module;
                ConfiguredClassLoading.this.parentFirstArtifacts.addAll(this.appModel.getParentFirst());
                if (this.mode == QuarkusBootstrap.Mode.TEST && (module = this.appModel.getApplicationModule()) != null) {
                    for (String s : module.getTestClasspathDependencyExclusions()) {
                        ConfiguredClassLoading.this.removedArtifacts.add(ArtifactKey.fromString((String)s));
                    }
                    if (!module.getAdditionalTestClasspathElements().isEmpty()) {
                        ConfiguredClassLoading.this.additionalPaths = new ArrayList<Path>(module.getAdditionalTestClasspathElements().size());
                        for (String s : module.getAdditionalTestClasspathElements()) {
                            p = Path.of(s, new String[0]);
                            if (!Files.exists((Path)p, new LinkOption[0])) continue;
                            ConfiguredClassLoading.this.additionalPaths.add((Path)p);
                        }
                    }
                }
                if (!this.appModel.getRemovedResources().isEmpty()) {
                    for (Map.Entry e : this.appModel.getRemovedResources().entrySet()) {
                        Collection<String> resources = ConfiguredClassLoading.this.removedResources.get(e.getKey());
                        if (resources == null) {
                            ConfiguredClassLoading.this.removedResources.put((ArtifactKey)e.getKey(), (Collection)e.getValue());
                            continue;
                        }
                        resources.addAll((Collection)e.getValue());
                    }
                }
            }
            return ConfiguredClassLoading.this;
        }

        private void collectRemovedResources(String baseConfigKey, Properties properties) {
            String key;
            Properties profileProps = new Properties();
            String profile = BootstrapProfile.getActiveProfile(this.mode);
            for (Map.Entry<Object, Object> i : properties.entrySet()) {
                key = i.getKey().toString();
                if (key.startsWith("%")) continue;
                String profileKey = "%" + profile + "." + key;
                if (properties.containsKey(profileKey)) {
                    profileProps.put(key, properties.getProperty(profileKey));
                    continue;
                }
                profileProps.put(key, i.getValue());
            }
            for (Map.Entry<Object, Object> entry : profileProps.entrySet()) {
                key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (!key.startsWith(baseConfigKey)) continue;
                String artifactId = key.substring(baseConfigKey.length());
                artifactId = artifactId.replace("\"", "");
                String[] split = value.split(",");
                ArrayList<String> resources = new ArrayList<String>(split.length);
                for (String s : split) {
                    resources.add(s);
                }
                ConfiguredClassLoading.this.removedResources.put((ArtifactKey)new GACT(artifactId.split(":")), resources);
            }
        }

        private String selectKey(String base, Properties p, QuarkusBootstrap.Mode mode) {
            String profile = BootstrapProfile.getActiveProfile(mode);
            String profileKey = "%" + profile + "." + base;
            if (p.containsKey(profileKey)) {
                return profileKey;
            }
            return base;
        }

        private void collectArtifactKeys(String config, Collection<ArtifactKey> keys) {
            String[] split;
            if (config == null) {
                return;
            }
            for (String i : split = config.split(",")) {
                keys.add((ArtifactKey)new GACT(i.split(":")));
            }
        }
    }
}

