/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.CurationResult;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;

public class BootstrapAppModelFactory {
    private static final String QUARKUS = "quarkus";
    private static final String BOOTSTRAP = "bootstrap";
    private static final String APP_MODEL_DAT = "app-model.dat";
    public static final String CREATOR_APP_GROUP_ID = "creator.app.groupId";
    public static final String CREATOR_APP_ARTIFACT_ID = "creator.app.artifactId";
    public static final String CREATOR_APP_CLASSIFIER = "creator.app.classifier";
    public static final String CREATOR_APP_TYPE = "creator.app.type";
    public static final String CREATOR_APP_VERSION = "creator.app.version";
    private static final int CP_CACHE_FORMAT_ID = 2;
    private static final Logger log = Logger.getLogger(BootstrapAppModelFactory.class);
    private ArtifactCoords managingProject;
    private Path projectRoot;
    private List<Path> appCp = new ArrayList<Path>(0);
    private Boolean localProjectsDiscovery;
    private Boolean offline;
    private boolean enableClasspathCache;
    private boolean test;
    private boolean devMode;
    private AppModelResolver bootstrapAppModelResolver;
    private ResolvedDependency appArtifact;
    private MavenArtifactResolver mavenArtifactResolver;
    private BootstrapMavenContext mvnContext;
    Set<ArtifactKey> reloadableModules = Collections.emptySet();
    private Collection<Dependency> forcedDependencies = Collections.emptyList();

    public static BootstrapAppModelFactory newInstance() {
        return new BootstrapAppModelFactory();
    }

    private BootstrapAppModelFactory() {
    }

    public BootstrapAppModelFactory setTest(boolean test) {
        this.test = test;
        return this;
    }

    public BootstrapAppModelFactory setDevMode(boolean devMode) {
        this.devMode = devMode;
        return this;
    }

    public BootstrapAppModelFactory setLocalArtifacts(Set<ArtifactKey> localArtifacts) {
        this.reloadableModules = new HashSet<ArtifactKey>(localArtifacts);
        return this;
    }

    public BootstrapAppModelFactory setProjectRoot(Path projectRoot) {
        this.projectRoot = projectRoot;
        return this;
    }

    public BootstrapAppModelFactory addToClassPath(Path path) {
        this.appCp.add(path);
        return this;
    }

    public BootstrapAppModelFactory setLocalProjectsDiscovery(Boolean localProjectsDiscovery) {
        this.localProjectsDiscovery = localProjectsDiscovery;
        return this;
    }

    public BootstrapAppModelFactory setOffline(Boolean offline) {
        this.offline = offline;
        return this;
    }

    public BootstrapAppModelFactory setEnableClasspathCache(boolean enable) {
        this.enableClasspathCache = enable;
        return this;
    }

    public BootstrapAppModelFactory setBootstrapAppModelResolver(AppModelResolver bootstrapAppModelResolver) {
        this.bootstrapAppModelResolver = bootstrapAppModelResolver;
        return this;
    }

    public BootstrapAppModelFactory setAppArtifact(ResolvedDependency appArtifact) {
        this.appArtifact = appArtifact;
        return this;
    }

    public BootstrapAppModelFactory setForcedDependencies(Collection<Dependency> forcedDependencies) {
        this.forcedDependencies = forcedDependencies;
        return this;
    }

    public AppModelResolver getAppModelResolver() {
        if (this.bootstrapAppModelResolver != null) {
            return this.bootstrapAppModelResolver;
        }
        try {
            if (this.projectRoot != null && !Files.isDirectory(this.projectRoot, new LinkOption[0])) {
                MavenArtifactResolver mvn;
                if (this.mavenArtifactResolver == null) {
                    BootstrapMavenContext mvnCtx = this.createBootstrapMavenContext();
                    if (this.managingProject == null) {
                        this.managingProject = mvnCtx.getCurrentProjectArtifact("pom");
                    }
                    mvn = new MavenArtifactResolver(mvnCtx);
                } else {
                    mvn = this.mavenArtifactResolver;
                }
                this.bootstrapAppModelResolver = new BootstrapAppModelResolver(mvn).setTest(this.test).setDevMode(this.devMode);
                return this.bootstrapAppModelResolver;
            }
            MavenArtifactResolver mvn = this.mavenArtifactResolver;
            if (mvn == null) {
                mvn = new MavenArtifactResolver(this.createBootstrapMavenContext());
            }
            this.bootstrapAppModelResolver = new BootstrapAppModelResolver(mvn).setTest(this.test).setDevMode(this.devMode);
            return this.bootstrapAppModelResolver;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create application model resolver for " + this.projectRoot, e);
        }
    }

    private BootstrapMavenContext createBootstrapMavenContext() throws AppModelResolverException {
        Path projectPom;
        if (this.mvnContext != null) {
            return this.mvnContext;
        }
        if (this.mavenArtifactResolver != null) {
            this.mvnContext = this.mavenArtifactResolver.getMavenContext();
            if (this.mvnContext != null) {
                return this.mvnContext;
            }
        }
        BootstrapMavenContextConfig config = BootstrapMavenContext.config();
        if (this.offline != null) {
            config.setOffline(this.offline.booleanValue());
        }
        if ((projectPom = config.getPomForDirOrNull(this.projectRoot)) != null) {
            config.setCurrentProject(projectPom.toString());
        }
        config.setWorkspaceDiscovery(this.isWorkspaceDiscoveryEnabled());
        this.mvnContext = new BootstrapMavenContext(config);
        return this.mvnContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CurationResult resolveAppModel() throws BootstrapException {
        String serializedModel = this.test ? System.getProperty("quarkus-internal-test.serialized-app-model.path") : System.getProperty("quarkus-internal.serialized-app-model.path");
        if (serializedModel != null) {
            Path p = Paths.get(serializedModel, new String[0]);
            if (Files.exists(p, new LinkOption[0])) {
                try (InputStream existing = Files.newInputStream(Paths.get(serializedModel, new String[0]), new OpenOption[0]);){
                    ApplicationModel appModel = (ApplicationModel)new ObjectInputStream(existing).readObject();
                    CurationResult curationResult = new CurationResult(appModel);
                    return curationResult;
                }
                catch (IOException | ClassNotFoundException e) {
                    log.error((Object)"Failed to load serialized app mode", (Throwable)e);
                    IoUtils.recursiveDelete((Path)p);
                }
            } else {
                log.error((Object)("Failed to locate serialized application model at " + serializedModel));
            }
        }
        if (this.projectRoot != null) {
            if (!Files.isDirectory(this.projectRoot, new LinkOption[0])) return this.createAppModelForJar(this.projectRoot);
            if (this.projectRoot.getFileSystem().getClass().getName().contains("Zip")) {
                return this.createAppModelForJar(this.projectRoot);
            }
        }
        ResolvedDependency appArtifact = this.appArtifact;
        try {
            LocalProject localProject = null;
            if (appArtifact == null) {
                if (this.projectRoot == null) {
                    throw new IllegalArgumentException("Neither the application artifact nor the project root path has been provided");
                }
                LocalProject localProject2 = localProject = this.enableClasspathCache ? this.loadWorkspace() : LocalProject.load((Path)this.projectRoot, (boolean)false);
                if (localProject == null) {
                    log.warn((Object)"Unable to locate the maven project on the filesystem");
                    throw new BootstrapException("Failed to determine the Maven artifact associated with the application " + this.projectRoot);
                }
                appArtifact = localProject.getAppArtifact();
            }
            Path cachedCpPath = null;
            LocalWorkspace workspace = null;
            if (this.enableClasspathCache) {
                if (localProject == null) {
                    localProject = this.loadWorkspace();
                }
                workspace = localProject.getWorkspace();
                cachedCpPath = this.resolveCachedCpPath(localProject);
                if (Files.exists(cachedCpPath, new LinkOption[0]) && workspace.getLastModified() < Files.getLastModifiedTime(cachedCpPath, new LinkOption[0]).toMillis()) {
                    try (DataInputStream reader = new DataInputStream(Files.newInputStream(cachedCpPath, new OpenOption[0]));){
                        if (reader.readInt() == 2) {
                            if (reader.readInt() == workspace.getId()) {
                                Path p;
                                ObjectInputStream in = new ObjectInputStream(reader);
                                ApplicationModel appModel = (ApplicationModel)in.readObject();
                                log.debugf("Loaded cached AppModel %s from %s", (Object)appModel, (Object)cachedCpPath);
                                Object object = appModel.getDependencies().iterator();
                                block24: while (true) {
                                    if (!object.hasNext()) {
                                        object = new CurationResult(appModel);
                                        return object;
                                    }
                                    ResolvedDependency d = (ResolvedDependency)object.next();
                                    Iterator iterator = d.getResolvedPaths().iterator();
                                    do {
                                        if (!iterator.hasNext()) continue block24;
                                    } while (Files.exists(p = (Path)iterator.next(), new LinkOption[0]));
                                    break;
                                }
                                throw new IOException("Cached artifact does not exist: " + p);
                            }
                            BootstrapAppModelFactory.debug("Cached deployment classpath has expired for %s", appArtifact);
                        } else {
                            BootstrapAppModelFactory.debug("Unsupported classpath cache format in %s for %s", cachedCpPath, appArtifact);
                        }
                    }
                    catch (IOException e) {
                        log.warn((Object)("Failed to read deployment classpath cache from " + cachedCpPath + " for " + appArtifact), (Throwable)e);
                    }
                }
            }
            CurationResult curationResult = new CurationResult(this.getAppModelResolver().resolveManagedModel((ArtifactCoords)appArtifact, this.forcedDependencies, this.managingProject, this.reloadableModules));
            if (cachedCpPath == null) return curationResult;
            Files.createDirectories(cachedCpPath.getParent(), new FileAttribute[0]);
            try (DataOutputStream out = new DataOutputStream(Files.newOutputStream(cachedCpPath, new OpenOption[0]));){
                out.writeInt(2);
                out.writeInt(workspace.getId());
                ObjectOutputStream obj = new ObjectOutputStream(out);
                obj.writeObject(curationResult.getApplicationModel());
                return curationResult;
            }
            catch (Exception e) {
                log.warn((Object)"Failed to write classpath cache", (Throwable)e);
            }
            return curationResult;
        }
        catch (Exception e) {
            throw new BootstrapException("Failed to create the application model for " + appArtifact, e);
        }
    }

    private boolean isWorkspaceDiscoveryEnabled() {
        return this.localProjectsDiscovery == null ? this.projectRoot != null && (this.test || this.devMode) : this.localProjectsDiscovery;
    }

    private LocalProject loadWorkspace() throws AppModelResolverException {
        return this.projectRoot == null || !Files.isDirectory(this.projectRoot, new LinkOption[0]) ? null : this.createBootstrapMavenContext().getCurrentProject();
    }

    private CurationResult createAppModelForJar(Path appArtifactPath) {
        ApplicationModel appModel;
        AppModelResolver modelResolver = this.getAppModelResolver();
        ResolvedDependency appArtifact = this.appArtifact;
        try {
            if (appArtifact == null) {
                appArtifact = ModelUtils.resolveAppArtifact((Path)appArtifactPath);
            }
            modelResolver.relink((ArtifactCoords)appArtifact, appArtifactPath);
            appModel = modelResolver.resolveManagedModel((ArtifactCoords)appArtifact, Collections.emptyList(), this.managingProject, this.reloadableModules);
        }
        catch (AppModelResolverException | IOException e) {
            throw new RuntimeException("Failed to resolve initial application dependencies", e);
        }
        return new CurationResult(appModel);
    }

    private Path resolveCachedCpPath(LocalProject project) {
        String filePrefix = this.devMode ? "dev-" : (this.test ? "test-" : null);
        return project.getOutputDir().resolve(QUARKUS).resolve(BOOTSTRAP).resolve((String)(filePrefix == null ? APP_MODEL_DAT : filePrefix + APP_MODEL_DAT));
    }

    private static void debug(String msg, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format(msg, args));
        }
    }

    public BootstrapAppModelFactory setMavenArtifactResolver(MavenArtifactResolver mavenArtifactResolver) {
        this.mavenArtifactResolver = mavenArtifactResolver;
        return this;
    }

    public BootstrapAppModelFactory setManagingProject(ArtifactCoords managingProject) {
        this.managingProject = managingProject;
        return this;
    }
}

