/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.bootstrap.model.MutableJarApplicationModel;
import io.quarkus.bootstrap.runner.QuarkusEntryPoint;
import io.quarkus.bootstrap.runner.SerializedApplication;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.commons.classloading.ClassLoaderHelper;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedNativeImageClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.QuarkusBuildCloseablesBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.configuration.ClassLoadingConfig;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.AppCDSRequestedBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.LegacyJarRequiredBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageSourceJarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarIgnoredResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarMergedResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarRequiredBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import io.quarkus.sbom.ApplicationComponent;
import io.quarkus.sbom.ApplicationManifestConfig;
import io.quarkus.utilities.JavaBinFinder;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class JarResultBuildStep {
    private static final String DOT_JAR = ".jar";
    private static final Predicate<String> UBER_JAR_IGNORED_ENTRIES_PREDICATE = new IsEntryIgnoredForUberJarPredicate();
    private static final Predicate<String> UBER_JAR_CONCATENATED_ENTRIES_PREDICATE = new Predicate<String>(){

        @Override
        public boolean test(String path) {
            return "META-INF/io.netty.versions.properties".equals(path) || path.startsWith("META-INF/services/") && path.length() > 18 || "META-INF/sisu/javax.inject.Named".equals(path);
        }
    };
    private static final Logger log = Logger.getLogger(JarResultBuildStep.class);
    private static final BiPredicate<Path, BasicFileAttributes> IS_JSON_FILE_PREDICATE = new IsJsonFilePredicate();
    public static final String DEPLOYMENT_CLASS_PATH_DAT = "deployment-class-path.dat";
    public static final String BUILD_SYSTEM_PROPERTIES = "build-system.properties";
    public static final String DEPLOYMENT_LIB = "deployment";
    public static final String APPMODEL_DAT = "appmodel.dat";
    public static final String QUARKUS_RUN_JAR = "quarkus-run.jar";
    public static final String QUARKUS_APP_DEPS = "quarkus-app-dependencies.txt";
    public static final String BOOT_LIB = "boot";
    public static final String LIB = "lib";
    public static final String MAIN = "main";
    public static final String GENERATED_BYTECODE_JAR = "generated-bytecode.jar";
    public static final String TRANSFORMED_BYTECODE_JAR = "transformed-bytecode.jar";
    public static final String APP = "app";
    public static final String QUARKUS = "quarkus";
    public static final String DEFAULT_FAST_JAR_DIRECTORY_NAME = "quarkus-app";
    public static final String MP_CONFIG_FILE = "META-INF/microprofile-config.properties";
    private static final String VINEFLOWER_VERSION = "1.10.1";

    @BuildStep
    OutputTargetBuildItem outputTarget(BuildSystemTargetBuildItem bst, PackageConfig packageConfig) {
        String name = packageConfig.outputName().orElseGet(bst::getBaseName);
        Path path = packageConfig.outputDirectory().map(s -> bst.getOutputDirectory().resolve((Path)s)).orElseGet(bst::getOutputDirectory);
        Optional<Object> includedOptionalDependencies = packageConfig.jar().filterOptionalDependencies() ? Optional.of(packageConfig.jar().includedOptionalDependencies().map(set -> set.stream().map(ArtifactKey.class::cast).collect(Collectors.toSet())).orElse(Collections.emptySet())) : Optional.empty();
        return new OutputTargetBuildItem(path, name, bst.getOriginalBaseName(), bst.isRebuild(), bst.getBuildSystemProps(), includedOptionalDependencies);
    }

    @BuildStep(onlyIf={JarRequired.class})
    ArtifactResultBuildItem jarOutput(JarBuildItem jarBuildItem) {
        return new ArtifactResultBuildItem(jarBuildItem.getPath(), "jar", jarBuildItem.getLibraryDir() == null ? Map.of() : Map.of("library-dir", jarBuildItem.getLibraryDir().toString()), jarBuildItem.getManifestConfig());
    }

    @BuildStep
    public JarBuildItem buildRunnerJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, ClassLoadingConfig classLoadingConfig, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, List<UberJarRequiredBuildItem> uberJarRequired, List<UberJarMergedResourceBuildItem> uberJarMergedResourceBuildItems, List<UberJarIgnoredResourceBuildItem> uberJarIgnoredResourceBuildItems, List<LegacyJarRequiredBuildItem> legacyJarRequired, QuarkusBuildCloseablesBuildItem closeablesBuildItem, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchiveBuildItems, MainClassBuildItem mainClassBuildItem, Optional<AppCDSRequestedBuildItem> appCDS) throws Exception {
        if (appCDS.isPresent()) {
            this.handleAppCDSSupportFileGeneration(transformedClasses, generatedClasses, appCDS.get());
        }
        if (!uberJarRequired.isEmpty() && !legacyJarRequired.isEmpty()) {
            throw new RuntimeException("Extensions with conflicting package types. One extension requires uber-jar another requires legacy format");
        }
        if (legacyJarRequired.isEmpty() && (!uberJarRequired.isEmpty() || packageConfig.jar().type() == PackageConfig.JarConfig.JarType.UBER_JAR)) {
            return this.buildUberJar(curateOutcomeBuildItem, outputTargetBuildItem, transformedClasses, applicationArchivesBuildItem, packageConfig, applicationInfo, generatedClasses, generatedResources, uberJarMergedResourceBuildItems, uberJarIgnoredResourceBuildItems, mainClassBuildItem, classLoadingConfig);
        }
        if (!legacyJarRequired.isEmpty() || packageConfig.jar().type() == PackageConfig.JarConfig.JarType.LEGACY_JAR) {
            return this.buildLegacyThinJar(curateOutcomeBuildItem, outputTargetBuildItem, transformedClasses, applicationArchivesBuildItem, packageConfig, applicationInfo, generatedClasses, generatedResources, mainClassBuildItem, classLoadingConfig);
        }
        return this.buildThinJar(curateOutcomeBuildItem, outputTargetBuildItem, transformedClasses, applicationArchivesBuildItem, packageConfig, classLoadingConfig, applicationInfo, generatedClasses, generatedResources, additionalApplicationArchiveBuildItems, mainClassBuildItem);
    }

    private void handleAppCDSSupportFileGeneration(TransformedClassesBuildItem transformedClasses, List<GeneratedClassBuildItem> generatedClasses, AppCDSRequestedBuildItem appCDS) throws IOException {
        Path appCDsDir = appCDS.getAppCDSDir();
        Path generatedClassesFile = appCDsDir.resolve("generatedAndTransformed.lst");
        try (BufferedWriter writer = Files.newBufferedWriter(generatedClassesFile, StandardOpenOption.CREATE);){
            StringBuilder classes = new StringBuilder();
            for (GeneratedClassBuildItem generatedClassBuildItem : generatedClasses) {
                classes.append(generatedClassBuildItem.getName().replace('/', '.')).append(System.lineSeparator());
            }
            for (Set set : transformedClasses.getTransformedClassesByJar().values()) {
                for (TransformedClassesBuildItem.TransformedClass transformedClass : set) {
                    if (transformedClass.getData() == null) continue;
                    classes.append(transformedClass.getFileName().replace('/', '.').replace(".class", "")).append(System.lineSeparator());
                }
            }
            if (classes.length() != 0) {
                writer.write(classes.toString());
            }
        }
    }

    private JarBuildItem buildUberJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, PackageConfig packageConfig, ApplicationInfoBuildItem applicationInfo, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, List<UberJarMergedResourceBuildItem> mergeResources, List<UberJarIgnoredResourceBuildItem> ignoredResources, MainClassBuildItem mainClassBuildItem, ClassLoadingConfig classLoadingConfig) throws Exception {
        Path standardJar;
        Path tmpRunnerJar;
        Path runnerJar = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + packageConfig.computedRunnerSuffix() + DOT_JAR);
        if (Files.exists(runnerJar, new LinkOption[0])) {
            tmpRunnerJar = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + packageConfig.computedRunnerSuffix() + ".tmp");
            Files.deleteIfExists(tmpRunnerJar);
        } else {
            tmpRunnerJar = runnerJar;
        }
        this.buildUberJar0(curateOutcomeBuildItem, outputTargetBuildItem, transformedClasses, applicationArchivesBuildItem, packageConfig, applicationInfo, generatedClasses, generatedResources, mergeResources, ignoredResources, mainClassBuildItem, classLoadingConfig, tmpRunnerJar);
        if (tmpRunnerJar != runnerJar) {
            Files.copy(tmpRunnerJar, runnerJar, StandardCopyOption.REPLACE_EXISTING);
            tmpRunnerJar.toFile().deleteOnExit();
        }
        Path originalJar = Files.exists(standardJar = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getOriginalBaseName() + DOT_JAR), new LinkOption[0]) ? standardJar : null;
        ResolvedDependency appArtifact = curateOutcomeBuildItem.getApplicationModel().getAppArtifact();
        String classifier = this.suffixToClassifier(packageConfig.computedRunnerSuffix());
        if (classifier != null && !classifier.isEmpty()) {
            appArtifact = ((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(appArtifact.getGroupId())).setArtifactId(appArtifact.getArtifactId())).setClassifier(classifier)).setType(appArtifact.getType())).setVersion(appArtifact.getVersion())).setResolvedPaths(appArtifact.getResolvedPaths()).addDependencies(appArtifact.getDependencies()).setWorkspaceModule(appArtifact.getWorkspaceModule()).setFlags(appArtifact.getFlags())).build();
        }
        ApplicationManifestConfig manifestConfig = ApplicationManifestConfig.builder().setApplicationModel(curateOutcomeBuildItem.getApplicationModel()).setMainComponent(ApplicationComponent.builder().setPath(runnerJar).setResolvedDependency(appArtifact).build()).setRunnerPath(runnerJar).build();
        return new JarBuildItem(runnerJar, originalJar, null, PackageConfig.JarConfig.JarType.UBER_JAR, this.suffixToClassifier(packageConfig.computedRunnerSuffix()), manifestConfig);
    }

    private String suffixToClassifier(String suffix) {
        return suffix.startsWith("-") ? suffix.substring(1) : suffix;
    }

    private void buildUberJar0(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, PackageConfig packageConfig, ApplicationInfoBuildItem applicationInfo, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, List<UberJarMergedResourceBuildItem> mergedResources, List<UberJarIgnoredResourceBuildItem> ignoredResources, MainClassBuildItem mainClassBuildItem, ClassLoadingConfig classLoadingConfig, Path runnerJar) throws Exception {
        block30: {
            try (FileSystem runnerZipFs = JarResultBuildStep.createNewZip(runnerJar, packageConfig);){
                log.info((Object)("Building uber jar: " + runnerJar));
                HashMap<String, String> seen = new HashMap<String, String>();
                HashMap<String, Set<Dependency>> duplicateCatcher = new HashMap<String, Set<Dependency>>();
                HashMap<String, List<byte[]>> concatenatedEntries = new HashMap<String, List<byte[]>>();
                Set<String> mergeResourcePaths = mergedResources.stream().map(UberJarMergedResourceBuildItem::getPath).collect(Collectors.toSet());
                Set<ArtifactKey> removed = this.getRemovedKeys(classLoadingConfig);
                final HashSet ignoredEntries = new HashSet();
                packageConfig.jar().userConfiguredIgnoredEntries().ifPresent(ignoredEntries::addAll);
                ignoredResources.stream().map(UberJarIgnoredResourceBuildItem::getPath).forEach(ignoredEntries::add);
                Predicate<String> allIgnoredEntriesPredicate = new Predicate<String>(){

                    @Override
                    public boolean test(String path) {
                        return UBER_JAR_IGNORED_ENTRIES_PREDICATE.test(path) || ignoredEntries.contains(path);
                    }
                };
                ResolvedDependency appArtifact = curateOutcomeBuildItem.getApplicationModel().getAppArtifact();
                this.generateManifest(runnerZipFs, "", packageConfig, appArtifact, mainClassBuildItem.getClassName(), applicationInfo);
                for (Object appDep : curateOutcomeBuildItem.getApplicationModel().getRuntimeDependencies()) {
                    if (!JarResultBuildStep.includeAppDep((ResolvedDependency)appDep, outputTargetBuildItem.getIncludedOptionalDependencies(), removed)) continue;
                    for (Path resolvedDep : appDep.getResolvedPaths()) {
                        HashSet<String> existingEntries = new HashSet<String>();
                        Set<String> transformedFilesByJar = transformedClasses.getTransformedFilesByJar().get(resolvedDep);
                        if (transformedFilesByJar != null) {
                            existingEntries.addAll(transformedFilesByJar);
                        }
                        generatedResources.stream().map(GeneratedResourceBuildItem::getName).forEach(existingEntries::add);
                        if (!Files.isDirectory(resolvedDep, new LinkOption[0])) {
                            FileSystem artifactFs = ZipUtils.newFileSystem((Path)resolvedDep);
                            try {
                                for (Path root : artifactFs.getRootDirectories()) {
                                    this.walkFileDependencyForDependency(root, runnerZipFs, seen, duplicateCatcher, concatenatedEntries, allIgnoredEntriesPredicate, (Dependency)appDep, existingEntries, mergeResourcePaths);
                                }
                                continue;
                            }
                            finally {
                                if (artifactFs != null) {
                                    artifactFs.close();
                                }
                                continue;
                            }
                        }
                        this.walkFileDependencyForDependency(resolvedDep, runnerZipFs, seen, duplicateCatcher, concatenatedEntries, allIgnoredEntriesPredicate, (Dependency)appDep, existingEntries, mergeResourcePaths);
                    }
                }
                HashSet<Set> explained = new HashSet<Set>();
                for (Map.Entry entry : duplicateCatcher.entrySet()) {
                    if (((Set)entry.getValue()).size() <= 1 || !explained.add((Set)entry.getValue())) continue;
                    log.warn((Object)("Dependencies with duplicate files detected. The dependencies " + entry.getValue() + " contain duplicate files, e.g. " + (String)entry.getKey()));
                }
                this.copyCommonContent(runnerZipFs, concatenatedEntries, applicationArchivesBuildItem, transformedClasses, generatedClasses, generatedResources, seen, allIgnoredEntriesPredicate);
                if (!Files.isDirectory(runnerZipFs.getPath("META-INF", "versions"), new LinkOption[0])) break block30;
                log.debug((Object)"uber jar will be marked as multi-release jar");
                Path manifestPath = runnerZipFs.getPath("META-INF", "MANIFEST.MF");
                Manifest manifest = new Manifest();
                try (InputStream is = Files.newInputStream(manifestPath, new OpenOption[0]);){
                    manifest.read(is);
                }
                manifest.getMainAttributes().put(Attributes.Name.MULTI_RELEASE, "true");
                try (OutputStream os = Files.newOutputStream(manifestPath, new OpenOption[0]);){
                    manifest.write(os);
                }
            }
        }
        runnerJar.toFile().setReadable(true, false);
    }

    private static boolean includeAppDep(ResolvedDependency appDep, Optional<Set<ArtifactKey>> optionalDependencies, Set<ArtifactKey> removedArtifacts) {
        if (!appDep.isJar()) {
            return false;
        }
        if (appDep.isOptional()) {
            return optionalDependencies.map(appArtifactKeys -> appArtifactKeys.contains(appDep.getKey())).orElse(true);
        }
        return !removedArtifacts.contains(appDep.getKey());
    }

    private void walkFileDependencyForDependency(final Path root, final FileSystem runnerZipFs, final Map<String, String> seen, final Map<String, Set<Dependency>> duplicateCatcher, final Map<String, List<byte[]>> concatenatedEntries, final Predicate<String> ignoredEntriesPredicate, final Dependency appDep, final Set<String> existingEntries, final Set<String> mergeResourcePaths) throws IOException {
        final Path metaInfDir = root.resolve("META-INF");
        Files.walkFileTree(root, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String relativePath = JarResultBuildStep.toUri(root.relativize(dir));
                if (!relativePath.isEmpty()) {
                    JarResultBuildStep.this.addDir(runnerZipFs, relativePath);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String relativePath = JarResultBuildStep.toUri(root.relativize(file));
                if (JarResultBuildStep.isBlockOrSF(relativePath) && file.relativize(metaInfDir).getNameCount() == 1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Signature file " + file.toAbsolutePath() + " from app dependency " + appDep + " will not be included in uberjar"));
                    }
                    return FileVisitResult.CONTINUE;
                }
                if (!existingEntries.contains(relativePath)) {
                    if (UBER_JAR_CONCATENATED_ENTRIES_PREDICATE.test(relativePath) || mergeResourcePaths.contains(relativePath)) {
                        concatenatedEntries.computeIfAbsent(relativePath, u -> new ArrayList()).add(Files.readAllBytes(file));
                        return FileVisitResult.CONTINUE;
                    }
                    if (!ignoredEntriesPredicate.test(relativePath)) {
                        duplicateCatcher.computeIfAbsent(relativePath, a -> new HashSet()).add(appDep);
                        if (!seen.containsKey(relativePath)) {
                            seen.put(relativePath, appDep.toString());
                            Files.copy(file, runnerZipFs.getPath(relativePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private JarBuildItem buildLegacyThinJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, PackageConfig packageConfig, ApplicationInfoBuildItem applicationInfo, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, MainClassBuildItem mainClassBuildItem, ClassLoadingConfig classLoadingConfig) throws Exception {
        Path runnerJar = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + packageConfig.computedRunnerSuffix() + DOT_JAR);
        Path libDir = outputTargetBuildItem.getOutputDirectory().resolve(LIB);
        Files.deleteIfExists(runnerJar);
        IoUtils.createOrEmptyDir((Path)libDir);
        try (FileSystem runnerZipFs = JarResultBuildStep.createNewZip(runnerJar, packageConfig);){
            log.info((Object)("Building thin jar: " + runnerJar));
            this.doLegacyThinJarGeneration(curateOutcomeBuildItem, outputTargetBuildItem, transformedClasses, applicationArchivesBuildItem, applicationInfo, packageConfig, generatedResources, libDir, generatedClasses, runnerZipFs, mainClassBuildItem, classLoadingConfig);
        }
        runnerJar.toFile().setReadable(true, false);
        return new JarBuildItem(runnerJar, null, libDir, packageConfig.jar().type(), this.suffixToClassifier(packageConfig.computedRunnerSuffix()));
    }

    private JarBuildItem buildThinJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, PackageConfig packageConfig, ClassLoadingConfig classLoadingConfig, ApplicationInfoBuildItem applicationInfo, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchiveBuildItems, MainClassBuildItem mainClassBuildItem) throws Exception {
        List lines;
        boolean mutableJar;
        FileSystem out;
        boolean rebuild = outputTargetBuildItem.isRebuild();
        Path buildDir = packageConfig.outputDirectory().isPresent() ? outputTargetBuildItem.getOutputDirectory() : outputTargetBuildItem.getOutputDirectory().resolve(DEFAULT_FAST_JAR_DIRECTORY_NAME);
        ApplicationManifestConfig.Builder manifestConfig = ApplicationManifestConfig.builder().setApplicationModel(curateOutcomeBuildItem.getApplicationModel()).setDistributionDirectory(buildDir);
        Path libDir = buildDir.resolve(LIB);
        Path mainLib = libDir.resolve(MAIN);
        Path baseLib = libDir.resolve(BOOT_LIB);
        Files.createDirectories(baseLib, new FileAttribute[0]);
        Path appDir = buildDir.resolve(APP);
        Path quarkus = buildDir.resolve(QUARKUS);
        Path userProviders = null;
        if (packageConfig.jar().userProvidersDirectory().isPresent()) {
            userProviders = buildDir.resolve(packageConfig.jar().userProvidersDirectory().get());
        }
        if (!rebuild) {
            IoUtils.createOrEmptyDir((Path)buildDir);
            Files.createDirectories(mainLib, new FileAttribute[0]);
            Files.createDirectories(baseLib, new FileAttribute[0]);
            Files.createDirectories(appDir, new FileAttribute[0]);
            Files.createDirectories(quarkus, new FileAttribute[0]);
            if (userProviders != null) {
                Files.createDirectories(userProviders, new FileAttribute[0]);
                Path keepFile = userProviders.resolve(".keep");
                if (!keepFile.toFile().exists()) {
                    Files.createFile(keepFile, new FileAttribute[0]);
                }
            }
        } else {
            IoUtils.createOrEmptyDir((Path)quarkus);
        }
        Path decompiledOutputDir = null;
        boolean wasDecompiledSuccessfully = true;
        Decompiler.VineflowerDecompiler decompiler = null;
        PackageConfig.DecompilerConfig decompilerConfig = packageConfig.jar().decompiler();
        if (decompilerConfig.enabled()) {
            decompiledOutputDir = buildDir.getParent().resolve(decompilerConfig.outputDirectory());
            FileUtil.deleteDirectory(decompiledOutputDir);
            Files.createDirectory(decompiledOutputDir, new FileAttribute[0]);
            decompiler = new Decompiler.VineflowerDecompiler();
            Path jarDirectory = Paths.get(decompilerConfig.jarDirectory(), new String[0]);
            if (!Files.exists(jarDirectory, new LinkOption[0])) {
                Files.createDirectory(jarDirectory, new FileAttribute[0]);
            }
            decompiler.init(new Decompiler.Context(VINEFLOWER_VERSION, jarDirectory, decompiledOutputDir));
            decompiler.downloadIfNecessary();
        }
        FastJarJars.FastJarJarsBuilder fastJarJarsBuilder = new FastJarJars.FastJarJarsBuilder();
        ArrayList parentFirst = new ArrayList();
        if (!transformedClasses.getTransformedClassesByJar().isEmpty()) {
            Path transformedZip = quarkus.resolve(TRANSFORMED_BYTECODE_JAR);
            fastJarJarsBuilder.setTransformed(transformedZip);
            out = JarResultBuildStep.createNewZip(transformedZip, packageConfig);
            try {
                for (Set set : transformedClasses.getTransformedClassesByJar().values()) {
                    for (TransformedClassesBuildItem.TransformedClass transformed : set) {
                        Iterator<AdditionalApplicationArchiveBuildItem> target = out.getPath(transformed.getFileName(), new String[0]);
                        if (transformed.getData() == null) continue;
                        if (target.getParent() != null) {
                            Files.createDirectories(target.getParent(), new FileAttribute[0]);
                        }
                        Files.write((Path)((Object)target), transformed.getData(), new OpenOption[0]);
                    }
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            if (decompiler != null) {
                wasDecompiledSuccessfully = decompiler.decompile(transformedZip);
            }
        }
        Path generatedZip = quarkus.resolve(GENERATED_BYTECODE_JAR);
        fastJarJarsBuilder.setGenerated(generatedZip);
        out = JarResultBuildStep.createNewZip(generatedZip, packageConfig);
        try {
            for (GeneratedClassBuildItem generatedClassBuildItem : generatedClasses) {
                String fileName = ClassLoaderHelper.fromClassNameToResourceName((String)generatedClassBuildItem.getName());
                Path target = out.getPath(fileName, new String[0]);
                if (target.getParent() != null) {
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                }
                Files.write(target, generatedClassBuildItem.getClassData(), new OpenOption[0]);
            }
            for (GeneratedResourceBuildItem generatedResourceBuildItem : generatedResources) {
                Path target = out.getPath(generatedResourceBuildItem.getName(), new String[0]);
                if (target.getParent() != null) {
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                }
                Files.write(target, generatedResourceBuildItem.getData(), new OpenOption[0]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        if (decompiler != null) {
            wasDecompiledSuccessfully &= decompiler.decompile(generatedZip);
        }
        if (wasDecompiledSuccessfully && decompiledOutputDir != null) {
            log.info((Object)("The decompiled output can be found at: " + decompiledOutputDir.toAbsolutePath().toString()));
        }
        Path runnerJar = appDir.resolve(outputTargetBuildItem.getBaseName() + DOT_JAR);
        fastJarJarsBuilder.setRunner(runnerJar);
        if (!rebuild) {
            Predicate<String> ignoredEntriesPredicate = this.getThinJarIgnoredEntriesPredicate(packageConfig);
            try (FileSystem fileSystem = JarResultBuildStep.createNewZip(runnerJar, packageConfig);){
                this.copyFiles(applicationArchivesBuildItem.getRootArchive(), fileSystem, null, ignoredEntriesPredicate);
            }
        }
        Set<ArtifactKey> parentFirstKeys = this.getParentFirstKeys(curateOutcomeBuildItem, classLoadingConfig);
        StringBuilder stringBuilder = new StringBuilder();
        Set<ArtifactKey> removed = this.getRemovedKeys(classLoadingConfig);
        HashMap<ArtifactKey, List<Path>> copiedArtifacts = new HashMap<ArtifactKey, List<Path>>();
        for (ResolvedDependency appDep : curateOutcomeBuildItem.getApplicationModel().getRuntimeDependencies()) {
            if (!rebuild) {
                this.copyDependency(parentFirstKeys, outputTargetBuildItem, copiedArtifacts, mainLib, baseLib, fastJarJarsBuilder::addDep, true, stringBuilder, appDep, transformedClasses, removed, packageConfig, manifestConfig);
            } else if (JarResultBuildStep.includeAppDep(appDep, outputTargetBuildItem.getIncludedOptionalDependencies(), removed)) {
                appDep.getResolvedPaths().forEach(fastJarJarsBuilder::addDep);
            }
            if (!parentFirstKeys.contains(appDep.getKey())) continue;
            appDep.getResolvedPaths().forEach(parentFirst::add);
        }
        for (AdditionalApplicationArchiveBuildItem i : additionalApplicationArchiveBuildItems) {
            for (Path path : i.getResolvedPaths()) {
                if (!path.getParent().equals(userProviders)) {
                    throw new RuntimeException("Additional application archives can only be provided from the user providers directory. " + path + " is not present in " + userProviders);
                }
                fastJarJarsBuilder.addDep(path);
            }
        }
        ArrayList<String> nonExistentResources = new ArrayList<String>(1);
        Enumeration<URL> mpConfigURLs = Thread.currentThread().getContextClassLoader().getResources(MP_CONFIG_FILE);
        if (!mpConfigURLs.hasMoreElements()) {
            nonExistentResources.add(MP_CONFIG_FILE);
        }
        Path appInfo = buildDir.resolve("quarkus/quarkus-application.dat");
        try (OutputStream out2 = Files.newOutputStream(appInfo, new OpenOption[0]);){
            FastJarJars fastJarJars = fastJarJarsBuilder.build();
            ArrayList<Path> allJars = new ArrayList<Path>();
            if (fastJarJars.transformed != null) {
                allJars.add(fastJarJars.transformed);
            }
            allJars.add(fastJarJars.generated);
            allJars.add(fastJarJars.runner);
            ArrayList<Path> sortedDeps = new ArrayList<Path>(fastJarJars.deps);
            Collections.sort(sortedDeps);
            allJars.addAll(sortedDeps);
            ArrayList sortedParentFirst = new ArrayList(parentFirst);
            Collections.sort(sortedParentFirst);
            ArrayList arrayList = new ArrayList(nonExistentResources);
            Collections.sort(arrayList);
            SerializedApplication.write((OutputStream)out2, (String)mainClassBuildItem.getClassName(), (Path)buildDir, allJars, sortedParentFirst, arrayList);
        }
        runnerJar.toFile().setReadable(true, false);
        Path initJar = buildDir.resolve(QUARKUS_RUN_JAR);
        manifestConfig.setMainComponent((ApplicationComponent)ApplicationComponent.builder().setPath(initJar)).setRunnerPath(initJar);
        boolean bl = mutableJar = packageConfig.jar().type() == PackageConfig.JarConfig.JarType.MUTABLE_JAR;
        if (mutableJar) {
            ByteArrayOutputStream out3 = new ByteArrayOutputStream();
            outputTargetBuildItem.getBuildSystemProperties().store(out3, null);
            lines = Arrays.stream(out3.toString(StandardCharsets.UTF_8).split("\n")).filter(s -> !s.startsWith("#")).sorted().collect(Collectors.toList());
            Path buildSystemProps = quarkus.resolve(BUILD_SYSTEM_PROPERTIES);
            manifestConfig.addComponent((ApplicationComponent)ApplicationComponent.builder().setPath(buildSystemProps).setDevelopmentScope());
            try (OutputStream outputStream = Files.newOutputStream(buildSystemProps, new OpenOption[0]);){
                outputStream.write(String.join((CharSequence)"\n", lines).getBytes(StandardCharsets.UTF_8));
            }
        }
        if (!rebuild) {
            try (FileSystem runnerZipFs = JarResultBuildStep.createNewZip(initJar, packageConfig);){
                ResolvedDependency appArtifact = curateOutcomeBuildItem.getApplicationModel().getAppArtifact();
                this.generateManifest(runnerZipFs, stringBuilder.toString(), packageConfig, appArtifact, QuarkusEntryPoint.class.getName(), applicationInfo);
            }
            if (mutableJar) {
                Path deploymentLib = libDir.resolve(DEPLOYMENT_LIB);
                Files.createDirectories(deploymentLib, new FileAttribute[0]);
                for (Object appDep : curateOutcomeBuildItem.getApplicationModel().getDependencies()) {
                    this.copyDependency(parentFirstKeys, outputTargetBuildItem, copiedArtifacts, deploymentLib, baseLib, p -> {}, false, stringBuilder, (ResolvedDependency)appDep, new TransformedClassesBuildItem(Map.of()), removed, packageConfig, manifestConfig);
                }
                HashMap relativePaths = new HashMap();
                for (Map.Entry entry : copiedArtifacts.entrySet()) {
                    relativePaths.put((ArtifactKey)entry.getKey(), ((List)entry.getValue()).stream().map(s -> buildDir.relativize((Path)s).toString().replace('\\', '/')).collect(Collectors.toList()));
                }
                MutableJarApplicationModel model = new MutableJarApplicationModel(outputTargetBuildItem.getBaseName(), relativePaths, curateOutcomeBuildItem.getApplicationModel(), (String)packageConfig.jar().userProvidersDirectory().orElse(null), buildDir.relativize(runnerJar).toString());
                Path path = deploymentLib.resolve(APPMODEL_DAT);
                manifestConfig.addComponent((ApplicationComponent)ApplicationComponent.builder().setPath(path).setDevelopmentScope());
                try (OutputStream out4 = Files.newOutputStream(path, new OpenOption[0]);){
                    ObjectOutputStream obj = new ObjectOutputStream(out4);
                    obj.writeObject(model);
                    obj.close();
                }
                Path deploymentCp = deploymentLib.resolve(DEPLOYMENT_CLASS_PATH_DAT);
                manifestConfig.addComponent((ApplicationComponent)ApplicationComponent.builder().setPath(deploymentCp).setDevelopmentScope());
                try (OutputStream out5 = Files.newOutputStream(deploymentCp, new OpenOption[0]);){
                    ObjectOutputStream obj = new ObjectOutputStream(out5);
                    ArrayList paths = new ArrayList();
                    for (ResolvedDependency i : curateOutcomeBuildItem.getApplicationModel().getDependencies()) {
                        List list = (List)relativePaths.get(i.getKey());
                        if (list == null) continue;
                        paths.addAll(list);
                    }
                    obj.writeObject(paths);
                    obj.close();
                }
            }
            if (packageConfig.jar().includeDependencyList()) {
                Path deplist = buildDir.resolve(QUARKUS_APP_DEPS);
                lines = new ArrayList();
                for (ResolvedDependency resolvedDependency : curateOutcomeBuildItem.getApplicationModel().getRuntimeDependencies()) {
                    lines.add(resolvedDependency.toGACTVString());
                }
                lines.sort(Comparator.naturalOrder());
                Files.write(deplist, lines, new OpenOption[0]);
            }
        }
        try (Stream<Path> files = Files.walk(buildDir, new FileVisitOption[0]);){
            files.forEach(new Consumer<Path>(){

                @Override
                public void accept(Path path) {
                    path.toFile().setReadable(true, false);
                }
            });
        }
        return new JarBuildItem(initJar, null, libDir, packageConfig.jar().type(), null, manifestConfig.build());
    }

    private Set<ArtifactKey> getParentFirstKeys(CurateOutcomeBuildItem curateOutcomeBuildItem, ClassLoadingConfig classLoadingConfig) {
        HashSet<ArtifactKey> parentFirstKeys = new HashSet<ArtifactKey>();
        curateOutcomeBuildItem.getApplicationModel().getDependencies().forEach(d -> {
            if (d.isFlagSet(512)) {
                parentFirstKeys.add(d.getKey());
            }
        });
        classLoadingConfig.parentFirstArtifacts.ifPresent(parentFirstArtifacts -> {
            for (String artifact : parentFirstArtifacts) {
                parentFirstKeys.add((ArtifactKey)new GACT(artifact.split(":")));
            }
        });
        return parentFirstKeys;
    }

    private Set<ArtifactKey> getRemovedKeys(ClassLoadingConfig classLoadingConfig) {
        HashSet<ArtifactKey> removed = new HashSet<ArtifactKey>();
        classLoadingConfig.removedArtifacts.ifPresent(removedArtifacts -> {
            for (String artifact : removedArtifacts) {
                removed.add((ArtifactKey)new GACT(artifact.split(":")));
            }
        });
        return removed;
    }

    private void copyDependency(Set<ArtifactKey> parentFirstArtifacts, OutputTargetBuildItem outputTargetBuildItem, Map<ArtifactKey, List<Path>> runtimeArtifacts, Path libDir, Path baseLib, Consumer<Path> targetPathConsumer, boolean allowParentFirst, StringBuilder classPath, ResolvedDependency appDep, TransformedClassesBuildItem transformedClasses, Set<ArtifactKey> removedDeps, PackageConfig packageConfig, ApplicationManifestConfig.Builder manifestConfig) throws IOException {
        if (!JarResultBuildStep.includeAppDep(appDep, outputTargetBuildItem.getIncludedOptionalDependencies(), removedDeps)) {
            return;
        }
        if (runtimeArtifacts.containsKey(appDep.getKey())) {
            return;
        }
        for (Path resolvedDep : appDep.getResolvedPaths()) {
            Path targetPath;
            String fileName = appDep.getGroupId() + "." + resolvedDep.getFileName();
            if (allowParentFirst && parentFirstArtifacts.contains(appDep.getKey())) {
                targetPath = baseLib.resolve(fileName);
                classPath.append(" ").append(LIB).append("/").append(BOOT_LIB).append("/").append(fileName);
            } else {
                targetPath = libDir.resolve(fileName);
                targetPathConsumer.accept(targetPath);
            }
            runtimeArtifacts.computeIfAbsent(appDep.getKey(), s -> new ArrayList(1)).add(targetPath);
            if (Files.isDirectory(resolvedDep, new LinkOption[0])) {
                this.packageClasses(resolvedDep, targetPath, packageConfig);
                continue;
            }
            Set<TransformedClassesBuildItem.TransformedClass> transformedFromThisArchive = transformedClasses.getTransformedClassesByJar().get(resolvedDep);
            HashSet<String> removedFromThisArchive = new HashSet<String>();
            if (transformedFromThisArchive != null) {
                for (TransformedClassesBuildItem.TransformedClass i : transformedFromThisArchive) {
                    if (i.getData() != null) continue;
                    removedFromThisArchive.add(i.getFileName());
                }
            }
            ApplicationComponent.Builder appComponent = ApplicationComponent.builder().setPath(targetPath).setResolvedDependency(appDep);
            if (removedFromThisArchive.isEmpty()) {
                Files.copy(resolvedDep, targetPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            } else {
                JarResultBuildStep.filterJarFile(resolvedDep, targetPath, removedFromThisArchive);
                ArrayList<String> list = new ArrayList<String>(removedFromThisArchive);
                Collections.sort(list);
                StringBuilder sb = new StringBuilder("Removed ").append(list.get(0));
                for (int i = 1; i < list.size(); ++i) {
                    sb.append(",").append(list.get(i));
                }
                appComponent.setPedigree(sb.toString());
            }
            manifestConfig.addComponent((ApplicationComponent)appComponent);
        }
    }

    private void packageClasses(final Path resolvedDep, Path targetPath, PackageConfig packageConfig) throws IOException {
        try (final FileSystem runnerZipFs = JarResultBuildStep.createNewZip(targetPath, packageConfig);){
            Files.walkFileTree(resolvedDep, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path relativePath = resolvedDep.relativize(file);
                    Path targetPath = runnerZipFs.getPath(relativePath.toString(), new String[0]);
                    if (targetPath.getParent() != null) {
                        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(file, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    @BuildStep
    public NativeImageSourceJarBuildItem buildNativeImageJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedNativeImageClassBuildItem> nativeImageResources, List<GeneratedResourceBuildItem> generatedResources, MainClassBuildItem mainClassBuildItem, ClassLoadingConfig classLoadingConfig) throws Exception {
        Path targetDirectory = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + "-native-image-source-jar");
        IoUtils.createOrEmptyDir((Path)targetDirectory);
        ArrayList<GeneratedClassBuildItem> allClasses = new ArrayList<GeneratedClassBuildItem>(generatedClasses);
        allClasses.addAll(nativeImageResources.stream().map(s -> new GeneratedClassBuildItem(true, s.getName(), s.getClassData())).collect(Collectors.toList()));
        return this.buildNativeImageThinJar(curateOutcomeBuildItem, outputTargetBuildItem, transformedClasses, applicationArchivesBuildItem, applicationInfo, packageConfig, allClasses, generatedResources, mainClassBuildItem, targetDirectory, classLoadingConfig);
    }

    private NativeImageSourceJarBuildItem buildNativeImageThinJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, List<GeneratedClassBuildItem> allClasses, List<GeneratedResourceBuildItem> generatedResources, MainClassBuildItem mainClassBuildItem, Path targetDirectory, ClassLoadingConfig classLoadingConfig) throws Exception {
        this.copyJsonConfigFiles(applicationArchivesBuildItem, targetDirectory);
        Path runnerJar = targetDirectory.resolve(outputTargetBuildItem.getBaseName() + packageConfig.computedRunnerSuffix() + DOT_JAR);
        Path libDir = targetDirectory.resolve(LIB);
        Files.createDirectories(libDir, new FileAttribute[0]);
        try (FileSystem runnerZipFs = ZipUtils.newZip((Path)runnerJar);){
            log.info((Object)("Building native image source jar: " + runnerJar));
            if (classLoadingConfig.removedArtifacts.isEmpty()) {
                classLoadingConfig.removedArtifacts = Optional.of(new ArrayList(6));
            }
            List<String> removedArtifacts = classLoadingConfig.removedArtifacts.get();
            removedArtifacts.add("org.graalvm.nativeimage:svm");
            removedArtifacts.add("org.graalvm.sdk:graal-sdk");
            removedArtifacts.add("org.graalvm.sdk:nativeimage");
            removedArtifacts.add("org.graalvm.sdk:word");
            removedArtifacts.add("org.graalvm.sdk:collections");
            if (curateOutcomeBuildItem.getApplicationModel().getDependencies().stream().anyMatch(d -> d.getGroupId().equals("org.graalvm.sdk") && d.getArtifactId().equals("graal-sdk"))) {
                log.warn((Object)"org.graalvm.sdk:graal-sdk is present in the classpath. From Quarkus 3.8 and onwards, org.graalvm.sdk:nativeimage should be preferred. Make sure you report the issue to the maintainers of the extensions that bring it.");
            }
            this.doLegacyThinJarGeneration(curateOutcomeBuildItem, outputTargetBuildItem, transformedClasses, applicationArchivesBuildItem, applicationInfo, packageConfig, generatedResources, libDir, allClasses, runnerZipFs, mainClassBuildItem, classLoadingConfig);
        }
        runnerJar.toFile().setReadable(true, false);
        return new NativeImageSourceJarBuildItem(runnerJar, libDir);
    }

    private void copyJsonConfigFiles(ApplicationArchivesBuildItem applicationArchivesBuildItem, final Path thinJarDirectory) throws IOException {
        for (Path root : applicationArchivesBuildItem.getRootArchive().getRootDirectories()) {
            Stream<Path> stream = Files.find(root, 1, IS_JSON_FILE_PREDICATE, new FileVisitOption[0]);
            try {
                stream.forEach(new Consumer<Path>(){

                    @Override
                    public void accept(Path jsonPath) {
                        try {
                            Files.createDirectories(thinJarDirectory, new FileAttribute[0]);
                            Files.copy(jsonPath, thinJarDirectory.resolve(jsonPath.getFileName().toString()), new CopyOption[0]);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException("Unable to copy json config file from " + jsonPath + " to " + thinJarDirectory, e);
                        }
                    }
                });
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
    }

    private void doLegacyThinJarGeneration(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, List<GeneratedResourceBuildItem> generatedResources, Path libDir, List<GeneratedClassBuildItem> allClasses, FileSystem runnerZipFs, MainClassBuildItem mainClassBuildItem, ClassLoadingConfig classLoadingConfig) throws IOException {
        HashMap<String, String> seen = new HashMap<String, String>();
        StringBuilder classPath = new StringBuilder();
        HashMap<String, List<byte[]>> services = new HashMap<String, List<byte[]>>();
        Collection appDeps = curateOutcomeBuildItem.getApplicationModel().getRuntimeDependencies();
        Predicate<String> ignoredEntriesPredicate = this.getThinJarIgnoredEntriesPredicate(packageConfig);
        Set<ArtifactKey> removed = this.getRemovedKeys(classLoadingConfig);
        this.copyLibraryJars(runnerZipFs, outputTargetBuildItem, transformedClasses, libDir, classPath, appDeps, services, ignoredEntriesPredicate, removed);
        ResolvedDependency appArtifact = curateOutcomeBuildItem.getApplicationModel().getAppArtifact();
        this.generateManifest(runnerZipFs, classPath.toString(), packageConfig, appArtifact, mainClassBuildItem.getClassName(), applicationInfo);
        this.copyCommonContent(runnerZipFs, services, applicationArchivesBuildItem, transformedClasses, allClasses, generatedResources, seen, ignoredEntriesPredicate);
    }

    private void copyLibraryJars(final FileSystem runnerZipFs, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, Path libDir, StringBuilder classPath, Collection<ResolvedDependency> appDeps, final Map<String, List<byte[]>> services, final Predicate<String> ignoredEntriesPredicate, Set<ArtifactKey> removedDependencies) throws IOException {
        for (ResolvedDependency appDep : appDeps) {
            if (!JarResultBuildStep.includeAppDep(appDep, outputTargetBuildItem.getIncludedOptionalDependencies(), removedDependencies)) continue;
            for (final Path resolvedDep : appDep.getResolvedPaths()) {
                if (!Files.isDirectory(resolvedDep, new LinkOption[0])) {
                    Path targetPath;
                    String fileName;
                    Set<String> transformedFromThisArchive = transformedClasses.getTransformedFilesByJar().get(resolvedDep);
                    if (transformedFromThisArchive == null || transformedFromThisArchive.isEmpty()) {
                        fileName = appDep.getGroupId() + "." + resolvedDep.getFileName();
                        targetPath = libDir.resolve(fileName);
                        Files.copy(resolvedDep, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        classPath.append(" lib/").append(fileName);
                        continue;
                    }
                    fileName = "modified-" + appDep.getGroupId() + "." + resolvedDep.getFileName();
                    targetPath = libDir.resolve(fileName);
                    classPath.append(" lib/").append(fileName);
                    JarResultBuildStep.filterJarFile(resolvedDep, targetPath, transformedFromThisArchive);
                    continue;
                }
                Files.walkFileTree(resolvedDep, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path relativePath = resolvedDep.relativize(file);
                        String relativeUri = JarResultBuildStep.toUri(relativePath);
                        if (ignoredEntriesPredicate.test(relativeUri)) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (relativeUri.startsWith("META-INF/services/") && relativeUri.length() > 18) {
                            services.computeIfAbsent(relativeUri, u -> new ArrayList()).add(Files.readAllBytes(file));
                        } else if (file.getFileName().toString().endsWith(".class")) {
                            Path targetPath = runnerZipFs.getPath(relativePath.toString(), new String[0]);
                            if (targetPath.getParent() != null) {
                                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                            }
                            Files.copy(file, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
    }

    private void copyCommonContent(FileSystem runnerZipFs, Map<String, List<byte[]>> concatenatedEntries, ApplicationArchivesBuildItem appArchives, TransformedClassesBuildItem transformedClassesBuildItem, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, Map<String, String> seen, Predicate<String> ignoredEntriesPredicate) throws IOException {
        for (Set<TransformedClassesBuildItem.TransformedClass> set : transformedClassesBuildItem.getTransformedClassesByJar().values()) {
            for (TransformedClassesBuildItem.TransformedClass i : set) {
                if (i.getData() == null) continue;
                Path target = runnerZipFs.getPath(i.getFileName(), new String[0]);
                this.handleParent(runnerZipFs, i.getFileName(), seen);
                try (OutputStream out = Files.newOutputStream(target, new OpenOption[0]);){
                    out.write(i.getData());
                }
                seen.put(i.getFileName(), "Current Application");
            }
        }
        for (GeneratedClassBuildItem generatedClassBuildItem : generatedClasses) {
            String fileName = ClassLoaderHelper.fromClassNameToResourceName((String)generatedClassBuildItem.getName());
            seen.put(fileName, "Current Application");
            Path target = runnerZipFs.getPath(fileName, new String[0]);
            this.handleParent(runnerZipFs, fileName, seen);
            if (Files.exists(target, new LinkOption[0])) continue;
            OutputStream os = Files.newOutputStream(target, new OpenOption[0]);
            try {
                os.write(generatedClassBuildItem.getClassData());
            }
            finally {
                if (os == null) continue;
                os.close();
            }
        }
        for (GeneratedResourceBuildItem generatedResourceBuildItem : generatedResources) {
            if (ignoredEntriesPredicate.test(generatedResourceBuildItem.getName())) continue;
            Path target = runnerZipFs.getPath(generatedResourceBuildItem.getName(), new String[0]);
            this.handleParent(runnerZipFs, generatedResourceBuildItem.getName(), seen);
            if (Files.exists(target, new LinkOption[0])) continue;
            if (generatedResourceBuildItem.getName().startsWith("META-INF/services/")) {
                concatenatedEntries.computeIfAbsent(generatedResourceBuildItem.getName(), u -> new ArrayList()).add(generatedResourceBuildItem.getData());
                continue;
            }
            OutputStream os = Files.newOutputStream(target, new OpenOption[0]);
            try {
                os.write(generatedResourceBuildItem.getData());
            }
            finally {
                if (os == null) continue;
                os.close();
            }
        }
        this.copyFiles(appArchives.getRootArchive(), runnerZipFs, concatenatedEntries, ignoredEntriesPredicate);
        for (Map.Entry entry : concatenatedEntries.entrySet()) {
            OutputStream os = Files.newOutputStream(runnerZipFs.getPath((String)entry.getKey(), new String[0]), new OpenOption[0]);
            try {
                for (byte[] i : (List)entry.getValue()) {
                    os.write(i);
                    os.write(10);
                }
            }
            finally {
                if (os == null) continue;
                os.close();
            }
        }
    }

    private void handleParent(FileSystem runnerZipFs, String fileName, Map<String, String> seen) throws IOException {
        for (int i = 0; i < fileName.length(); ++i) {
            String dir;
            if (fileName.charAt(i) != '/' || seen.containsKey(dir = fileName.substring(0, i))) continue;
            seen.put(dir, "Current Application");
            Files.createDirectories(runnerZipFs.getPath(dir, new String[0]), new FileAttribute[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void filterJarFile(Path resolvedDep, Path targetPath, Set<String> transformedFromThisArchive) {
        try {
            byte[] buffer = new byte[10000];
            try (JarFile in = new JarFile(resolvedDep.toFile(), false);){
                Manifest manifest = in.getManifest();
                if (manifest != null) {
                    manifest.getEntries().clear();
                } else {
                    manifest = new Manifest();
                }
                try (JarOutputStream out = new JarOutputStream(Files.newOutputStream(targetPath, new OpenOption[0]));){
                    JarEntry manifestEntry = new JarEntry("META-INF/MANIFEST.MF");
                    manifestEntry.setTime(0L);
                    out.putNextEntry(manifestEntry);
                    manifest.write(out);
                    out.closeEntry();
                    Enumeration<JarEntry> entries = in.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (!(transformedFromThisArchive.contains(entryName) || entryName.equals("META-INF/MANIFEST.MF") || entryName.equals("META-INF/INDEX.LIST") || JarResultBuildStep.isSignatureFile(entryName))) {
                            entry.setCompressedSize(-1L);
                            out.putNextEntry(entry);
                            try {
                                InputStream inStream = in.getInputStream(entry);
                                try {
                                    int r = 0;
                                    while ((r = inStream.read(buffer)) > 0) {
                                        out.write(buffer, 0, r);
                                    }
                                    continue;
                                }
                                finally {
                                    if (inStream != null) {
                                        inStream.close();
                                    }
                                    continue;
                                }
                            }
                            finally {
                                out.closeEntry();
                                continue;
                            }
                        }
                        log.debugf("Removed %s from %s", (Object)entryName, (Object)resolvedDep);
                    }
                }
                Files.setLastModifiedTime(targetPath, Files.getLastModifiedTime(resolvedDep, new LinkOption[0]));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static boolean isSignatureFile(String entry) {
        if ((entry = entry.toUpperCase()).startsWith("META-INF/") && entry.indexOf(47, "META-INF/".length()) == -1) {
            return entry.endsWith(".SF") || entry.endsWith(".DSA") || entry.endsWith(".RSA") || entry.endsWith(".EC");
        }
        return false;
    }

    private void generateManifest(FileSystem runnerZipFs, String classPath, PackageConfig config, ResolvedDependency appArtifact, String mainClassName, ApplicationInfoBuildItem applicationInfo) throws IOException {
        String existingMainClass;
        Path manifestPath = runnerZipFs.getPath("META-INF", "MANIFEST.MF");
        Manifest manifest = new Manifest();
        if (Files.exists(manifestPath, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(manifestPath, new OpenOption[0]);){
                manifest.read(is);
            }
            Files.delete(manifestPath);
        } else {
            Files.createDirectories(runnerZipFs.getPath("META-INF", new String[0]), new FileAttribute[0]);
        }
        Files.createDirectories(manifestPath.getParent(), new FileAttribute[0]);
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        for (Map.Entry<String, String> attribute : config.jar().manifest().attributes().entrySet()) {
            attributes.putValue(attribute.getKey(), attribute.getValue());
        }
        if (attributes.containsKey(Attributes.Name.CLASS_PATH)) {
            log.warn((Object)"A CLASS_PATH entry was already defined in your MANIFEST.MF or using the property quarkus.package.jar.manifest.attributes.\"Class-Path\". Quarkus has overwritten this existing entry.");
        }
        attributes.put(Attributes.Name.CLASS_PATH, classPath);
        if (attributes.containsKey(Attributes.Name.MAIN_CLASS) && !mainClassName.equals(existingMainClass = attributes.getValue(Attributes.Name.MAIN_CLASS))) {
            log.warn((Object)"A MAIN_CLASS entry was already defined in your MANIFEST.MF or using the property quarkus.package.jar.manifest.attributes.\"Main-Class\". Quarkus has overwritten your existing entry.");
        }
        attributes.put(Attributes.Name.MAIN_CLASS, mainClassName);
        if (config.jar().manifest().addImplementationEntries() && !attributes.containsKey(Attributes.Name.IMPLEMENTATION_TITLE)) {
            String name = "<<unset>>".equals(applicationInfo.getName()) ? appArtifact.getArtifactId() : applicationInfo.getName();
            attributes.put(Attributes.Name.IMPLEMENTATION_TITLE, name);
        }
        if (config.jar().manifest().addImplementationEntries() && !attributes.containsKey(Attributes.Name.IMPLEMENTATION_VERSION)) {
            String version = "<<unset>>".equals(applicationInfo.getVersion()) ? appArtifact.getVersion() : applicationInfo.getVersion();
            attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, version);
        }
        for (String sectionName : config.jar().manifest().sections().keySet()) {
            for (Map.Entry<String, String> entry : config.jar().manifest().sections().get(sectionName).entrySet()) {
                Attributes attribs = manifest.getEntries().computeIfAbsent(sectionName, k -> new Attributes());
                attribs.putValue(entry.getKey(), entry.getValue());
            }
        }
        try (OutputStream os = Files.newOutputStream(manifestPath, new OpenOption[0]);){
            manifest.write(os);
        }
    }

    private void copyFiles(ApplicationArchive archive, final FileSystem fs, final Map<String, List<byte[]>> services, final Predicate<String> ignoredEntriesPredicate) throws IOException {
        try {
            archive.accept(tree -> tree.walk(new PathVisitor(){

                public void visitPath(PathVisit visit) {
                    block8: {
                        Path file = visit.getRoot().relativize(visit.getPath());
                        String relativePath = JarResultBuildStep.toUri(file);
                        if (relativePath.isEmpty() || ignoredEntriesPredicate.test(relativePath)) {
                            return;
                        }
                        try {
                            Path target;
                            if (Files.isDirectory(visit.getPath(), new LinkOption[0])) {
                                JarResultBuildStep.this.addDir(fs, relativePath);
                                break block8;
                            }
                            if (relativePath.startsWith("META-INF/services/") && relativePath.length() > 18 && services != null) {
                                byte[] content;
                                try {
                                    content = Files.readAllBytes(visit.getPath());
                                }
                                catch (IOException e) {
                                    throw new UncheckedIOException(e);
                                }
                                services.computeIfAbsent(relativePath, u -> new ArrayList()).add(content);
                                break block8;
                            }
                            if (!relativePath.equals("META-INF/INDEX.LIST") && !Files.exists(target = fs.getPath(relativePath, new String[0]), new LinkOption[0])) {
                                Files.copy(visit.getPath(), target, StandardCopyOption.REPLACE_EXISTING);
                            }
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                }
            }));
        }
        catch (RuntimeException re) {
            Throwable cause = re.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw re;
        }
    }

    private void addDir(FileSystem fs, String relativePath) throws IOException {
        block2: {
            Path targetDir = fs.getPath(relativePath, new String[0]);
            try {
                Files.createDirectory(targetDir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                throw e;
            }
        }
    }

    private static String toUri(Path path) {
        if (path.isAbsolute()) {
            return path.toUri().getPath();
        }
        if (path.getNameCount() == 0) {
            return "";
        }
        return JarResultBuildStep.toUri(new StringBuilder(), path, 0).toString();
    }

    private static StringBuilder toUri(StringBuilder b, Path path, int seg) {
        b.append(path.getName(seg));
        if (seg < path.getNameCount() - 1) {
            b.append('/');
            JarResultBuildStep.toUri(b, path, seg + 1);
        }
        return b;
    }

    static boolean isBlockOrSF(String s) {
        if (s == null) {
            return false;
        }
        return s.endsWith(".SF") || s.endsWith(".DSA") || s.endsWith(".RSA") || s.endsWith(".EC");
    }

    private Predicate<String> getThinJarIgnoredEntriesPredicate(PackageConfig packageConfig) {
        return packageConfig.jar().userConfiguredIgnoredEntries().map(Set::copyOf).orElse(Set.of())::contains;
    }

    private static FileSystem createNewZip(Path runnerJar, PackageConfig config) throws IOException {
        boolean useUncompressedJar;
        boolean bl = useUncompressedJar = !config.jar().compress();
        if (useUncompressedJar) {
            return ZipUtils.newZip((Path)runnerJar, Map.of("compressionMethod", "STORED"));
        }
        return ZipUtils.newZip((Path)runnerJar);
    }

    private static interface Decompiler {
        public void init(Context var1);

        public boolean downloadIfNecessary();

        public boolean decompile(Path var1);

        public static class VineflowerDecompiler
        implements Decompiler {
            private Context context;
            private Path decompilerJar;

            @Override
            public void init(Context context) {
                this.context = context;
                this.decompilerJar = context.jarLocation.resolve(String.format("vineflower-%s.jar", context.versionStr));
            }

            /*
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean downloadIfNecessary() {
                if (Files.exists(this.decompilerJar, new LinkOption[0])) {
                    return true;
                }
                String downloadURL = String.format("https://repo.maven.apache.org/maven2/org/vineflower/vineflower/%s/vineflower-%s.jar", this.context.versionStr, this.context.versionStr);
                try (BufferedInputStream in = new BufferedInputStream(new URL(downloadURL).openStream());){
                    boolean bl;
                    block14: {
                        OutputStream fileOutputStream = Files.newOutputStream(this.decompilerJar, new OpenOption[0]);
                        try {
                            in.transferTo(fileOutputStream);
                            bl = true;
                            if (fileOutputStream == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (fileOutputStream != null) {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        fileOutputStream.close();
                    }
                    return bl;
                }
                catch (IOException e) {
                    log.error((Object)("Unable to download Vineflower from " + downloadURL), (Throwable)e);
                    return false;
                }
            }

            @Override
            public boolean decompile(Path jarToDecompile) {
                int exitCode;
                try {
                    int dotIndex = jarToDecompile.getFileName().toString().indexOf(46);
                    String fileName = jarToDecompile.getFileName().toString().substring(0, dotIndex);
                    ProcessBuilder processBuilder = new ProcessBuilder(Arrays.asList(JavaBinFinder.findBin(), "-jar", this.decompilerJar.toAbsolutePath().toString(), "-rsy=0", "-rbr=0", jarToDecompile.toAbsolutePath().toString(), this.context.decompiledOutputDir.resolve(fileName).toAbsolutePath().toString()));
                    if (log.isDebugEnabled()) {
                        processBuilder.inheritIO();
                    } else {
                        processBuilder.redirectError(ProcessBuilder.Redirect.DISCARD.file()).redirectOutput(ProcessBuilder.Redirect.DISCARD.file());
                    }
                    exitCode = processBuilder.start().waitFor();
                }
                catch (Exception e) {
                    log.error((Object)"Failed to launch decompiler.", (Throwable)e);
                    return false;
                }
                if (exitCode != 0) {
                    log.errorf("Vineflower decompiler exited with error code: %d.", (Object)exitCode);
                    return false;
                }
                return true;
            }
        }

        public static class Context {
            final String versionStr;
            final Path jarLocation;
            final Path decompiledOutputDir;

            public Context(String versionStr, Path jarLocation, Path decompiledOutputDir) {
                this.versionStr = versionStr;
                this.jarLocation = jarLocation;
                this.decompiledOutputDir = decompiledOutputDir;
            }
        }
    }

    static class FastJarJars {
        private final Path transformed;
        private final Path generated;
        private final Path runner;
        private final List<Path> deps;

        public FastJarJars(FastJarJarsBuilder builder) {
            this.transformed = builder.transformed;
            this.generated = builder.generated;
            this.runner = builder.runner;
            this.deps = builder.deps;
        }

        public static class FastJarJarsBuilder {
            private Path transformed;
            private Path generated;
            private Path runner;
            private final List<Path> deps = new ArrayList<Path>();

            public FastJarJarsBuilder setTransformed(Path transformed) {
                this.transformed = transformed;
                return this;
            }

            public FastJarJarsBuilder setGenerated(Path generated) {
                this.generated = generated;
                return this;
            }

            public FastJarJarsBuilder setRunner(Path runner) {
                this.runner = runner;
                return this;
            }

            public FastJarJarsBuilder addDep(Path dep) {
                this.deps.add(dep);
                return this;
            }

            public FastJarJars build() {
                return new FastJarJars(this);
            }
        }
    }

    private static class IsEntryIgnoredForUberJarPredicate
    implements Predicate<String> {
        private static final Set<String> UBER_JAR_IGNORED_ENTRIES = Set.of("META-INF/INDEX.LIST", "META-INF/MANIFEST.MF", "module-info.class", "META-INF/LICENSE", "META-INF/LICENSE.txt", "META-INF/LICENSE.md", "META-INF/LGPL-3.0.txt", "META-INF/ASL-2.0.txt", "META-INF/NOTICE", "META-INF/NOTICE.txt", "META-INF/NOTICE.md", "META-INF/README", "META-INF/README.txt", "META-INF/README.md", "META-INF/DEPENDENCIES", "META-INF/DEPENDENCIES.txt", "META-INF/beans.xml", "META-INF/quarkus-config-roots.list", "META-INF/quarkus-javadoc.properties", "META-INF/quarkus-extension.properties", "META-INF/quarkus-extension.json", "META-INF/quarkus-extension.yaml", "META-INF/quarkus-deployment-dependency.graph", "META-INF/jandex.idx", "META-INF/panache-archive.marker", "META-INF/build.metadata", "LICENSE");

        private IsEntryIgnoredForUberJarPredicate() {
        }

        @Override
        public boolean test(String path) {
            return UBER_JAR_IGNORED_ENTRIES.contains(path) || path.endsWith("module-info.class");
        }
    }

    private static class IsJsonFilePredicate
    implements BiPredicate<Path, BasicFileAttributes> {
        private IsJsonFilePredicate() {
        }

        @Override
        public boolean test(Path path, BasicFileAttributes basicFileAttributes) {
            return basicFileAttributes.isRegularFile() && path.toString().endsWith(".json");
        }
    }

    static class JarRequired
    implements BooleanSupplier {
        private final PackageConfig packageConfig;

        JarRequired(PackageConfig packageConfig) {
            this.packageConfig = packageConfig;
        }

        @Override
        public boolean getAsBoolean() {
            return this.packageConfig.jar().enabled();
        }
    }
}

